/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.websocket.client;

import ai.h2o.org.eclipse.jetty.client.HttpClient;
import ai.h2o.org.eclipse.jetty.util.ssl.SslContextFactory;
import ai.h2o.org.eclipse.jetty.util.thread.QueuedThreadPool;
import ai.h2o.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import java.util.concurrent.Executor;

class DefaultHttpClientProvider {
    DefaultHttpClientProvider() {
    }

    public static HttpClient newHttpClient(WebSocketContainerScope scope) {
        SslContextFactory sslContextFactory = null;
        Executor executor = null;
        if (scope != null) {
            sslContextFactory = scope.getSslContextFactory();
            executor = scope.getExecutor();
        }
        if (sslContextFactory == null) {
            sslContextFactory = new SslContextFactory();
        }
        HttpClient client = new HttpClient(sslContextFactory);
        if (executor == null) {
            QueuedThreadPool threadPool = new QueuedThreadPool();
            String name = "WebSocketClient@" + client.hashCode();
            threadPool.setName(name);
            threadPool.setDaemon(true);
            executor = threadPool;
        }
        client.setExecutor(executor);
        return client;
    }
}

