/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.websocket.client;

import ai.h2o.org.eclipse.jetty.client.HttpClient;
import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import ai.h2o.org.eclipse.jetty.xml.XmlConfiguration;
import java.io.InputStream;
import java.net.URL;

class XmlBasedHttpClientProvider {
    XmlBasedHttpClientProvider() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HttpClient get(WebSocketContainerScope scope) {
        URL resource = Thread.currentThread().getContextClassLoader().getResource("jetty-websocket-httpclient.xml");
        if (resource == null) {
            return null;
        }
        try (InputStream in = resource.openStream();){
            XmlConfiguration configuration = new XmlConfiguration(in);
            HttpClient httpClient = (HttpClient)configuration.configure();
            return httpClient;
        }
        catch (Throwable t2) {
            Log.getLogger(XmlBasedHttpClientProvider.class).warn("Unable to load: " + resource, t2);
            return null;
        }
    }
}

