/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.websocket.client.io;

import ai.h2o.org.eclipse.jetty.io.ByteBufferPool;
import ai.h2o.org.eclipse.jetty.io.EndPoint;
import ai.h2o.org.eclipse.jetty.util.thread.Scheduler;
import ai.h2o.org.eclipse.jetty.websocket.api.BatchMode;
import ai.h2o.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import ai.h2o.org.eclipse.jetty.websocket.api.WriteCallback;
import ai.h2o.org.eclipse.jetty.websocket.api.extensions.Frame;
import ai.h2o.org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import ai.h2o.org.eclipse.jetty.websocket.client.masks.Masker;
import ai.h2o.org.eclipse.jetty.websocket.client.masks.RandomMasker;
import ai.h2o.org.eclipse.jetty.websocket.common.WebSocketFrame;
import ai.h2o.org.eclipse.jetty.websocket.common.io.AbstractWebSocketConnection;
import java.net.InetSocketAddress;
import java.util.concurrent.Executor;

public class WebSocketClientConnection
extends AbstractWebSocketConnection {
    private final Masker masker = new RandomMasker();

    public WebSocketClientConnection(EndPoint endp, Executor executor, Scheduler scheduler, WebSocketPolicy websocketPolicy, ByteBufferPool bufferPool) {
        super(endp, executor, scheduler, websocketPolicy, bufferPool);
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        return this.getEndPoint().getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return this.getEndPoint().getRemoteAddress();
    }

    @Override
    public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
        if (frame instanceof WebSocketFrame) {
            this.masker.setMask((WebSocketFrame)frame);
        }
        super.outgoingFrame(frame, callback, batchMode);
    }

    @Override
    public void setNextIncomingFrames(IncomingFrames incoming) {
        this.getParser().setIncomingFramesHandler(incoming);
    }
}

