/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.websocket.common.events;

import ai.h2o.org.eclipse.jetty.util.BufferUtil;
import ai.h2o.org.eclipse.jetty.util.Utf8Appendable;
import ai.h2o.org.eclipse.jetty.util.component.AbstractLifeCycle;
import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.util.log.Logger;
import ai.h2o.org.eclipse.jetty.websocket.api.BatchMode;
import ai.h2o.org.eclipse.jetty.websocket.api.CloseException;
import ai.h2o.org.eclipse.jetty.websocket.api.WebSocketPolicy;
import ai.h2o.org.eclipse.jetty.websocket.api.extensions.Frame;
import ai.h2o.org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import ai.h2o.org.eclipse.jetty.websocket.common.CloseInfo;
import ai.h2o.org.eclipse.jetty.websocket.common.WebSocketSession;
import ai.h2o.org.eclipse.jetty.websocket.common.events.EventDriver;
import ai.h2o.org.eclipse.jetty.websocket.common.frames.CloseFrame;
import ai.h2o.org.eclipse.jetty.websocket.common.message.MessageAppender;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AbstractEventDriver
extends AbstractLifeCycle
implements IncomingFrames,
EventDriver {
    private static final Logger LOG = Log.getLogger(AbstractEventDriver.class);
    protected final Logger TARGET_LOG;
    protected WebSocketPolicy policy;
    protected final Object websocket;
    protected WebSocketSession session;
    protected MessageAppender activeMessage;

    public AbstractEventDriver(WebSocketPolicy policy, Object websocket) {
        this.policy = policy;
        this.websocket = websocket;
        this.TARGET_LOG = Log.getLogger(websocket.getClass());
    }

    protected void appendMessage(ByteBuffer buffer, boolean fin) throws IOException {
        this.activeMessage.appendFrame(buffer, fin);
        if (fin) {
            this.activeMessage.messageComplete();
            this.activeMessage = null;
        }
    }

    protected void dispatch(Runnable runnable) {
        this.session.dispatch(runnable);
    }

    @Override
    public WebSocketPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public WebSocketSession getSession() {
        return this.session;
    }

    @Override
    public final void incomingError(Throwable e2) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("incomingError(" + e2.getClass().getName() + ")", e2);
        }
        this.onError(e2);
    }

    @Override
    public void incomingFrame(Frame frame) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("incomingFrame({})", frame);
        }
        try {
            this.onFrame(frame);
            byte opcode = frame.getOpCode();
            switch (opcode) {
                case 8: {
                    boolean validate2 = true;
                    CloseFrame closeframe = (CloseFrame)frame;
                    CloseInfo close = new CloseInfo(closeframe, validate2);
                    this.session.getConnection().getIOState().onCloseRemote(close);
                    return;
                }
                case 9: {
                    ByteBuffer pongBuf;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("PING: {}", BufferUtil.toDetailString(frame.getPayload()));
                    }
                    if (frame.hasPayload()) {
                        pongBuf = ByteBuffer.allocate(frame.getPayload().remaining());
                        BufferUtil.put(frame.getPayload().slice(), pongBuf);
                        BufferUtil.flipToFlush(pongBuf, 0);
                    } else {
                        pongBuf = ByteBuffer.allocate(0);
                    }
                    this.onPing(frame.getPayload());
                    this.session.getRemote().sendPong(pongBuf);
                    break;
                }
                case 10: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("PONG: {}", BufferUtil.toDetailString(frame.getPayload()));
                    }
                    this.onPong(frame.getPayload());
                    break;
                }
                case 2: {
                    this.onBinaryFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                case 1: {
                    this.onTextFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                case 0: {
                    this.onContinuationFrame(frame.getPayload(), frame.isFin());
                    return;
                }
                default: {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Unhandled OpCode: {}", opcode);
                    }
                    break;
                }
            }
        }
        catch (Utf8Appendable.NotUtf8Exception e2) {
            this.terminateConnection(1007, e2.getMessage());
        }
        catch (CloseException e3) {
            this.terminateConnection(e3.getStatusCode(), e3.getMessage());
        }
        catch (Throwable t2) {
            this.unhandled(t2);
        }
    }

    @Override
    public void onContinuationFrame(ByteBuffer buffer, boolean fin) throws IOException {
        if (this.activeMessage == null) {
            throw new IOException("Out of order Continuation frame encountered");
        }
        this.appendMessage(buffer, fin);
    }

    @Override
    public void onPong(ByteBuffer buffer) {
    }

    @Override
    public void onPing(ByteBuffer buffer) {
    }

    @Override
    public BatchMode getBatchMode() {
        return null;
    }

    @Override
    public void openSession(WebSocketSession session) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("openSession({})", session);
            LOG.debug("objectFactory={}", session.getContainerScope().getObjectFactory());
        }
        this.session = session;
        this.session.getContainerScope().getObjectFactory().decorate(this.websocket);
        try {
            this.onConnect();
        }
        catch (Throwable t2) {
            this.session.notifyError(t2);
            throw t2;
        }
    }

    protected void terminateConnection(int statusCode, String rawreason) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("terminateConnection({},{})", statusCode, rawreason);
        }
        this.session.close(statusCode, CloseFrame.truncate(rawreason));
    }

    private void unhandled(Throwable t2) {
        this.TARGET_LOG.warn("Unhandled Error (closing connection)", t2);
        this.onError(t2);
        if (t2 instanceof CloseException) {
            this.terminateConnection(((CloseException)t2).getStatusCode(), t2.getClass().getSimpleName());
            return;
        }
        switch (this.policy.getBehavior()) {
            case SERVER: {
                this.terminateConnection(1011, t2.getClass().getSimpleName());
                break;
            }
            case CLIENT: {
                this.terminateConnection(1008, t2.getClass().getSimpleName());
            }
        }
    }
}

