/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.websocket.common.events;

import ai.h2o.org.eclipse.jetty.util.log.Log;
import ai.h2o.org.eclipse.jetty.util.log.Logger;
import ai.h2o.org.eclipse.jetty.websocket.api.InvalidWebSocketException;
import ai.h2o.org.eclipse.jetty.websocket.common.events.EventDriver;
import ai.h2o.org.eclipse.jetty.websocket.common.events.EventDriverImpl;
import ai.h2o.org.eclipse.jetty.websocket.common.events.JettyAnnotatedImpl;
import ai.h2o.org.eclipse.jetty.websocket.common.events.JettyListenerImpl;
import ai.h2o.org.eclipse.jetty.websocket.common.scopes.WebSocketContainerScope;
import java.util.ArrayList;
import java.util.List;

public class EventDriverFactory {
    private static final Logger LOG = Log.getLogger(EventDriverFactory.class);
    private final WebSocketContainerScope containerScope;
    private final List<EventDriverImpl> implementations;

    public EventDriverFactory(WebSocketContainerScope containerScope) {
        this.containerScope = containerScope;
        this.implementations = new ArrayList<EventDriverImpl>();
        this.addImplementation(new JettyListenerImpl());
        this.addImplementation(new JettyAnnotatedImpl());
    }

    public void addImplementation(EventDriverImpl impl) {
        if (this.implementations.contains(impl)) {
            LOG.warn("Ignoring attempt to add duplicate EventDriverImpl: " + impl, new Object[0]);
            return;
        }
        this.implementations.add(impl);
    }

    public void clearImplementations() {
        this.implementations.clear();
    }

    protected String getClassName(Object websocket) {
        return websocket.getClass().getName();
    }

    public List<EventDriverImpl> getImplementations() {
        return this.implementations;
    }

    public boolean removeImplementation(EventDriverImpl impl) {
        return this.implementations.remove(impl);
    }

    public String toString() {
        StringBuilder msg = new StringBuilder();
        msg.append(this.getClass().getSimpleName());
        msg.append("[implementations=[");
        boolean delim = false;
        for (EventDriverImpl impl : this.implementations) {
            if (delim) {
                msg.append(',');
            }
            msg.append(impl.toString());
            delim = true;
        }
        msg.append("]");
        return msg.toString();
    }

    public EventDriver wrap(Object websocket) {
        if (websocket == null) {
            throw new InvalidWebSocketException("null websocket object");
        }
        for (EventDriverImpl impl : this.implementations) {
            if (!impl.supports(websocket)) continue;
            try {
                return impl.create(websocket, this.containerScope.getPolicy().clonePolicy());
            }
            catch (Throwable e2) {
                throw new InvalidWebSocketException("Unable to create websocket", e2);
            }
        }
        StringBuilder err = new StringBuilder();
        err.append(this.getClassName(websocket));
        err.append(" is not a valid WebSocket object.");
        err.append("  Object must obey one of the following rules: ");
        int len = this.implementations.size();
        for (int i2 = 0; i2 < len; ++i2) {
            EventDriverImpl impl = this.implementations.get(i2);
            if (i2 > 0) {
                err.append(" or ");
            }
            err.append("\n(").append(i2 + 1).append(") ");
            err.append(impl.describeRule());
        }
        throw new InvalidWebSocketException(err.toString());
    }
}

