/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.org.eclipse.jetty.websocket.common.io;

import ai.h2o.org.eclipse.jetty.websocket.api.BatchMode;
import ai.h2o.org.eclipse.jetty.websocket.api.WriteCallback;
import ai.h2o.org.eclipse.jetty.websocket.api.extensions.Frame;
import ai.h2o.org.eclipse.jetty.websocket.api.extensions.IncomingFrames;
import ai.h2o.org.eclipse.jetty.websocket.api.extensions.OutgoingFrames;

public class FramePipes {
    public static OutgoingFrames to(IncomingFrames incoming) {
        return new Out2In(incoming);
    }

    public static IncomingFrames to(OutgoingFrames outgoing) {
        return new In2Out(outgoing);
    }

    private static class Out2In
    implements OutgoingFrames {
        private IncomingFrames incoming;

        public Out2In(IncomingFrames incoming) {
            this.incoming = incoming;
        }

        @Override
        public void outgoingFrame(Frame frame, WriteCallback callback, BatchMode batchMode) {
            try {
                this.incoming.incomingFrame(frame);
                callback.writeSuccess();
            }
            catch (Throwable t2) {
                callback.writeFailed(t2);
            }
        }
    }

    private static class In2Out
    implements IncomingFrames {
        private OutgoingFrames outgoing;

        public In2Out(OutgoingFrames outgoing) {
            this.outgoing = outgoing;
        }

        @Override
        public void incomingError(Throwable t2) {
        }

        @Override
        public void incomingFrame(Frame frame) {
            this.outgoing.outgoingFrame(frame, null, BatchMode.OFF);
        }
    }
}

