/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.H2OContext;
import ai.h2o.sparkling.backend.BuildInfo$;
import ai.h2o.sparkling.backend.NodeDesc;
import ai.h2o.sparkling.backend.exceptions.WrongSparkVersion;
import ai.h2o.sparkling.backend.external.ExternalH2OBackend$;
import ai.h2o.sparkling.backend.utils.H2OClientUtils$;
import ai.h2o.sparkling.backend.utils.RestApiUtils$;
import ai.h2o.sparkling.utils.SparkSessionUtils$;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkContext;
import org.apache.spark.h2o.backends.internal.InternalH2OBackend$;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.Nothing$;
import water.H2O;
import water.api.schemas3.CloudV3;

public final class H2OContext$
implements org.apache.spark.expose.Logging {
    public static final H2OContext$ MODULE$;
    private final AtomicReference<H2OContext> ai$h2o$sparkling$H2OContext$$instantiatedContext;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new H2OContext$();
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public synchronized void setInstantiatedContext(H2OContext h2oContext) {
        H2OContext ctx = this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get();
        if (ctx == null) {
            this.ai$h2o$sparkling$H2OContext$$instantiatedContext().set(h2oContext);
        }
    }

    public AtomicReference<H2OContext> ai$h2o$sparkling$H2OContext$$instantiatedContext() {
        return this.ai$h2o$sparkling$H2OContext$$instantiatedContext;
    }

    public Option<H2OContext> get() {
        return Option$.MODULE$.apply((Object)this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get());
    }

    public H2OContext ensure(Function0<String> onError) {
        return (H2OContext)Option$.MODULE$.apply((Object)this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get()).getOrElse((Function0)new Serializable(onError){
            public static final long serialVersionUID = 0L;
            private final Function0 onError$1;

            public final Nothing$ apply() {
                throw new RuntimeException((String)this.onError$1.apply());
            }
            {
                this.onError$1 = onError$1;
            }
        });
    }

    public String ensure$default$1() {
        return "H2OContext has to be running.";
    }

    private boolean connectingToNewCluster(H2OContext hc2, H2OConf newConf) {
        CloudV3 newCloudV3 = RestApiUtils$.MODULE$.getClusterInfo(newConf);
        boolean sameNodes = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])hc2.getH2ONodes()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(NodeDesc x$4) {
                return x$4.ipPort();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).sameElements((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])Predef$.MODULE$.refArrayOps((Object[])newCloudV3.nodes).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(CloudV3.NodeV3 x$5) {
                return x$5.ip_port;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))));
        return !sameNodes;
    }

    private H2OConf checkAndUpdateConf(H2OConf conf) {
        return conf.runsInExternalClusterMode() ? ExternalH2OBackend$.MODULE$.checkAndUpdateConf(conf) : InternalH2OBackend$.MODULE$.checkAndUpdateConf(conf);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized H2OContext getOrCreate(H2OConf conf) {
        if (H2OClientUtils$.MODULE$.isH2OClientBased(conf)) {
            if (this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get() != null) return this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get();
            if (H2O.API_PORT != 0) throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("\n              |H2O context hasn't been started successfully in the previous attempt and H2O client with previous configuration is already running.\n              |Because of the current H2O limitation that it can't be restarted within a running JVM,\n              |please restart your job or spark session and create new H2O context with new configuration.\")\n          ")).stripMargin());
            H2OConf checkedConf = this.checkAndUpdateConf(conf);
            this.ai$h2o$sparkling$H2OContext$$instantiatedContext().set(new H2OContext(checkedConf));
            return this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get();
        } else {
            H2OContext existingContext = this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get();
            if (existingContext == null) {
                H2OConf checkedConf = this.checkAndUpdateConf(conf);
                this.ai$h2o$sparkling$H2OContext$$instantiatedContext().set(new H2OContext(checkedConf));
                return this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get();
            } else {
                boolean isExternalBackend = conf.runsInExternalClusterMode();
                boolean startedManually = existingContext.getConf().isManualClusterStartUsed();
                if (!isExternalBackend || !startedManually) return this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get();
                if (conf.h2oCluster().isEmpty()) {
                    throw new IllegalArgumentException("H2O cluster endpoint has to be specified!");
                }
                if (!this.connectingToNewCluster(existingContext, conf)) return this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get();
                H2OConf checkedConf = this.checkAndUpdateConf(conf);
                this.ai$h2o$sparkling$H2OContext$$instantiatedContext().set(new H2OContext(checkedConf));
                this.logWarning((Function0<String>)new Serializable(checkedConf){
                    public static final long serialVersionUID = 0L;
                    private final H2OConf checkedConf$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Connecting to a new external H2O cluster : ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.checkedConf$1.h2oCluster().get()}));
                    }
                    {
                        this.checkedConf$1 = checkedConf$1;
                    }
                });
            }
        }
        return this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get();
    }

    public H2OContext getOrCreate() {
        return this.getOrCreate((H2OConf)Option$.MODULE$.apply((Object)this.ai$h2o$sparkling$H2OContext$$instantiatedContext().get()).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final H2OConf apply(H2OContext x$6) {
                return x$6.getConf();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final H2OConf apply() {
                return new H2OConf();
            }
        }));
    }

    private boolean isSparkVersionUnsupported() {
        return SparkSessionUtils$.MODULE$.active().version().startsWith("2.1.");
    }

    private boolean isSparkVersionDeprecated() {
        return SparkSessionUtils$.MODULE$.active().version().startsWith("2.2.");
    }

    public void ai$h2o$sparkling$H2OContext$$logStartingInfo(H2OConf conf) {
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringBuilder().append((Object)"Sparkling Water version: ").append((Object)BuildInfo$.MODULE$.SWVersion()).toString();
            }
        });
        String deprecationSuffix = this.isSparkVersionDeprecated() ? " (deprecated)" : "";
        String unsupportedSuffix = this.isSparkVersionUnsupported() ? " (unsupported)" : "";
        this.logInfo((Function0<String>)new Serializable(deprecationSuffix, unsupportedSuffix){
            public static final long serialVersionUID = 0L;
            private final String deprecationSuffix$1;
            private final String unsupportedSuffix$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Spark version: ").append((Object)SparkSessionUtils$.MODULE$.active().version()).append((Object)this.deprecationSuffix$1).append((Object)this.unsupportedSuffix$1).toString();
            }
            {
                this.deprecationSuffix$1 = deprecationSuffix$1;
                this.unsupportedSuffix$1 = unsupportedSuffix$1;
            }
        });
        this.logInfo((Function0<String>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return new StringBuilder().append((Object)"Integrated H2O version: ").append((Object)BuildInfo$.MODULE$.H2OVersion()).toString();
            }
        });
        this.logInfo((Function0<String>)new Serializable(conf){
            public static final long serialVersionUID = 0L;
            private final H2OConf conf$1;

            public final String apply() {
                return new StringBuilder().append((Object)"The following Spark configuration is used: \n    ").append((Object)Predef$.MODULE$.refArrayOps((Object[])this.conf$1.getAll()).mkString("\n    ")).toString();
            }
            {
                this.conf$1 = conf$1;
            }
        });
    }

    public void ai$h2o$sparkling$H2OContext$$verifySparkVersion() {
        SparkContext sc = SparkSessionUtils$.MODULE$.active().sparkContext();
        boolean runningOnCorrectSpark = sc.version().startsWith(BuildInfo$.MODULE$.buildSparkMajorVersion());
        if (runningOnCorrectSpark) {
            if (this.isSparkVersionUnsupported()) {
                this.logWarning((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Apache Spark ", " is unsupported since the Sparkling Water version 3.34.0.1-1."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SparkSessionUtils$.MODULE$.active().version()}));
                    }
                });
            }
            if (this.isSparkVersionDeprecated()) {
                this.logWarning((Function0<String>)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Apache Spark ", " is deprecated and "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SparkSessionUtils$.MODULE$.active().version()}))).append((Object)"the support will be removed in the Sparkling Water version 3.38.").toString();
                    }
                });
            }
            return;
        }
        throw new WrongSparkVersion(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"You are trying to use Sparkling Water built for Spark ", ","})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BuildInfo$.MODULE$.buildSparkMajorVersion()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" but your Spark is of version ", ". Please make sure to use correct Sparkling Water for your"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sc.version()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" Spark and re-run the application."})).s((Seq)Nil$.MODULE$)).toString());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private H2OContext$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.ai$h2o$sparkling$H2OContext$$instantiatedContext = new AtomicReference();
    }
}

