/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.backend.internal;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.backend.internal.InternalBackendConf$;
import ai.h2o.sparkling.utils.ScalaUtils$;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import org.apache.hadoop.conf.Configuration;
import org.apache.spark.SparkEnv$;
import org.apache.spark.expose.Utils$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public abstract class InternalBackendConf$class {
    public static Option numH2OWorkers(H2OConf $this) {
        return $this.sparkConf().getOption((String)InternalBackendConf$.MODULE$.PROP_CLUSTER_SIZE()._1()).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$1) {
                return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
            }
        });
    }

    public static boolean extraClusterNodes(H2OConf $this) {
        return $this.sparkConf().getBoolean((String)InternalBackendConf$.MODULE$.PROP_EXTRA_CLUSTER_NODES()._1(), BoxesRunTime.unboxToBoolean((Object)InternalBackendConf$.MODULE$.PROP_EXTRA_CLUSTER_NODES()._2()));
    }

    public static int drddMulFactor(H2OConf $this) {
        return $this.sparkConf().getInt((String)InternalBackendConf$.MODULE$.PROP_DUMMY_RDD_MUL_FACTOR()._1(), BoxesRunTime.unboxToInt((Object)InternalBackendConf$.MODULE$.PROP_DUMMY_RDD_MUL_FACTOR()._2()));
    }

    public static int numRddRetries(H2OConf $this) {
        return $this.sparkConf().getInt((String)InternalBackendConf$.MODULE$.PROP_SPREADRDD_RETRIES()._1(), BoxesRunTime.unboxToInt((Object)InternalBackendConf$.MODULE$.PROP_SPREADRDD_RETRIES()._2()));
    }

    public static int defaultCloudSize(H2OConf $this) {
        return $this.sparkConf().getInt((String)InternalBackendConf$.MODULE$.PROP_DEFAULT_CLUSTER_SIZE()._1(), BoxesRunTime.unboxToInt((Object)InternalBackendConf$.MODULE$.PROP_DEFAULT_CLUSTER_SIZE()._2()));
    }

    public static int subseqTries(H2OConf $this) {
        return $this.sparkConf().getInt((String)InternalBackendConf$.MODULE$.PROP_SUBSEQ_TRIES()._1(), BoxesRunTime.unboxToInt((Object)InternalBackendConf$.MODULE$.PROP_SUBSEQ_TRIES()._2()));
    }

    public static Option hdfsConf(H2OConf $this) {
        return $this.sparkConf().getOption((String)InternalBackendConf$.MODULE$.PROP_HDFS_CONF()._1());
    }

    public static int spreadRddRetriesTimeout(H2OConf $this) {
        return $this.sparkConf().getInt((String)InternalBackendConf$.MODULE$.PROP_SPREADRDD_RETRIES_TIMEOUT()._1(), BoxesRunTime.unboxToInt((Object)InternalBackendConf$.MODULE$.PROP_SPREADRDD_RETRIES_TIMEOUT()._2()));
    }

    public static boolean isDirectIpConfigurationEnabled(H2OConf $this) {
        return $this.sparkConf().getBoolean((String)InternalBackendConf$.MODULE$.PROP_DIRECT_IP_CONFIGURATION()._1(), BoxesRunTime.unboxToBoolean((Object)InternalBackendConf$.MODULE$.PROP_DIRECT_IP_CONFIGURATION()._2()));
    }

    public static H2OConf setNumH2OWorkers(H2OConf $this, int numWorkers) {
        return $this.set((String)InternalBackendConf$.MODULE$.PROP_CLUSTER_SIZE()._1(), ((Object)BoxesRunTime.boxToInteger((int)numWorkers)).toString());
    }

    public static H2OConf setExtraClusterNodesEnabled(H2OConf $this) {
        return $this.set((String)InternalBackendConf$.MODULE$.PROP_EXTRA_CLUSTER_NODES()._1(), true);
    }

    public static H2OConf setExtraClusterNodesDisabled(H2OConf $this) {
        return $this.set((String)InternalBackendConf$.MODULE$.PROP_EXTRA_CLUSTER_NODES()._1(), false);
    }

    public static H2OConf setDrddMulFactor(H2OConf $this, int factor) {
        return $this.set((String)InternalBackendConf$.MODULE$.PROP_DUMMY_RDD_MUL_FACTOR()._1(), ((Object)BoxesRunTime.boxToInteger((int)factor)).toString());
    }

    public static H2OConf setNumRddRetries(H2OConf $this, int retries) {
        return $this.set((String)InternalBackendConf$.MODULE$.PROP_SPREADRDD_RETRIES()._1(), ((Object)BoxesRunTime.boxToInteger((int)retries)).toString());
    }

    public static H2OConf setDefaultCloudSize(H2OConf $this, int defaultClusterSize) {
        return $this.set((String)InternalBackendConf$.MODULE$.PROP_DEFAULT_CLUSTER_SIZE()._1(), ((Object)BoxesRunTime.boxToInteger((int)defaultClusterSize)).toString());
    }

    public static H2OConf setSubseqTries(H2OConf $this, int subseqTriesNum) {
        return $this.set((String)InternalBackendConf$.MODULE$.PROP_SUBSEQ_TRIES()._1(), ((Object)BoxesRunTime.boxToInteger((int)subseqTriesNum)).toString());
    }

    public static H2OConf setHdfsConf(H2OConf $this, String path) {
        return $this.set((String)InternalBackendConf$.MODULE$.PROP_HDFS_CONF()._1(), path);
    }

    public static H2OConf setHdfsConf(H2OConf $this, Configuration conf) {
        File sparkTmpDir = new File(Utils$.MODULE$.getLocalDir(SparkEnv$.MODULE$.get().conf()));
        File hdfsConfigTempFile = File.createTempFile("hdfs_conf", ".xml", sparkTmpDir);
        hdfsConfigTempFile.deleteOnExit();
        ScalaUtils$.MODULE$.withResource(new FileWriter(hdfsConfigTempFile), new Serializable($this, conf){
            public static final long serialVersionUID = 0L;
            private final Configuration conf$1;

            public final void apply(FileWriter fileWriter) {
                this.conf$1.writeXml((Writer)fileWriter);
            }
            {
                this.conf$1 = conf$1;
            }
        });
        return $this.set((String)InternalBackendConf$.MODULE$.PROP_HDFS_CONF()._1(), hdfsConfigTempFile.getAbsolutePath());
    }

    public static H2OConf setSpreadRddRetriesTimeout(H2OConf $this, int timeout) {
        return $this.set((String)InternalBackendConf$.MODULE$.PROP_SPREADRDD_RETRIES_TIMEOUT()._1(), ((Object)BoxesRunTime.boxToInteger((int)timeout)).toString());
    }

    public static H2OConf setDirectIpConfigurationEnabled(H2OConf $this) {
        return $this.set((String)InternalBackendConf$.MODULE$.PROP_DIRECT_IP_CONFIGURATION()._1(), true);
    }

    public static H2OConf setDirectIpConfigurationDisabled(H2OConf $this) {
        return $this.set((String)InternalBackendConf$.MODULE$.PROP_DIRECT_IP_CONFIGURATION()._1(), false);
    }

    public static void $init$(H2OConf $this) {
    }
}

