/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.backend.utils;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.H2OContext;
import ai.h2o.sparkling.backend.NodeDesc;
import ai.h2o.sparkling.backend.utils.ArgumentBuilder;
import ai.h2o.sparkling.backend.utils.SharedBackendUtils;
import ai.h2o.sparkling.backend.utils.SharedBackendUtils$class;
import java.io.File;
import java.net.InetAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.NonLocalReturnControl;
import water.H2O;
import water.H2OStarter;
import water.Paxos;
import water.fvec.Frame;
import water.init.HostnameGuesser;

public final class H2OClientUtils$
implements SharedBackendUtils {
    public static final H2OClientUtils$ MODULE$;
    private final Tuple2<String, Object> PROP_REST_API_BASED_CLIENT;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new H2OClientUtils$();
    }

    @Override
    public String getHostname(SparkEnv env) {
        return SharedBackendUtils$class.getHostname(this, env);
    }

    @Override
    public H2OConf checkAndUpdateConf(H2OConf conf) {
        return SharedBackendUtils$class.checkAndUpdateConf(this, conf);
    }

    @Override
    public void distributeFiles(H2OConf conf, SparkContext sc) {
        SharedBackendUtils$class.distributeFiles(this, conf, sc);
    }

    @Override
    public Seq<String> getH2OSecurityArgs(H2OConf conf) {
        return SharedBackendUtils$class.getH2OSecurityArgs(this, conf);
    }

    @Override
    public Seq<String> getH2OCommonArgs(H2OConf conf) {
        return SharedBackendUtils$class.getH2OCommonArgs(this, conf);
    }

    @Override
    public Seq<String> getH2OWorkerAsClientArgs(H2OConf conf) {
        return SharedBackendUtils$class.getH2OWorkerAsClientArgs(this, conf);
    }

    @Override
    public Seq<String> parseStringToHttpHeaderArgs(String headers) {
        return SharedBackendUtils$class.parseStringToHttpHeaderArgs(this, headers);
    }

    @Override
    public Seq<String> getExtraHttpHeaderArgs(H2OConf conf) {
        return SharedBackendUtils$class.getExtraHttpHeaderArgs(this, conf);
    }

    @Override
    public String[] toH2OArgs(Seq<String> h2oArgs, NodeDesc[] executors) {
        return SharedBackendUtils$class.toH2OArgs(this, h2oArgs, executors);
    }

    @Override
    public File createTempDir() {
        return SharedBackendUtils$class.createTempDir(this);
    }

    @Override
    public File saveFlatFileAsFile(String content) {
        return SharedBackendUtils$class.saveFlatFileAsFile(this, content);
    }

    @Override
    public String translateHostnameToIp(String hostname) {
        return SharedBackendUtils$class.translateHostnameToIp(this, hostname);
    }

    @Override
    public NodeDesc[] toH2OArgs$default$2() {
        return SharedBackendUtils$class.toH2OArgs$default$2(this);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    public Tuple2<String, Object> PROP_REST_API_BASED_CLIENT() {
        return this.PROP_REST_API_BASED_CLIENT;
    }

    public boolean isH2OClientBased(H2OConf conf) {
        return !conf.getBoolean((String)this.PROP_REST_API_BASED_CLIENT()._1(), this.PROP_REST_API_BASED_CLIENT()._2$mcZ$sp());
    }

    private Seq<String> getH2OClientArgs(H2OConf conf) {
        return new ArgumentBuilder().add(this.getH2OWorkerAsClientArgs(conf)).add("-network", conf.clientNetworkMask()).addIf("-ip", conf.clientIp(), conf.clientNetworkMask().isEmpty()).add("-client").buildArgs();
    }

    public Seq<String> getH2OCommonArgsWhenClientBased(H2OConf conf) {
        return new ArgumentBuilder().add("-allow_clients").add("-client_disconnect_timeout", conf.clientCheckRetryTimeout()).buildArgs();
    }

    public Seq<String> getExtraExternalBackendArgsWhenClientBased(H2OConf conf) {
        return new ArgumentBuilder().add("-sw_ext_backend").add((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-J", "-client_disconnect_timeout", "-J", ((Object)BoxesRunTime.boxToInteger((int)conf.clientCheckRetryTimeout())).toString()})))).buildArgs();
    }

    public NodeDesc startH2OClient(H2OContext hc2, H2OConf conf, NodeDesc[] nodes) {
        Object object;
        if (conf.runsInExternalClusterMode()) {
            this.setClientIp(conf);
            object = BoxedUnit.UNIT;
        } else {
            object = conf.clientIp().isEmpty() ? conf.setClientIp(this.getHostname(SparkEnv$.MODULE$.get())) : BoxedUnit.UNIT;
        }
        if (!conf.runsInInternalClusterMode() || !hc2.sparkContext().isLocal()) {
            int expectedSize;
            int discoveredSize;
            String[] args = (String[])this.getH2OClientArgs(conf).toArray(ClassTag$.MODULE$.apply(String.class));
            String[] launcherArgs = this.toH2OArgs((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])args), nodes);
            this.logDebug((Function0<String>)new Serializable(launcherArgs){
                public static final long serialVersionUID = 0L;
                private final String[] launcherArgs$1;

                public final String apply() {
                    return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Arguments used for launching the H2O client node: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{Predef$.MODULE$.refArrayOps((Object[])this.launcherArgs$1).mkString(" ")}));
                }
                {
                    this.launcherArgs$1 = launcherArgs$1;
                }
            });
            H2OStarter.start(launcherArgs, true);
            if ((conf.runsInInternalClusterMode() || conf.isAutoClusterStartUsed()) && (discoveredSize = this.waitForCloudSize(expectedSize = nodes.length, conf.cloudTimeout())) < expectedSize) {
                this.logError((Function0<String>)new Serializable(expectedSize, discoveredSize){
                    public static final long serialVersionUID = 0L;
                    private final int expectedSize$1;
                    private final int discoveredSize$1;

                    public final String apply() {
                        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Exiting! H2O cluster was of size ", " but expected was ", "!!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.discoveredSize$1), BoxesRunTime.boxToInteger((int)this.expectedSize$1)}));
                    }
                    {
                        this.expectedSize$1 = expectedSize$1;
                        this.discoveredSize$1 = discoveredSize$1;
                    }
                });
                hc2.stop(true);
                throw new RuntimeException(new StringBuilder().append((Object)"Cloud size ").append((Object)BoxesRunTime.boxToInteger((int)discoveredSize)).append((Object)" under ").append((Object)BoxesRunTime.boxToInteger((int)expectedSize)).toString());
            }
        }
        return new NodeDesc(SparkEnv$.MODULE$.get().executorId(), H2O.SELF_ADDRESS.getHostAddress(), H2O.API_PORT);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int waitForCloudSize(int expectedSize, long timeoutInMilliseconds) {
        start = System.currentTimeMillis();
        while (true) {
            if (System.currentTimeMillis() - start >= timeoutInMilliseconds) {
                return H2O.CLOUD.size();
            }
            if (H2O.CLOUD.size() < expectedSize || !Paxos._commonKnowledge) ** GOTO lbl-1000
            return H2O.CLOUD.size();
lbl-1000:
            // 1 sources

            {
                Thread.sleep(100L);
                continue;
            }
            break;
        }
    }

    private void setClientIp(H2OConf conf) {
        Option<String> clientIp = this.identifyClientIp((String)conf.h2oClusterHost().get());
        Object object = clientIp.isDefined() && conf.clientNetworkMask().isEmpty() ? conf.setClientIp((String)clientIp.get()) : BoxedUnit.UNIT;
        if (conf.clientIp().isEmpty()) {
            conf.setClientIp(this.getHostname(SparkEnv$.MODULE$.get()));
        }
    }

    private Option<String> identifyClientIp(String remoteAddress) {
        NonLocalReturnControl nonLocalReturnControl2;
        block3: {
            None$ none$;
            Object object = new Object();
            try {
                Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
                while (interfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = interfaces.nextElement();
                    ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(networkInterface.getInterfaceAddresses()).asScala()).foreach((Function1)new Serializable(remoteAddress, object){
                        public static final long serialVersionUID = 0L;
                        private final String remoteAddress$1;
                        private final Object nonLocalReturnKey1$1;

                        public final void apply(InterfaceAddress address) {
                            String ip = new StringBuilder().append((Object)address.getAddress().getHostAddress()).append((Object)"/").append((Object)BoxesRunTime.boxToShort((short)address.getNetworkPrefixLength())).toString();
                            HostnameGuesser.CIDRBlock cidr = HostnameGuesser.CIDRBlock.parse(ip);
                            if (cidr != null && cidr.isInetAddressOnNetwork(InetAddress.getByName(this.remoteAddress$1))) {
                                throw new NonLocalReturnControl(this.nonLocalReturnKey1$1, (Object)new Some((Object)address.getAddress().getHostAddress()));
                            }
                        }
                        {
                            this.remoteAddress$1 = remoteAddress$1;
                            this.nonLocalReturnKey1$1 = nonLocalReturnKey1$1;
                        }
                    });
                }
                none$ = None$.MODULE$;
            }
            catch (NonLocalReturnControl nonLocalReturnControl2) {
                if (nonLocalReturnControl2.key() != object) break block3;
                none$ = (Option)nonLocalReturnControl2.value();
            }
            return none$;
        }
        throw nonLocalReturnControl2;
    }

    public <T extends Frame> T withLockAndUpdate(T fr, Function1<T, Object> f2) {
        fr.write_lock();
        f2.apply(fr);
        fr.update();
        fr.unlock();
        return fr;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private H2OClientUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        SharedBackendUtils$class.$init$(this);
        this.PROP_REST_API_BASED_CLIENT = new Tuple2((Object)"spark.ext.h2o.rest.api.based.client", (Object)BoxesRunTime.boxToBoolean((boolean)true));
    }
}

