/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.backend.utils;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.backend.NodeDesc;
import ai.h2o.sparkling.backend.exceptions.RestApiCommunicationException;
import ai.h2o.sparkling.backend.exceptions.RestApiException;
import ai.h2o.sparkling.backend.exceptions.RestApiNotReachableException;
import ai.h2o.sparkling.backend.exceptions.RestApiUnauthorisedException;
import ai.h2o.sparkling.backend.utils.RestApiUtils$;
import ai.h2o.sparkling.backend.utils.RestCommunication;
import ai.h2o.sparkling.utils.Compression$;
import ai.h2o.sparkling.utils.FinalizingOutputStream;
import ai.h2o.sparkling.utils.ScalaUtils$;
import com.google.gson.ExclusionStrategy;
import com.google.gson.FieldAttributes;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.spark.SparkFiles$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag;
import scala.reflect.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import sun.net.www.protocol.http.Handler;

public abstract class RestCommunication$class {
    public static Object query(RestCommunication $this, URI endpoint, String suffix, H2OConf conf, Map params, Seq skippedFields, Enumeration.Value confirmationLoggingLevel, ClassTag evidence$1) {
        boolean encodeParamsAsJson = false;
        return $this.request(endpoint, "GET", suffix, conf, (Map<String, Object>)params, skippedFields, encodeParamsAsJson, confirmationLoggingLevel, evidence$1);
    }

    public static Map query$default$4(RestCommunication $this) {
        return Map$.MODULE$.empty();
    }

    public static Seq query$default$5(RestCommunication $this) {
        return (Seq)Seq$.MODULE$.empty();
    }

    public static Enumeration.Value query$default$6(RestCommunication $this) {
        return $this.LoggingLevel().Info();
    }

    public static Object update(RestCommunication $this, URI endpoint, String suffix, H2OConf conf, Map params, Seq skippedFields, boolean encodeParamsAsJson, ClassTag evidence$2) {
        return $this.request(endpoint, "POST", suffix, conf, (Map<String, Object>)params, skippedFields, encodeParamsAsJson, $this.request$default$8(), evidence$2);
    }

    public static Map update$default$4(RestCommunication $this) {
        return Map$.MODULE$.empty();
    }

    public static Seq update$default$5(RestCommunication $this) {
        return (Seq)Seq$.MODULE$.empty();
    }

    public static boolean update$default$6(RestCommunication $this) {
        return false;
    }

    public static Object delete(RestCommunication $this, URI endpoint, String suffix, H2OConf conf, Map params, Seq skippedFields, boolean encodeParamsAsJson, ClassTag evidence$3) {
        return $this.request(endpoint, "DELETE", suffix, conf, (Map<String, Object>)params, skippedFields, encodeParamsAsJson, $this.request$default$8(), evidence$3);
    }

    public static OutputStream insertToNode(RestCommunication $this, NodeDesc node, String suffix, H2OConf conf, Map params) {
        URI endpoint = RestApiUtils$.MODULE$.resolveNodeEndpoint(node, conf);
        Serializable addCompression = new Serializable($this, conf){
            public static final long serialVersionUID = 0L;
            private final H2OConf conf$2;

            public final OutputStream apply(OutputStream outputStream) {
                return Compression$.MODULE$.compress(this.conf$2.externalCommunicationCompression(), outputStream);
            }
            {
                this.conf$2 = conf$2;
            }
        };
        return $this.insert(endpoint, suffix, conf, (Function1<OutputStream, OutputStream>)addCompression, (Map<String, Object>)params);
    }

    public static OutputStream insert(RestCommunication $this, URI endpoint, String suffix, H2OConf conf, Function1 streamWrapper, Map params) {
        URL url = RestCommunication$class.resolveUrl($this, endpoint, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "?", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{suffix, $this.stringifyParams(params, $this.stringifyParams$default$2())})));
        try {
            HttpURLConnection connection = RestCommunication$class.openUrlConnection($this, url, conf);
            String requestMethod = "PUT";
            connection.setRequestMethod(requestMethod);
            connection.setDoOutput(true);
            connection.setChunkedStreamingMode(-1);
            RestCommunication$class.setHeaders($this, connection, conf, requestMethod, params, false, (Option)None$.MODULE$);
            OutputStream outputStream = connection.getOutputStream();
            OutputStream wrappedStream = (OutputStream)streamWrapper.apply((Object)outputStream);
            return new FinalizingOutputStream(wrappedStream, (Function0<BoxedUnit>)new Serializable($this, connection){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ RestCommunication $outer;
                private final HttpURLConnection connection$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.$outer.checkResponseCode(this.connection$1, this.$outer.checkResponseCode$default$2());
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.connection$1 = connection$1;
                }
            });
        }
        catch (Exception exception) {
            throw RestCommunication$class.throwRestApiNotReachableException($this, url, exception);
        }
    }

    public static Map insertToNode$default$4(RestCommunication $this) {
        return Map$.MODULE$.empty();
    }

    public static Function1 insert$default$4(RestCommunication $this) {
        return new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final OutputStream apply(OutputStream x2) {
                return (OutputStream)Predef$.MODULE$.identity((Object)x2);
            }
        };
    }

    public static Map insert$default$5(RestCommunication $this) {
        return Map$.MODULE$.empty();
    }

    public static void delete(RestCommunication $this, URI endpoint, String suffix, H2OConf conf) {
        ScalaUtils$.MODULE$.withResource($this.readURLContent(endpoint, "DELETE", suffix, conf, (Map<String, Object>)Map$.MODULE$.empty(), false, (Option<String>)None$.MODULE$, $this.readURLContent$default$8()), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final InputStream apply(InputStream x2) {
                return (InputStream)Predef$.MODULE$.identity((Object)x2);
            }
        });
    }

    public static Map delete$default$4(RestCommunication $this) {
        return Map$.MODULE$.empty();
    }

    public static Seq delete$default$5(RestCommunication $this) {
        return (Seq)Seq$.MODULE$.empty();
    }

    public static boolean delete$default$6(RestCommunication $this) {
        return false;
    }

    public static Object request(RestCommunication $this, URI endpoint, String requestType, String suffix, H2OConf conf, Map params, Seq skippedFields, boolean encodeParamsAsJson, Enumeration.Value confirmationLoggingLevel, ClassTag evidence$4) {
        return ScalaUtils$.MODULE$.withResource($this.readURLContent(endpoint, requestType, suffix, conf, (Map<String, Object>)params, encodeParamsAsJson, (Option<String>)None$.MODULE$, confirmationLoggingLevel), new Serializable($this, skippedFields, evidence$4){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ RestCommunication $outer;
            private final Seq skippedFields$2;
            private final ClassTag evidence$4$1;

            public final ResultType apply(InputStream response) {
                String content = IOUtils.toString((InputStream)response);
                return this.$outer.deserialize(content, this.skippedFields$2, this.evidence$4$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.skippedFields$2 = skippedFields$2;
                this.evidence$4$1 = evidence$4$1;
            }
        });
    }

    public static Map request$default$5(RestCommunication $this) {
        return Map$.MODULE$.empty();
    }

    public static Seq request$default$6(RestCommunication $this) {
        return (Seq)Seq$.MODULE$.empty();
    }

    public static boolean request$default$7(RestCommunication $this) {
        return false;
    }

    public static Enumeration.Value request$default$8(RestCommunication $this) {
        return $this.LoggingLevel().Info();
    }

    private static Gson createGsonSerde(RestCommunication $this, Seq skippedFields) {
        GsonBuilder builder = new GsonBuilder();
        ExclusionStrategy exclusionStrategy = new ExclusionStrategy($this, skippedFields){
            private final Seq skippedFields$1;

            public boolean shouldSkipField(FieldAttributes f2) {
                return this.skippedFields$1.exists((Function1)new Serializable(this, f2){
                    public static final long serialVersionUID = 0L;
                    private final FieldAttributes f$1;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(Tuple2<Class<?>, String> x0$1) {
                        Tuple2<Class<?>, String> tuple2 = x0$1;
                        if (tuple2 == null) return false;
                        Class clazz = (Class)tuple2._1();
                        String fieldName = (String)tuple2._2();
                        if (!(clazz instanceof Class)) return false;
                        Class clazz2 = clazz;
                        if (fieldName == null) return false;
                        String string = fieldName;
                        Class clazz3 = clazz2;
                        Class<?> clazz4 = this.f$1.getDeclaringClass();
                        if (clazz3 == null) {
                            if (clazz4 != null) {
                                return false;
                            }
                        } else if (!clazz3.equals(clazz4)) return false;
                        String string2 = string;
                        String string3 = this.f$1.getName();
                        if (string2 == null) {
                            if (string3 == null) return true;
                            return false;
                        } else {
                            if (!string2.equals(string3)) return false;
                            return true;
                        }
                    }
                    {
                        this.f$1 = f$1;
                    }
                });
            }

            public boolean shouldSkipClass(Class<?> incomingClass) {
                return false;
            }
            {
                this.skippedFields$1 = skippedFields$1;
            }
        };
        builder.addDeserializationExclusionStrategy(exclusionStrategy);
        return builder.create();
    }

    public static Object deserialize(RestCommunication $this, String content, Seq skippedFields, ClassTag evidence$5) {
        return RestCommunication$class.createGsonSerde($this, skippedFields).fromJson(content, (Type)package$.MODULE$.classTag(evidence$5).runtimeClass());
    }

    public static Object deserialize(RestCommunication $this, JsonElement content, Seq skippedFields, ClassTag evidence$6) {
        return RestCommunication$class.createGsonSerde($this, skippedFields).fromJson(content, (Type)package$.MODULE$.classTag(evidence$6).runtimeClass());
    }

    public static JsonObject deserializeAsJsonObject(RestCommunication $this, String content, Seq skippedFields) {
        return RestCommunication$class.createGsonSerde($this, skippedFields).fromJson(content, JsonObject.class);
    }

    public static void downloadBinaryURLContent(RestCommunication $this, URI endpoint, String suffix, H2OConf conf, File file) {
        ScalaUtils$.MODULE$.withResource($this.readURLContent(endpoint, "GET", suffix, conf, (Map<String, Object>)Map$.MODULE$.empty(), false, (Option<String>)None$.MODULE$, $this.readURLContent$default$8()), new Serializable($this, file){
            public static final long serialVersionUID = 0L;
            private final File file$1;

            public final int apply(InputStream input) {
                return BoxesRunTime.unboxToInt(ScalaUtils$.MODULE$.withResource(new BufferedOutputStream(new FileOutputStream(this.file$1)), new Serializable(this, input){
                    public static final long serialVersionUID = 0L;
                    private final InputStream input$1;

                    public final int apply(BufferedOutputStream output) {
                        return IOUtils.copy((InputStream)this.input$1, (OutputStream)output);
                    }
                    {
                        this.input$1 = input$1;
                    }
                }));
            }
            {
                this.file$1 = file$1;
            }
        });
    }

    public static void downloadStringURLContent(RestCommunication $this, URI endpoint, String suffix, H2OConf conf, File file) {
        ScalaUtils$.MODULE$.withResource($this.readURLContent(endpoint, "GET", suffix, conf, (Map<String, Object>)Map$.MODULE$.empty(), false, (Option<String>)None$.MODULE$, $this.readURLContent$default$8()), new Serializable($this, file){
            public static final long serialVersionUID = 0L;
            private final File file$2;

            public final void apply(InputStream input) {
                ScalaUtils$.MODULE$.withResource(new FileWriter(this.file$2), new Serializable(this, input){
                    public static final long serialVersionUID = 0L;
                    private final InputStream input$2;

                    public final void apply(FileWriter output) {
                        IOUtils.copy((InputStream)this.input$2, (Writer)output);
                    }
                    {
                        this.input$2 = input$2;
                    }
                });
            }
            {
                this.file$2 = file$2;
            }
        });
    }

    private static Option getCredentials(RestCommunication $this, H2OConf conf) {
        None$ none$;
        Option<String> username = conf.userName();
        Option<String> password = conf.password();
        if (username.isDefined() && password.isDefined()) {
            String userpass = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{username.get(), password.get()}));
            none$ = new Some((Object)new StringBuilder().append((Object)"Basic ").append((Object)DatatypeConverter.printBase64Binary((byte[])userpass.getBytes())).toString());
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private static String urlToString(RestCommunication $this, URL url) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "://", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url.getProtocol(), url.getHost(), BoxesRunTime.boxToInteger((int)url.getPort())}));
    }

    private static HttpURLConnection openUrlConnection(RestCommunication $this, URL url, H2OConf conf) {
        HttpURLConnection httpURLConnection;
        URLConnection connection = url.openConnection();
        if (connection instanceof HttpsURLConnection) {
            HttpsURLConnection secureConnection = (HttpsURLConnection)connection;
            if (conf.isSslCertificateVerificationInInternalRestConnectionsEnabled()) {
                if (conf.autoFlowSsl()) {
                    RestCommunication$class.setSelfSignedCertificateVerification($this, secureConnection, conf);
                }
            } else {
                RestCommunication$class.disableCertificateVerification($this, secureConnection);
            }
            if (!conf.isSslHostnameVerificationInInternalRestConnectionsEnabled() || !conf.isSslCertificateVerificationInInternalRestConnectionsEnabled() || conf.autoFlowSsl()) {
                RestCommunication$class.disableHostnameVerification($this, secureConnection);
            }
            httpURLConnection = secureConnection;
        } else {
            httpURLConnection = (HttpURLConnection)connection;
        }
        return httpURLConnection;
    }

    private static SSLContext createSSLContext(RestCommunication $this) {
        return SSLContext.getInstance("TLSv1.2");
    }

    private static void disableHostnameVerification(RestCommunication $this, HttpsURLConnection secureConnection) {
        HostnameVerifier hostnameVerifier = new HostnameVerifier($this){

            public boolean verify(String s2, SSLSession sslSession) {
                return true;
            }
        };
        secureConnection.setHostnameVerifier(hostnameVerifier);
    }

    private static void disableCertificateVerification(RestCommunication $this, HttpsURLConnection connection) {
        X509TrustManager allCertificatesTrustedManager = new X509TrustManager($this){

            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            public void checkClientTrusted(X509Certificate[] x509Certificates, String s2) {
            }

            public void checkServerTrusted(X509Certificate[] x509Certificates, String s2) {
            }
        };
        SSLContext sslContext = RestCommunication$class.createSSLContext($this);
        sslContext.init(null, (TrustManager[])((Object[])new TrustManager[]{allCertificatesTrustedManager}), null);
        connection.setSSLSocketFactory(sslContext.getSocketFactory());
    }

    private static void setSelfSignedCertificateVerification(RestCommunication $this, HttpsURLConnection connection, H2OConf conf) {
        KeyStore keyStore = RestCommunication$class.loadKeyStore($this, conf);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keyStore);
        SSLContext sslContext = RestCommunication$class.createSSLContext($this);
        sslContext.init(null, trustManagerFactory.getTrustManagers(), null);
        connection.setSSLSocketFactory(sslContext.getSocketFactory());
    }

    private static KeyStore loadKeyStore(RestCommunication $this, H2OConf conf) {
        String localJKSFile = SparkFiles$.MODULE$.get(new File((String)conf.jks().get()).getName());
        return (KeyStore)ScalaUtils$.MODULE$.withResource(new FileInputStream(localJKSFile), new Serializable($this, conf){
            public static final long serialVersionUID = 0L;
            private final H2OConf conf$1;

            /*
             * WARNING - void declaration
             */
            public final KeyStore apply(FileInputStream inputStream) {
                void var2_2;
                KeyStore keyStore = KeyStore.getInstance("JKS");
                String password = (String)this.conf$1.jksPass().get();
                keyStore.load(inputStream, password.toCharArray());
                return var2_2;
            }
            {
                this.conf$1 = conf$1;
            }
        });
    }

    private static URL resolveUrl(RestCommunication $this, URI endpoint, String suffix) {
        String endpointAsString = endpoint.toString();
        String endpointWithDelimiter = endpointAsString.endsWith("/") ? endpointAsString : new StringBuilder().append((Object)endpointAsString).append((Object)"/").toString();
        String suffixWithoutDelimiter = new StringOps(Predef$.MODULE$.augmentString(suffix)).stripPrefix("/");
        String string = endpoint.getScheme();
        String string2 = "https";
        Handler handler = !(string != null ? !string.equals(string2) : string2 != null) ? new sun.net.www.protocol.https.Handler() : new Handler();
        String spec = new URI(endpointWithDelimiter).resolve(suffixWithoutDelimiter).toURL().toString();
        return new URL(null, spec, handler);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static void setHeaders(RestCommunication $this, HttpURLConnection connection, H2OConf conf, String requestType, Map params, boolean encodeParamsAsJson, Option file) {
        RestCommunication$class.getCredentials($this, conf).foreach((Function1)new Serializable($this, connection){
            public static final long serialVersionUID = 0L;
            private final HttpURLConnection connection$2;

            public final void apply(String x$1) {
                this.connection$2.setRequestProperty("Authorization", x$1);
            }
            {
                this.connection$2 = connection$2;
            }
        });
        if (!params.nonEmpty() || !file.isEmpty()) ** GOTO lbl-1000
        v0 = requestType;
        var7_7 = "POST";
        if (!(v0 != null ? v0.equals(var7_7) == false : var7_7 != null)) {
            if (encodeParamsAsJson) {
                connection.setRequestProperty("Content-Type", "application/json");
            } else {
                connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            }
            paramsAsBytes = $this.stringifyParams(params, encodeParamsAsJson).getBytes("UTF-8");
            connection.setRequestProperty("charset", "UTF-8");
            connection.setRequestProperty("Content-Length", Integer.toString(paramsAsBytes.length));
            connection.setDoOutput(true);
            v1 /* !! */  = ScalaUtils$.MODULE$.withResource(new DataOutputStream(connection.getOutputStream()), new Serializable($this, paramsAsBytes){
                public static final long serialVersionUID = 0L;
                private final byte[] paramsAsBytes$1;

                public final void apply(DataOutputStream writer) {
                    writer.write(this.paramsAsBytes$1);
                }
                {
                    this.paramsAsBytes$1 = paramsAsBytes$1;
                }
            });
        } else lbl-1000:
        // 2 sources

        {
            v1 /* !! */  = BoxedUnit.UNIT;
        }
        if (params.isEmpty() && file.isDefined()) {
            v2 = requestType;
            var9_9 = "POST";
            if (!(v2 != null ? v2.equals(var9_9) == false : var9_9 != null)) {
                boundary = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"===", "==="})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)System.currentTimeMillis())}));
                connection.setRequestProperty("Content-Type", new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"multipart/form-data;boundary=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{boundary})));
                connection.setRequestProperty("charset", "UTF-8");
                CRLF = "\r\n";
                connection.setDoOutput(true);
                body = new PrintWriter((Writer)new OutputStreamWriter(connection.getOutputStream(), "UTF-8"), true);
                body.append(CRLF);
                body.flush();
                IOUtils.copy((InputStream)new FileInputStream((String)file.get()), (OutputStream)connection.getOutputStream());
                connection.getOutputStream().flush();
                body.append(CRLF);
                body.flush();
                body.append("--").append(boundary).append("--").append(CRLF);
                body.flush();
            }
        }
    }

    private static boolean setHeaders$default$5(RestCommunication $this) {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static InputStream readURLContent(RestCommunication $this, URI endpoint, String requestType, String suffix, H2OConf conf, Map params, boolean encodeParamsAsJson, Option file, Enumeration.Value confirmationLoggingLevel) {
        if (!params.nonEmpty()) ** GOTO lbl-1000
        v0 = requestType;
        var10_9 = "GET";
        if (!(v0 != null ? v0.equals(var10_9) == false : var10_9 != null)) {
            v1 = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "?", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{suffix, $this.stringifyParams(params, $this.stringifyParams$default$2())}));
        } else lbl-1000:
        // 2 sources

        {
            v1 = suffix;
        }
        suffixWithParams = v1;
        url = RestCommunication$class.resolveUrl($this, endpoint, suffixWithParams);
        try {
            connection = RestCommunication$class.openUrlConnection($this, url, conf);
            connection.setRequestMethod(requestType);
            RestCommunication$class.setHeaders($this, connection, conf, requestType, params, encodeParamsAsJson, file);
            $this.checkResponseCode(connection, confirmationLoggingLevel);
            return connection.getInputStream();
        }
        catch (Exception var12_13) {
            throw RestCommunication$class.throwRestApiNotReachableException($this, url, var12_13);
        }
        catch (RestApiException var13_14) {
            throw var13_14;
        }
    }

    public static Map readURLContent$default$5(RestCommunication $this) {
        return Map$.MODULE$.empty();
    }

    public static boolean readURLContent$default$6(RestCommunication $this) {
        return false;
    }

    public static Option readURLContent$default$7(RestCommunication $this) {
        return None$.MODULE$;
    }

    public static Enumeration.Value readURLContent$default$8(RestCommunication $this) {
        return $this.LoggingLevel().Info();
    }

    public static void checkResponseCode(RestCommunication $this, HttpURLConnection connection, Enumeration.Value confirmationLoggingLevel) {
        Enumeration.Value value;
        block8: {
            block7: {
                String message;
                block6: {
                    int statusCode;
                    URL url = connection.getURL();
                    String requestType = connection.getRequestMethod();
                    int n2 = statusCode = BoxesRunTime.unboxToInt((Object)RestCommunication$class.retry($this, 3, (Function0)new Serializable($this, connection){
                        public static final long serialVersionUID = 0L;
                        private final HttpURLConnection connection$3;

                        public final int apply() {
                            return this.apply$mcI$sp();
                        }

                        public int apply$mcI$sp() {
                            return this.connection$3.getResponseCode();
                        }
                        {
                            this.connection$3 = connection$3;
                        }
                    }));
                    switch (n2) {
                        default: {
                            throw new RestApiCommunicationException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"H2O node ", " responded with\n           |Status code: ", " : ", "\n           |Server error: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RestCommunication$class.urlToString($this, url), BoxesRunTime.boxToInteger((int)statusCode), connection.getResponseMessage(), RestCommunication$class.getServerError($this, connection)})))).stripMargin());
                        }
                        case 401: {
                            throw new RestApiUnauthorisedException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"H2O node ", " could not be reached because the client is not authorized.\n           |Please make sure you have passed valid credentials to the client.\n           |Status code ", " : ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RestCommunication$class.urlToString($this, url), BoxesRunTime.boxToInteger((int)statusCode), connection.getResponseMessage()})))).stripMargin());
                        }
                        case 200: 
                    }
                    message = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"H2O node ", " successfully responded for the ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{url, requestType}));
                    value = confirmationLoggingLevel;
                    Enumeration.Value value2 = $this.LoggingLevel().Info();
                    Enumeration.Value value3 = value;
                    if (value2 != null ? !value2.equals(value3) : value3 != null) break block6;
                    $this.logInfo((Function0)new Serializable($this, message){
                        public static final long serialVersionUID = 0L;
                        private final String message$1;

                        public final String apply() {
                            return this.message$1;
                        }
                        {
                            this.message$1 = message$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block7;
                }
                Enumeration.Value value4 = $this.LoggingLevel().Debug();
                Enumeration.Value value5 = value;
                if (value4 != null ? !value4.equals(value5) : value5 != null) break block8;
                $this.logDebug((Function0)new Serializable($this, message){
                    public static final long serialVersionUID = 0L;
                    private final String message$1;

                    public final String apply() {
                        return this.message$1;
                    }
                    {
                        this.message$1 = message$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)value);
    }

    public static Enumeration.Value checkResponseCode$default$2(RestCommunication $this) {
        return $this.LoggingLevel().Info();
    }

    private static String getServerError(RestCommunication $this, HttpURLConnection connection) {
        return connection.getErrorStream() == null ? "No error" : (String)ScalaUtils$.MODULE$.withResource(connection.getErrorStream(), new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(InputStream errorStream) {
                return IOUtils.toString((InputStream)errorStream);
            }
        });
    }

    private static Nothing$ throwRestApiNotReachableException(RestCommunication $this, URL url, Exception e2) {
        throw new RestApiNotReachableException(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"H2O node ", " is not reachable.\n         |Please verify that you are passing ip and port of existing cluster node and the cluster\n         |is running with web enabled."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{RestCommunication$class.urlToString($this, url)})))).stripMargin(), e2);
    }

    private static Object retry(RestCommunication $this, int n2, Function0 fn) {
        Try try_;
        while (true) {
            if ((try_ = Try$.MODULE$.apply(fn)) instanceof Success) {
                Object x2;
                Success success = (Success)try_;
                Object object = x2 = success.value();
                return object;
            }
            if (n2 <= 1) break;
            Thread.sleep(100L);
            --n2;
        }
        if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable e2 = failure.exception();
            throw e2;
        }
        throw new MatchError((Object)try_);
    }

    public static void $init$(RestCommunication $this) {
    }
}

