/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.backend.utils;

import ai.h2o.sparkling.H2OConf;
import ai.h2o.sparkling.backend.NodeDesc;
import ai.h2o.sparkling.backend.SharedBackendConf$;
import ai.h2o.sparkling.backend.utils.ArgumentBuilder;
import ai.h2o.sparkling.backend.utils.AzureDatabricksUtils$;
import ai.h2o.sparkling.backend.utils.H2OClientUtils$;
import ai.h2o.sparkling.backend.utils.SecurityUtils$;
import ai.h2o.sparkling.backend.utils.SharedBackendUtils;
import ai.h2o.sparkling.backend.utils.SharedBackendUtils$;
import java.io.File;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.nio.file.Paths;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkFiles$;
import org.apache.spark.expose.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.util.matching.Regex;

public abstract class SharedBackendUtils$class {
    public static String getHostname(SharedBackendUtils $this, SparkEnv env) {
        return env.blockManager().blockManagerId().host();
    }

    public static H2OConf checkAndUpdateConf(SharedBackendUtils $this, H2OConf conf) {
        block17: {
            Object object;
            block16: {
                Object object2;
                if (AzureDatabricksUtils$.MODULE$.isRunningOnAzureDatabricks(conf)) {
                    AzureDatabricksUtils$.MODULE$.setClientWebPort(conf);
                    object2 = BoxesRunTime.boxToInteger((int)AzureDatabricksUtils$.MODULE$.setClientCheckRetryTimeout(conf));
                } else {
                    object2 = BoxedUnit.UNIT;
                }
                if (conf.isInternalSecureConnectionsEnabled() && conf.sslConf().isEmpty()) {
                    SecurityUtils$.MODULE$.enableSSL(conf);
                }
                Object object3 = conf.autoFlowSsl() ? SecurityUtils$.MODULE$.enableFlowSSL(conf) : BoxedUnit.UNIT;
                String string = conf.backendClusterMode();
                String string2 = "internal";
                if (!(string == null ? string2 != null : !string.equals(string2))) break block16;
                String string3 = conf.backendClusterMode();
                String string4 = "external";
                if (string3 != null ? !string3.equals(string4) : string4 != null) break block17;
            }
            if (conf.contextPath().isDefined()) {
                if (((String)conf.contextPath().get()).startsWith("/")) {
                    Regex pattern = new StringOps(Predef$.MODULE$.augmentString("^//(/*)")).r();
                    if (pattern.findFirstIn((CharSequence)conf.contextPath().get()).isDefined()) {
                        $this.logWarning((Function0)new Serializable($this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "Context path contains multiple starting \"/\", it can contain only one. Replacing with one slash";
                            }
                        });
                        object = conf.setContextPath(pattern.replaceFirstIn((CharSequence)conf.contextPath().get(), "/"));
                    } else {
                        object = BoxedUnit.UNIT;
                    }
                } else {
                    $this.logWarning((Function0)new Serializable($this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Context path does not start with mandatory \"/\", appending it.";
                        }
                    });
                    object = conf.setContextPath(new StringBuilder().append((Object)"/").append(conf.contextPath().get()).toString());
                }
            } else {
                object = BoxedUnit.UNIT;
            }
            Object object4 = conf.clientVerboseOutput() ? conf.setLogLevel(SharedBackendUtils$class.incLogLevel($this, conf.logLevel(), "INFO")) : BoxedUnit.UNIT;
            if (conf.isKerberizedHiveEnabled()) {
                if (conf.hiveHost().isEmpty() && conf.hiveJdbcUrlPattern().isEmpty()) {
                    throw new IllegalArgumentException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"When Hive support is enabled, the option '", "' "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SharedBackendConf$.MODULE$.PROP_HIVE_HOST()._1()}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"or '", "' must be defined."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SharedBackendConf$.MODULE$.PROP_HIVE_JDBC_URL_PATTERN()._1()}))).toString());
                }
                if (conf.hivePrincipal().isEmpty()) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"When Hive support is enabled, the option '", "' must be defined."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SharedBackendConf$.MODULE$.PROP_HIVE_PRINCIPAL()._1()})));
                }
                if (conf.hiveToken().isEmpty()) {
                    throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"When Hive support is enabled, the option '", "' must be defined."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SharedBackendConf$.MODULE$.PROP_HIVE_TOKEN()._1()})));
                }
            }
            return conf;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "' property is set to ", ".\n          Valid options are \"", "\" or \"", "\".\n      "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{SharedBackendConf$.MODULE$.PROP_BACKEND_CLUSTER_MODE()._1(), conf.backendClusterMode(), SharedBackendConf$.MODULE$.BACKEND_MODE_INTERNAL(), SharedBackendConf$.MODULE$.BACKEND_MODE_EXTERNAL()})));
    }

    public static void distributeFiles(SharedBackendUtils $this, H2OConf conf, SparkContext sc) {
        conf.getFileProperties().foreach((Function1)new Serializable($this, conf, sc){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SharedBackendUtils $outer;
            private final H2OConf conf$2;
            public final SparkContext sc$1;

            public final void apply(Tuple4<String, ?, ?, ?> fileProperty) {
                this.conf$2.getOption((String)fileProperty._1()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ SharedBackendUtils$.anonfun.distributeFiles.1 $outer;

                    public final void apply(String filePath) {
                        if (!SharedBackendUtils$class.ai$h2o$sparkling$backend$utils$SharedBackendUtils$$isFileDistributed(this.$outer.ai$h2o$sparkling$backend$utils$SharedBackendUtils$$anonfun$$$outer(), this.$outer.sc$1, filePath)) {
                            this.$outer.sc$1.addFile(filePath);
                        }
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ SharedBackendUtils ai$h2o$sparkling$backend$utils$SharedBackendUtils$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.conf$2 = conf$2;
                this.sc$1 = sc$1;
            }
        });
    }

    public static boolean ai$h2o$sparkling$backend$utils$SharedBackendUtils$$isFileDistributed(SharedBackendUtils $this, SparkContext sc, String filePath) {
        String fileName = new File(filePath).getName();
        return sc.listFiles().exists((Function1)new Serializable($this, fileName){
            public static final long serialVersionUID = 0L;
            private final String fileName$1;

            public final boolean apply(String x$1) {
                String string = new File(x$1).getName();
                String string2 = this.fileName$1;
                return !(string != null ? !string.equals(string2) : string2 != null);
            }
            {
                this.fileName$1 = fileName$1;
            }
        });
    }

    public static Seq getH2OSecurityArgs(SharedBackendUtils $this, H2OConf conf) {
        return new ArgumentBuilder().add("-jks", (Option<Object>)SharedBackendUtils$class.getDistributedFilePath($this, conf.jks())).add("-jks_pass", conf.jksPass()).add("-jks_alias", conf.jksAlias()).addIf("-hash_login", conf.hashLogin()).addIf("-ldap_login", conf.ldapLogin()).addIf("-kerberos_login", conf.kerberosLogin()).add("-user_name", conf.userName()).add("-login_conf", (Option<Object>)SharedBackendUtils$class.getDistributedFilePath($this, conf.loginConf())).add("-internal_security_conf", (Option<Object>)SharedBackendUtils$class.getDistributedFilePath($this, conf.sslConf())).add("-allow_insecure_xgboost", conf.isInsecureXGBoostAllowed()).buildArgs();
    }

    public static Seq getH2OCommonArgs(SharedBackendUtils $this, H2OConf conf) {
        return new ArgumentBuilder().add(H2OClientUtils$.MODULE$.getH2OCommonArgsWhenClientBased(conf), H2OClientUtils$.MODULE$.isH2OClientBased(conf)).add("-internal_security_conf_rel_paths").add("-name", (String)conf.cloudName().get()).add("-port_offset", conf.internalPortOffset()).add("-context_path", conf.contextPath()).add("-stacktrace_collector_interval", (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)conf.stacktraceCollectorInterval())).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$2) {
                return this.apply$mcZI$sp(x$2);
            }

            public boolean apply$mcZI$sp(int x$2) {
                return x$2 > 0;
            }
        })).add("-nthreads", (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)conf.nthreads())).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$3) {
                return this.apply$mcZI$sp(x$3);
            }

            public boolean apply$mcZI$sp(int x$3) {
                return x$3 > 0;
            }
        }).orElse((Function0)new Serializable($this, conf){
            public static final long serialVersionUID = 0L;
            private final H2OConf conf$3;

            public final Option<String> apply() {
                return this.conf$3.sparkConf().getOption("spark.executor.cores");
            }
            {
                this.conf$3 = conf$3;
            }
        })).add("-hdfs_config", (Option<Object>)SharedBackendUtils$class.getDistributedFilePath($this, conf.hdfsConf())).add($this.getExtraHttpHeaderArgs(conf)).add("-log_level", conf.logLevel()).add("-embedded").add("-baseport", conf.basePort()).add("-log_dir", SharedBackendUtils$class.determineLogDir($this, conf)).add("-ice_root", conf.icedDir()).add("-flow_dir", conf.flowDir()).addAsString(conf.extraProperties()).buildArgs();
    }

    public static Seq getH2OWorkerAsClientArgs(SharedBackendUtils $this, H2OConf conf) {
        return new ArgumentBuilder().add($this.getH2OCommonArgs(conf)).add($this.getH2OSecurityArgs(conf)).addIf("-quiet", !conf.clientVerboseOutput()).add("-port", (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)conf.clientWebPort())).filter((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(int x$4) {
                return this.apply$mcZI$sp(x$4);
            }

            public boolean apply$mcZI$sp(int x$4) {
                return x$4 > 0;
            }
        })).buildArgs();
    }

    private static String determineLogDir(SharedBackendUtils $this, H2OConf conf) {
        return (String)Option$.MODULE$.apply((Object)System.getProperty("spark.yarn.app.container.log.dir")).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$5) {
                return new StringBuilder().append((Object)x$5).append((Object)File.separator).toString();
            }
        }).orElse((Function0)new Serializable($this, conf){
            public static final long serialVersionUID = 0L;
            private final H2OConf conf$1;

            public final Option<String> apply() {
                return this.conf$1.logDir();
            }
            {
                this.conf$1 = conf$1;
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ((Object)Paths.get(System.getProperty("user.dir"), "h2ologs", SparkEnv$.MODULE$.get().conf().getAppId()).toAbsolutePath()).toString();
            }
        });
    }

    public static Seq parseStringToHttpHeaderArgs(SharedBackendUtils $this, String headers) {
        Regex headerPattern = new StringOps(Predef$.MODULE$.augmentString("^\\s*([^:]+)\\:\\s*(.+)$")).r();
        return (Seq)Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(headers)).split('\n')).flatMap((Function1)new Serializable($this, headerPattern){
            public static final long serialVersionUID = 0L;
            private final Regex headerPattern$1;

            public final Seq<String> apply(String x0$1) {
                Seq seq;
                String string = x0$1;
                Option option = this.headerPattern$1.unapplySeq((CharSequence)string);
                if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                    String key = (String)((LinearSeqOptimized)option.get()).apply(0);
                    String value = (String)((LinearSeqOptimized)option.get()).apply(1);
                    seq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"-add_http_header", key, value}));
                } else {
                    seq = (Seq)Seq$.MODULE$.empty();
                }
                return seq;
            }
            {
                this.headerPattern$1 = headerPattern$1;
            }
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public static Seq getExtraHttpHeaderArgs(SharedBackendUtils $this, H2OConf conf) {
        return (Seq)conf.flowExtraHttpHeaders().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SharedBackendUtils $outer;

            public final Seq<String> apply(String headers) {
                return this.$outer.parseStringToHttpHeaderArgs(headers);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)Seq$.MODULE$.empty();
            }
        });
    }

    public static String[] toH2OArgs(SharedBackendUtils $this, Seq h2oArgs, NodeDesc[] executors) {
        String flatFileString = SharedBackendUtils$class.toFlatFileString($this, executors);
        File flatFile = $this.saveFlatFileAsFile(flatFileString);
        return (String[])Predef$.MODULE$.refArrayOps((Object[])h2oArgs.toArray(ClassTag$.MODULE$.apply(String.class))).$plus$plus((GenTraversableOnce)Predef$.MODULE$.refArrayOps((Object[])new String[]{"-flatfile", flatFile.getAbsolutePath()}), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
    }

    public static NodeDesc[] toH2OArgs$default$2(SharedBackendUtils $this) {
        return (NodeDesc[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(NodeDesc.class));
    }

    public static File createTempDir(SharedBackendUtils $this) {
        String sparkLocalDir = Utils$.MODULE$.getLocalDir(SparkEnv$.MODULE$.get().conf());
        return Utils$.MODULE$.createTempDir(sparkLocalDir, "sparkling-water");
    }

    /*
     * WARNING - void declaration
     */
    public static File saveFlatFileAsFile(SharedBackendUtils $this, String content) {
        File tmpDir = $this.createTempDir();
        File flatFile = new File(tmpDir, "flatfile.txt");
        PrintWriter p2 = new PrintWriter(flatFile);
        try {
            void var3_3;
            p2.print(content);
            p2.close();
            return var3_3;
        }
        catch (Throwable throwable) {
            void var4_4;
            var4_4.close();
            throw throwable;
        }
    }

    public static String translateHostnameToIp(SharedBackendUtils $this, String hostname) {
        return InetAddress.getByName(hostname).getHostAddress();
    }

    private static Option getDistributedFilePath(SharedBackendUtils $this, Option fileConf) {
        return fileConf.map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply(String name) {
                return SparkFiles$.MODULE$.get(new File(name).getName());
            }
        });
    }

    private static String incLogLevel(SharedBackendUtils $this, String logLevel, String minLogLevel) {
        Seq logLevels = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"OFF", (Object)BoxesRunTime.boxToInteger((int)0)), new Tuple2((Object)"FATAL", (Object)BoxesRunTime.boxToInteger((int)1)), new Tuple2((Object)"ERROR", (Object)BoxesRunTime.boxToInteger((int)2)), new Tuple2((Object)"WARN", (Object)BoxesRunTime.boxToInteger((int)3)), new Tuple2((Object)"INFO", (Object)BoxesRunTime.boxToInteger((int)4)), new Tuple2((Object)"DEBUG", (Object)BoxesRunTime.boxToInteger((int)5)), new Tuple2((Object)"TRACE", (Object)BoxesRunTime.boxToInteger((int)6)), new Tuple2((Object)"ALL", (Object)BoxesRunTime.boxToInteger((int)7))}));
        Option ll = logLevels.find((Function1)new Serializable($this, logLevel){
            public static final long serialVersionUID = 0L;
            private final String logLevel$1;

            public final boolean apply(Tuple2<String, Object> t2) {
                Object object = t2._1();
                String string = this.logLevel$1;
                return !(object != null ? !object.equals(string) : string != null);
            }
            {
                this.logLevel$1 = logLevel$1;
            }
        });
        Option mll = logLevels.find((Function1)new Serializable($this, minLogLevel){
            public static final long serialVersionUID = 0L;
            private final String minLogLevel$1;

            public final boolean apply(Tuple2<String, Object> t2) {
                Object object = t2._1();
                String string = this.minLogLevel$1;
                return !(object != null ? !object.equals(string) : string != null);
            }
            {
                this.minLogLevel$1 = minLogLevel$1;
            }
        });
        return mll.isEmpty() ? logLevel : (String)ll.map((Function1)new Serializable($this, logLevel, minLogLevel, mll){
            public static final long serialVersionUID = 0L;
            private final String logLevel$1;
            private final String minLogLevel$1;
            private final Option mll$1;

            public final String apply(Tuple2<String, Object> v2) {
                return v2._2$mcI$sp() < ((Tuple2)this.mll$1.get())._2$mcI$sp() ? this.minLogLevel$1 : this.logLevel$1;
            }
            {
                this.logLevel$1 = logLevel$1;
                this.minLogLevel$1 = minLogLevel$1;
                this.mll$1 = mll$1;
            }
        }).getOrElse((Function0)new Serializable($this, minLogLevel){
            public static final long serialVersionUID = 0L;
            private final String minLogLevel$1;

            public final String apply() {
                return this.minLogLevel$1;
            }
            {
                this.minLogLevel$1 = minLogLevel$1;
            }
        });
    }

    private static String toFlatFileString(SharedBackendUtils $this, NodeDesc[] executors) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])executors).map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SharedBackendUtils $outer;

            public final String apply(NodeDesc en) {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.translateHostnameToIp(en.hostname()), BoxesRunTime.boxToInteger((int)en.port())}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).mkString("\n");
    }

    public static void $init$(SharedBackendUtils $this) {
    }
}

