/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.extensions.rest.api;

import ai.h2o.sparkling.extensions.internals.CollectCategoricalDomainsTask;
import ai.h2o.sparkling.extensions.internals.ConvertCategoricalToStringColumnsTask;
import ai.h2o.sparkling.extensions.internals.UpdateCategoricalIndicesTask;
import ai.h2o.sparkling.extensions.rest.api.schema.FinalizeFrameV3;
import ai.h2o.sparkling.extensions.rest.api.schema.InitializeFrameV3;
import ai.h2o.sparkling.extensions.rest.api.schema.UploadPlanV3;
import ai.h2o.sparkling.utils.Base64Encoding$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import water.DKV;
import water.H2ONode;
import water.Key;
import water.api.Handler;
import water.fvec.AppendableVec;
import water.fvec.ChunkUtils;
import water.fvec.Frame;
import water.fvec.Vec;
import water.parser.CategoricalPreviewParseWriter;
import water.parser.ParseDataset;
import water.util.Log;

@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001\u001f\t\u0011\u0012*\u001c9peR4%/Y7f\u0011\u0006tG\r\\3s\u0015\t\u0019A!A\u0002ba&T!!\u0002\u0004\u0002\tI,7\u000f\u001e\u0006\u0003\u000f!\t!\"\u001a=uK:\u001c\u0018n\u001c8t\u0015\tI!\"A\u0005ta\u0006\u00148\u000e\\5oO*\u00111\u0002D\u0001\u0004QJz'\"A\u0007\u0002\u0005\u0005L7\u0001A\n\u0003\u0001A\u0001\"!E\u000b\u000e\u0003IQ!aA\n\u000b\u0003Q\tQa^1uKJL!A\u0006\n\u0003\u000f!\u000bg\u000e\u001a7fe\")\u0001\u0004\u0001C\u00013\u00051A(\u001b8jiz\"\u0012A\u0007\t\u00037\u0001i\u0011A\u0001\u0005\u0006;\u0001!\tAH\u0001\u000bS:LG/[1mSj,GcA\u0010&[A\u0011\u0001eI\u0007\u0002C)\u0011!EA\u0001\u0007g\u000eDW-\\1\n\u0005\u0011\n#!E%oSRL\u0017\r\\5{K\u001a\u0013\u0018-\\3Wg!)a\u0005\ba\u0001O\u00059a/\u001a:tS>t\u0007C\u0001\u0015,\u001b\u0005I#\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051J#aA%oi\")a\u0006\ba\u0001?\u00059!/Z9vKN$\b\"\u0002\u0019\u0001\t\u0003\t\u0014\u0001\u00034j]\u0006d\u0017N_3\u0015\u0007I*d\u0007\u0005\u0002!g%\u0011A'\t\u0002\u0010\r&t\u0017\r\\5{K\u001a\u0013\u0018-\\3Wg!)ae\fa\u0001O!)af\fa\u0001e!)\u0001\b\u0001C\u0005s\u0005I4m\u001c8wKJ$8i\u001c7v[:\u001cx+\u001b;i)>|W*\u00198z\u0007\u0006$XmZ8sS\u000e\fG\u000eT3wK2\u001cHk\\*ue&twmQ8mk6t7\u000f\u0006\u0003;{\u0015k\u0005C\u0001\u0015<\u0013\ta\u0014F\u0001\u0003V]&$\b\"\u0002 8\u0001\u0004y\u0014!\u00024sC6,\u0007C\u0001!D\u001b\u0005\t%B\u0001\"\u0014\u0003\u00111g/Z2\n\u0005\u0011\u000b%!\u0002$sC6,\u0007\"\u0002$8\u0001\u00049\u0015aC2pYVlg\u000eV=qKN\u00042\u0001\u000b%K\u0013\tI\u0015FA\u0003BeJ\f\u0017\u0010\u0005\u0002)\u0017&\u0011A*\u000b\u0002\u0005\u0005f$X\rC\u0003Oo\u0001\u0007q*A\u0007tiJLgn\u001a#p[\u0006Lgn\u001d\t\u0004Q!\u0003\u0006c\u0001\u0015I#B\u0011!+\u0016\b\u0003QMK!\u0001V\u0015\u0002\rA\u0013X\rZ3g\u0013\t1vK\u0001\u0004TiJLgn\u001a\u0006\u0003)&BQ!\u0017\u0001\u0005\ni\u000bQfY8om\u0016\u0014HoQ1uK\u001e|'/[2bY\u000e{G.^7ogR{w\n\u001e5feRK\b/Z:JM:+W\rZ3e)\rQ4\f\u0018\u0005\u0006}a\u0003\ra\u0010\u0005\u0006;b\u0003\rAX\u0001\u0019G\u0006$XmZ8sS\u000e\fGnQ8mk6t\u0017J\u001c3jG\u0016\u001c\bc\u0001\u0015IO!)\u0001\r\u0001C\u0005C\u0006q\u0013N\u001c3jG\u0016\u001cxJZ\"iC:<W\rZ\"pYVlgn\u001d$s_6\u001c\u0015\r^3h_JL7-\u00197U_N#(/\u001b8h)\rq&m\u0019\u0005\u0006\r~\u0003\ra\u0012\u0005\u0006\u001d~\u0003\ra\u0014\u0005\u0006K\u0002!IAZ\u0001\u000eKb\u0004\u0018M\u001c3E_6\f\u0017N\\:\u0015\u0007=;\u0007\u000eC\u0003OI\u0002\u0007q\nC\u0003GI\u0002\u0007q\tC\u0003k\u0001\u0011\u00051.A\u0007hKR,\u0006\u000f\\8bIBc\u0017M\u001c\u000b\u0004Y>\u0004\bC\u0001\u0011n\u0013\tq\u0017E\u0001\u0007Va2|\u0017\r\u001a)mC:46\u0007C\u0003'S\u0002\u0007q\u0005C\u0003/S\u0002\u0007A\u000e")
public class ImportFrameHandler
extends Handler {
    public InitializeFrameV3 initialize(int version, InitializeFrameV3 request2) {
        ChunkUtils.initFrame(request2.key, request2.columns);
        return request2;
    }

    public FinalizeFrameV3 finalize(int version, FinalizeFrameV3 request2) {
        long[] rowsPerChunk = Base64Encoding$.MODULE$.decodeToLongArray(request2.rows_per_chunk);
        byte[] columnTypes = Base64Encoding$.MODULE$.decode(request2.column_types);
        Key frameKey = Key.make(request2.key);
        CollectCategoricalDomainsTask collectDomainsTask = new CollectCategoricalDomainsTask(frameKey);
        collectDomainsTask.doAllNodes();
        String[][] stringDomains = collectDomainsTask.getDomains();
        boolean isEmpty = stringDomains == null;
        byte[] columnTypesAwareOfEmptyFrames = isEmpty ? (byte[])Predef$.MODULE$.byteArrayOps(columnTypes).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply(byte columnType) {
                return columnType == 4 ? (byte)2 : (byte)columnType;
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte())) : columnTypes;
        String[][] domains = this.expandDomains(stringDomains, columnTypesAwareOfEmptyFrames);
        ChunkUtils.finalizeFrame(request2.key, rowsPerChunk, columnTypesAwareOfEmptyFrames, domains, false);
        Frame frame = (Frame)DKV.getGet(frameKey);
        this.convertColumnsWithTooManyCategoricalLevelsToStringColumns(frame, columnTypesAwareOfEmptyFrames, stringDomains);
        int[] categoricalColumnIndices = (int[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])frame.vecs()).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Vec, Object> check$ifrefutable$1) {
                Tuple2<Vec, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Vec, Object> x$1) {
                Tuple2<Vec, Object> tuple2 = x$1;
                if (tuple2 != null) {
                    Vec vec = (Vec)tuple2._1();
                    boolean bl = vec.isCategorical();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Tuple2<Vec, Object> x$2) {
                Tuple2<Vec, Object> tuple2 = x$2;
                if (tuple2 != null) {
                    int idx;
                    int n2 = idx = tuple2._2$mcI$sp();
                    return n2;
                }
                throw new MatchError(tuple2);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
        UpdateCategoricalIndicesTask updateCategoricalIndicesTask = new UpdateCategoricalIndicesTask(frameKey, categoricalColumnIndices);
        updateCategoricalIndicesTask.doAll(frame);
        this.convertCategoricalColumnsToOtherTypesIfNeeded(frame, categoricalColumnIndices);
        if (frame.numCols() > 0) {
            ParseDataset.logParseResults(frame);
        }
        frame.update();
        frame.unlock();
        return request2;
    }

    private void convertColumnsWithTooManyCategoricalLevelsToStringColumns(Frame frame, byte[] columnTypes, String[][] stringDomains) {
        int[] indicesOfChanges = this.indicesOfChangedColumnsFromCategoricalToString(columnTypes, stringDomains);
        if (Predef$.MODULE$.intArrayOps(indicesOfChanges).nonEmpty()) {
            Predef$.MODULE$.intArrayOps(indicesOfChanges).foreach((Function1)new Serializable(this, frame){
                public static final long serialVersionUID = 0L;
                private final Frame frame$1;

                public final void apply(int idx) {
                    this.apply$mcVI$sp(idx);
                }

                public void apply$mcVI$sp(int idx) {
                    Log.info(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"A categorical column '", "' exceeded maximum number of categories. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.frame$1.names()[idx]}))).append((Object)"Converting it to a column of strings ...").toString());
                }
                {
                    this.frame$1 = frame$1;
                }
            });
            Vec[] vectorsToBeConvertedToString = (Vec[])Predef$.MODULE$.intArrayOps(indicesOfChanges).map((Function1)new Serializable(this, frame){
                public static final long serialVersionUID = 0L;
                private final Frame frame$1;

                public final Vec apply(int x$3) {
                    return this.frame$1.vec(x$3);
                }
                {
                    this.frame$1 = frame$1;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Vec.class)));
            int[] domainIndices = (int[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])stringDomains).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String[], Object> check$ifrefutable$2) {
                    Tuple2<String[], Object> tuple2 = check$ifrefutable$2;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String[], Object> x$4) {
                    Tuple2<String[], Object> tuple2 = x$4;
                    if (tuple2 != null) {
                        String[] domain = (String[])tuple2._1();
                        boolean bl = domain == null;
                        return bl;
                    }
                    throw new MatchError(tuple2);
                }
            }).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final int apply(Tuple2<String[], Object> x$5) {
                    Tuple2<String[], Object> tuple2 = x$5;
                    if (tuple2 != null) {
                        int idx;
                        int n2 = idx = tuple2._2$mcI$sp();
                        return n2;
                    }
                    throw new MatchError(tuple2);
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            ConvertCategoricalToStringColumnsTask convertCategoricalToStringColumnsTask = new ConvertCategoricalToStringColumnsTask(frame._key, domainIndices);
            byte[] outputTypes = (byte[])Predef$.MODULE$.refArrayOps((Object[])vectorsToBeConvertedToString).map((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte apply(Vec x$6) {
                    return 2;
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Byte()));
            convertCategoricalToStringColumnsTask.doAll(outputTypes, vectorsToBeConvertedToString);
            Vec[] newVectors = AppendableVec.closeAll(convertCategoricalToStringColumnsTask.appendables());
            Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])newVectors).zip((GenIterable)Predef$.MODULE$.wrapIntArray(indicesOfChanges), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)))).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Vec, Object> check$ifrefutable$3) {
                    Tuple2<Vec, Object> tuple2 = check$ifrefutable$3;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, frame){
                public static final long serialVersionUID = 0L;
                private final Frame frame$1;

                public final void apply(Tuple2<Vec, Object> x$7) {
                    Tuple2<Vec, Object> tuple2 = x$7;
                    if (tuple2 != null) {
                        Vec newVector = (Vec)tuple2._1();
                        int index = tuple2._2$mcI$sp();
                        Vec oldVector = this.frame$1.replace(index, newVector);
                        oldVector.remove();
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.frame$1 = frame$1;
                }
            });
        }
    }

    private void convertCategoricalColumnsToOtherTypesIfNeeded(Frame frame, int[] categoricalColumnIndices) {
        Predef$.MODULE$.intArrayOps(categoricalColumnIndices).foreach((Function1)new Serializable(this, frame){
            public static final long serialVersionUID = 0L;
            private final Frame frame$2;

            public final void apply(int idx) {
                this.apply$mcVI$sp(idx);
            }

            public void apply$mcVI$sp(int idx) {
                byte correctType;
                Vec vector = this.frame$2.vec(idx);
                byte by2 = correctType = CategoricalPreviewParseWriter.guessType(vector.domain(), (int)vector.length(), (int)vector.naCnt());
                switch (by2) {
                    default: {
                        Log.err(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The categorical column '", "' has been identified to be "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.frame$2.names()[idx]}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"type of '", "', but the conversion is not supported. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToByte((byte)by2)}))).toString());
                        break;
                    }
                    case 3: {
                        Log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The categorical column '", "' has been converted to numeric."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.frame$2.names()[idx]})));
                        Vec oldVector = this.frame$2.replace(idx, vector.toNumericVec());
                        oldVector.remove();
                        break;
                    }
                    case 2: {
                        Log.info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The categorical column '", "' has been converted to string."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.frame$2.names()[idx]})));
                        Vec oldVector = this.frame$2.replace(idx, vector.toStringVec());
                        oldVector.remove();
                    }
                    case 4: 
                }
            }
            {
                this.frame$2 = frame$2;
            }
        });
    }

    private int[] indicesOfChangedColumnsFromCategoricalToString(byte[] columnTypes, String[][] stringDomains) {
        int strIdx = 0;
        ArrayBuffer result = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        for (int idx = 0; idx < columnTypes.length; ++idx) {
            if (columnTypes[idx] != 4) continue;
            if (stringDomains[strIdx] == null) {
                result.append((Seq)Predef$.MODULE$.wrapIntArray(new int[]{idx}));
            }
            ++strIdx;
        }
        return (int[])result.toArray(ClassTag$.MODULE$.Int());
    }

    private String[][] expandDomains(String[][] stringDomains, byte[] columnTypes) {
        int strIdx = 0;
        String[][] result = (String[][])Array$.MODULE$.fill(columnTypes.length, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        }, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class)));
        for (int idx = 0; idx < columnTypes.length; ++idx) {
            if (columnTypes[idx] != 4) continue;
            result[idx] = stringDomains[strIdx];
            ++strIdx;
        }
        return result;
    }

    public UploadPlanV3 getUploadPlan(int version, UploadPlanV3 request2) {
        Key<Vec> key = new Vec.VectorGroup().addVec();
        UploadPlanV3.ChunkAssigmentV3[] layout = (UploadPlanV3.ChunkAssigmentV3[])((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), request2.number_of_chunks).map((Function1)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final Key key$1;

            public final UploadPlanV3.ChunkAssigmentV3 apply(int chunkId) {
                H2ONode h2oNode = Vec.chunkKey(this.key$1, chunkId).home_node();
                return new UploadPlanV3.ChunkAssigmentV3(chunkId, h2oNode);
            }
            {
                this.key$1 = key$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(UploadPlanV3.ChunkAssigmentV3.class));
        request2.layout = layout;
        return request2;
    }
}

