/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.sparkling.ml.metrics;

import ai.h2o.sparkling.ml.metrics.H2OBinomialMetrics;
import ai.h2o.sparkling.ml.metrics.H2OGLMMetrics;
import ai.h2o.sparkling.ml.metrics.MetricsDescription;
import com.google.gson.JsonObject;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.LongParam;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.ParamPair;
import org.apache.spark.ml.param.Params;
import org.apache.spark.ml.util.Identifiable$;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@MetricsDescription(description="The class makes available all binomial metrics supported by GLM algorithm.")
@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u00015\u0011Q\u0003\u0013\u001aP\u0005&tw.\\5bY\u001ecU*T3ue&\u001c7O\u0003\u0002\u0004\t\u00059Q.\u001a;sS\u000e\u001c(BA\u0003\u0007\u0003\tiGN\u0003\u0002\b\u0011\u0005I1\u000f]1sW2Lgn\u001a\u0006\u0003\u0013)\t1\u0001\u001b\u001ap\u0015\u0005Y\u0011AA1j\u0007\u0001\u00192\u0001\u0001\b\u0013!\ty\u0001#D\u0001\u0003\u0013\t\t\"A\u0001\nIe=\u0013\u0015N\\8nS\u0006dW*\u001a;sS\u000e\u001c\bCA\b\u0014\u0013\t!\"AA\u0007Ie=;E*T'fiJL7m\u001d\u0005\t-\u0001\u0011)\u0019!C!/\u0005\u0019Q/\u001b3\u0016\u0003a\u0001\"!G\u0010\u000f\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0013E\u0001\u0004TiJLgn\u001a\u0006\u0003=mA\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001G\u0001\u0005k&$\u0007\u0005C\u0003&\u0001\u0011\u0005a%\u0001\u0004=S:LGO\u0010\u000b\u0003O!\u0002\"a\u0004\u0001\t\u000bY!\u0003\u0019\u0001\r\t\u000b\u0015\u0002A\u0011\u0001\u0016\u0015\u0003\u001dBq\u0001\f\u0001C\u0002\u0013EQ&\u0001\tsKNLG-^1m\t\u00164\u0018.\u00198dKV\ta\u0006\u0005\u00020s5\t\u0001G\u0003\u00022e\u0005)\u0001/\u0019:b[*\u0011Qa\r\u0006\u0003iU\nQa\u001d9be.T!AN\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005A\u0014aA8sO&\u0011!\b\r\u0002\f\t>,(\r\\3QCJ\fW\u000e\u0003\u0004=\u0001\u0001\u0006IAL\u0001\u0012e\u0016\u001c\u0018\u000eZ;bY\u0012+g/[1oG\u0016\u0004\u0003b\u0002 \u0001\u0005\u0004%\t\"L\u0001\r]VdG\u000eR3wS\u0006t7-\u001a\u0005\u0007\u0001\u0002\u0001\u000b\u0011\u0002\u0018\u0002\u001b9,H\u000e\u001c#fm&\fgnY3!\u0011\u001d\u0011\u0005A1A\u0005\u00125\n1!Y5d\u0011\u0019!\u0005\u0001)A\u0005]\u0005!\u0011-[2!\u0011\u001d1\u0005A1A\u0005\u0012\u001d\u000bAC\\;mY\u0012+wM]3fg>3gI]3fI>lW#\u0001%\u0011\u0005=J\u0015B\u0001&1\u0005%auN\\4QCJ\fW\u000e\u0003\u0004M\u0001\u0001\u0006I\u0001S\u0001\u0016]VdG\u000eR3he\u0016,7o\u00144Ge\u0016,Gm\\7!\u0011\u001dq\u0005A1A\u0005\u0012\u001d\u000b\u0001D]3tS\u0012,\u0018\r\u001c#fOJ,Wm](g\rJ,W\rZ8n\u0011\u0019\u0001\u0006\u0001)A\u0005\u0011\u0006I\"/Z:jIV\fG\u000eR3he\u0016,7o\u00144Ge\u0016,Gm\\7!\u0011\u0015\u0011\u0006\u0001\"\u0001T\u0003M9W\r\u001e*fg&$W/\u00197EKZL\u0017M\\2f)\u0005!\u0006C\u0001\u000eV\u0013\t16D\u0001\u0004E_V\u0014G.\u001a\u0005\u00061\u0002!\taU\u0001\u0010O\u0016$h*\u001e7m\t\u00164\u0018.\u00198dK\")!\f\u0001C\u0001'\u00061q-\u001a;B\u0013\u000eCQ\u0001\u0018\u0001\u0005\u0002u\u000bqcZ3u\u001dVdG\u000eR3he\u0016,7o\u00144Ge\u0016,Gm\\7\u0015\u0003y\u0003\"AG0\n\u0005\u0001\\\"\u0001\u0002'p]\u001eDQA\u0019\u0001\u0005\u0002u\u000b1dZ3u%\u0016\u001c\u0018\u000eZ;bY\u0012+wM]3fg>3gI]3fI>l\u0007\"\u00023\u0001\t\u0003*\u0017AC:fi6+GO]5dgR\u0019a-[;\u0011\u0005i9\u0017B\u00015\u001c\u0005\u0011)f.\u001b;\t\u000b)\u001c\u0007\u0019A6\u0002\t)\u001cxN\u001c\t\u0003YNl\u0011!\u001c\u0006\u0003]>\fAaZ:p]*\u0011\u0001/]\u0001\u0007O>|w\r\\3\u000b\u0003I\f1aY8n\u0013\t!XN\u0001\u0006Kg>twJ\u00196fGRDQA^2A\u0002a\tqaY8oi\u0016DH\u000fC\u0003y\u0001\u0011\u0005\u00130\u0001\u0003d_BLHC\u0001>|\u001b\u0005\u0001\u0001\"\u0002?x\u0001\u0004i\u0018!B3yiJ\f\u0007CA\u0018\u007f\u0013\ty\bG\u0001\u0005QCJ\fW.T1qQ\u001d\u0001\u00111AA\u0005\u0003\u0017\u00012aDA\u0003\u0013\r\t9A\u0001\u0002\u0013\u001b\u0016$(/[2t\t\u0016\u001c8M]5qi&|g.A\u0006eKN\u001c'/\u001b9uS>t\u0017EAA\u0007\u0003)#\u0006.\u001a\u0011dY\u0006\u001c8\u000fI7bW\u0016\u001c\b%\u0019<bS2\f'\r\\3!C2d\u0007EY5o_6L\u0017\r\u001c\u0011nKR\u0014\u0018nY:!gV\u0004\bo\u001c:uK\u0012\u0004#-\u001f\u0011H\u00196\u0003\u0013\r\\4pe&$\b.\u001c\u0018")
public class H2OBinomialGLMMetrics
extends H2OBinomialMetrics
implements H2OGLMMetrics {
    private final String uid;
    private final DoubleParam residualDeviance;
    private final DoubleParam nullDeviance;
    private final DoubleParam aic;
    private final LongParam nullDegreesOfFreedom;
    private final LongParam residualDegreesOfFreedom;

    @Override
    public String uid() {
        return this.uid;
    }

    public DoubleParam residualDeviance() {
        return this.residualDeviance;
    }

    public DoubleParam nullDeviance() {
        return this.nullDeviance;
    }

    public DoubleParam aic() {
        return this.aic;
    }

    public LongParam nullDegreesOfFreedom() {
        return this.nullDegreesOfFreedom;
    }

    public LongParam residualDegreesOfFreedom() {
        return this.residualDegreesOfFreedom;
    }

    @Override
    public double getResidualDeviance() {
        return BoxesRunTime.unboxToDouble(this.$(this.residualDeviance()));
    }

    @Override
    public double getNullDeviance() {
        return BoxesRunTime.unboxToDouble(this.$(this.nullDeviance()));
    }

    @Override
    public double getAIC() {
        return BoxesRunTime.unboxToDouble(this.$(this.aic()));
    }

    @Override
    public long getNullDegreesOfFreedom() {
        return BoxesRunTime.unboxToLong(this.$(this.nullDegreesOfFreedom()));
    }

    @Override
    public long getResidualDegreesOfFreedom() {
        return BoxesRunTime.unboxToLong(this.$(this.residualDegreesOfFreedom()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void setMetrics(JsonObject json, String context) {
        Params params;
        Params params2;
        Params params3;
        Params params4;
        super.setMetrics(json, context);
        if (json.has("residual_deviance")) {
            try {
                params4 = this.set("residualDeviance", BoxesRunTime.boxToDouble((double)json.get("residual_deviance").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 == null) throw throwable;
                Throwable throwable3 = throwable2;
                String string = System.getProperty("spark.testing", "false");
                String string2 = "true";
                if (string == null) {
                    if (string2 == null) throw throwable;
                } else if (string.equals(string2)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'residual_deviance' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable3);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params4 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'residual_deviance' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string3 = "true";
            if (string == null) {
                if (string3 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string3)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            params4 = BoxedUnit.UNIT;
        }
        if (json.has("null_deviance")) {
            try {
                params3 = this.set("nullDeviance", BoxesRunTime.boxToDouble((double)json.get("null_deviance").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable4 = throwable;
                if (throwable4 == null) throw throwable;
                Throwable throwable5 = throwable4;
                String string = System.getProperty("spark.testing", "false");
                String string4 = "true";
                if (string == null) {
                    if (string4 == null) throw throwable;
                } else if (string.equals(string4)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'null_deviance' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable5);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params3 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'null_deviance' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string5 = "true";
            if (string == null) {
                if (string5 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string5)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$2;

                public final String apply() {
                    return this.message$2;
                }
                {
                    this.message$2 = message$2;
                }
            });
            params3 = BoxedUnit.UNIT;
        }
        if (json.has("AIC")) {
            try {
                params2 = this.set("aic", BoxesRunTime.boxToDouble((double)json.get("AIC").getAsDouble()));
            }
            catch (Throwable throwable) {
                Throwable throwable6 = throwable;
                if (throwable6 == null) throw throwable;
                Throwable throwable7 = throwable6;
                String string = System.getProperty("spark.testing", "false");
                String string6 = "true";
                if (string == null) {
                    if (string6 == null) throw throwable;
                } else if (string.equals(string6)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'AIC' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable7);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params2 = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'AIC' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string7 = "true";
            if (string == null) {
                if (string7 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string7)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$3;

                public final String apply() {
                    return this.message$3;
                }
                {
                    this.message$3 = message$3;
                }
            });
            params2 = BoxedUnit.UNIT;
        }
        if (json.has("null_degrees_of_freedom")) {
            try {
                params = this.set("nullDegreesOfFreedom", BoxesRunTime.boxToLong((long)json.get("null_degrees_of_freedom").getAsLong()));
            }
            catch (Throwable throwable) {
                Throwable throwable8 = throwable;
                if (throwable8 == null) throw throwable;
                Throwable throwable9 = throwable8;
                String string = System.getProperty("spark.testing", "false");
                String string8 = "true";
                if (string == null) {
                    if (string8 == null) throw throwable;
                } else if (string.equals(string8)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'null_degrees_of_freedom' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable9);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                params = boxedUnit;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'null_degrees_of_freedom' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string9 = "true";
            if (string == null) {
                if (string9 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string9)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$4;

                public final String apply() {
                    return this.message$4;
                }
                {
                    this.message$4 = message$4;
                }
            });
            params = BoxedUnit.UNIT;
        }
        if (json.has("residual_degrees_of_freedom")) {
            try {
                this.set("residualDegreesOfFreedom", BoxesRunTime.boxToLong((long)json.get("residual_degrees_of_freedom").getAsLong()));
                return;
            }
            catch (Throwable throwable) {
                Throwable throwable10 = throwable;
                if (throwable10 == null) throw throwable;
                Throwable throwable11 = throwable10;
                String string = System.getProperty("spark.testing", "false");
                String string10 = "true";
                if (string == null) {
                    if (string10 == null) throw throwable;
                } else if (string.equals(string10)) throw throwable;
                this.logError((Function0<String>)new Serializable(this, context){
                    public static final long serialVersionUID = 0L;
                    private final String context$1;

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unsuccessful try to extract 'residual_degrees_of_freedom' from ").append((Object)this.context$1).toString();
                    }
                    {
                        this.context$1 = context$1;
                    }
                }, throwable11);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        } else {
            String message = new StringBuilder().append((Object)"The metric 'residual_degrees_of_freedom' in ").append((Object)context).append((Object)" does not exist.").toString();
            String string = System.getProperty("spark.testing", "false");
            String string11 = "true";
            if (string == null) {
                if (string11 == null) throw new AssertionError((Object)message);
            } else if (string.equals(string11)) {
                throw new AssertionError((Object)message);
            }
            this.logWarning((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$5;

                public final String apply() {
                    return this.message$5;
                }
                {
                    this.message$5 = message$5;
                }
            });
            return;
        }
    }

    @Override
    public H2OBinomialGLMMetrics copy(ParamMap extra) {
        return (H2OBinomialGLMMetrics)this.defaultCopy(extra);
    }

    public H2OBinomialGLMMetrics(String uid) {
        this.uid = uid;
        this.residualDeviance = this.doubleParam("residualDeviance", "residual deviance.");
        this.nullDeviance = this.doubleParam("nullDeviance", "null deviance.");
        this.aic = this.doubleParam("aic", "AIC.");
        this.nullDegreesOfFreedom = this.longParam("nullDegreesOfFreedom", "null DOF.");
        this.residualDegreesOfFreedom = this.longParam("residualDegreesOfFreedom", "residual DOF.");
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.residualDeviance().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.nullDeviance().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
        this.setDefault((Seq<ParamPair<?>>)Predef$.MODULE$.wrapRefArray((Object[])new ParamPair[]{this.aic().$minus$greater((Object)BoxesRunTime.boxToDouble((double)Double.NaN))}));
    }

    public H2OBinomialGLMMetrics() {
        this(Identifiable$.MODULE$.randomUID("H2OBinomialGLMMetrics"));
    }
}

