/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.targetencoding.interaction;

import ai.h2o.targetencoding.interaction.CreateInteractionTask;
import ai.h2o.targetencoding.interaction.InteractionsEncoder;
import java.util.Arrays;
import java.util.HashSet;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.VecUtils;

public class InteractionSupport {
    private static final String COL_INTERACTION_SEPARATOR = ":";

    public static int addFeatureInteraction(Frame fr, String[] colGroup) {
        return InteractionSupport.addFeatureInteraction(fr, colGroup, null);
    }

    public static int addFeatureInteraction(Frame fr, String[] colGroup, String[] interactionDomain) {
        if (colGroup.length == 1) {
            return fr.find(colGroup[0]);
        }
        if (new HashSet<String>(Arrays.asList(fr.names())).containsAll(Arrays.asList(colGroup))) {
            return InteractionSupport.addInteractionColumn(fr, colGroup, interactionDomain);
        }
        return -1;
    }

    private static int addInteractionColumn(Frame fr, String[] interactingColumns, String[] interactionDomain) {
        String interactionColName = String.join((CharSequence)COL_INTERACTION_SEPARATOR, interactingColumns);
        int[] cols = Arrays.stream(interactingColumns).mapToInt(fr::find).toArray();
        Vec interactionCol = InteractionSupport.createInteractionColumn(fr, cols, interactionDomain);
        fr.add(interactionColName, interactionCol);
        return fr.numCols() - 1;
    }

    static Vec createInteractionColumn(Frame fr, int[] interactingColumnsIdx, String[] interactionDomain) {
        String[][] interactingDomains = new String[interactingColumnsIdx.length][];
        Vec[] interactingVecs = new Vec[interactingColumnsIdx.length];
        for (int i2 = 0; i2 < interactingColumnsIdx.length; ++i2) {
            Vec vec;
            interactingVecs[i2] = vec = fr.vec(interactingColumnsIdx[i2]);
            interactingDomains[i2] = vec.domain();
        }
        InteractionsEncoder encoder = new InteractionsEncoder(interactingDomains, true);
        byte interactionType = interactionDomain == null ? (byte)3 : 4;
        Vec interactionCol = ((CreateInteractionTask)new CreateInteractionTask(encoder, interactionDomain).doAll(new byte[]{interactionType}, interactingVecs)).outputFrame(null, null, new String[][]{interactionDomain}).lastVec();
        if (interactionType != 4) {
            interactionCol = VecUtils.toCategoricalVec(interactionCol);
        }
        return interactionCol;
    }
}

