/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.xgboost4j.java;

import ai.h2o.xgboost4j.java.Booster;
import ai.h2o.xgboost4j.java.DMatrix;
import ai.h2o.xgboost4j.java.XGBoostError;
import hex.tree.xgboost.util.BoosterHelper;
import java.util.Map;

public class BoosterWrapper {
    private final Booster booster;

    public BoosterWrapper(byte[] checkpointBoosterBytes, Map<String, Object> params, DMatrix train) throws XGBoostError {
        if (checkpointBoosterBytes != null) {
            this.booster = BoosterHelper.loadModel(checkpointBoosterBytes);
            this.booster.setParams(params);
        } else {
            this.booster = Booster.newBooster(params, new DMatrix[]{train});
            this.booster.loadRabitCheckpoint();
        }
        this.booster.saveRabitCheckpoint();
    }

    public void update(DMatrix dtrain, int iter2) throws XGBoostError {
        this.booster.update(dtrain, iter2);
    }

    public void saveRabitCheckpoint() throws XGBoostError {
        this.booster.saveRabitCheckpoint();
    }

    public byte[] toByteArray() throws XGBoostError {
        return this.booster.toByteArray();
    }

    public void dispose() {
        this.booster.dispose();
    }

    public Booster getBooster() {
        return this.booster;
    }
}

