/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.googleapis.media;

import com.google.api.client.googleapis.media.MediaHttpUploader;
import com.google.api.client.http.HttpIOExceptionHandler;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpUnsuccessfulResponseHandler;
import com.google.api.client.util.Beta;
import com.google.api.client.util.Preconditions;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

@Beta
class MediaUploadErrorHandler
implements HttpUnsuccessfulResponseHandler,
HttpIOExceptionHandler {
    static final Logger LOGGER = Logger.getLogger(MediaUploadErrorHandler.class.getName());
    private final MediaHttpUploader uploader;
    private final HttpIOExceptionHandler originalIOExceptionHandler;
    private final HttpUnsuccessfulResponseHandler originalUnsuccessfulHandler;

    public MediaUploadErrorHandler(MediaHttpUploader uploader, HttpRequest request2) {
        this.uploader = Preconditions.checkNotNull(uploader);
        this.originalIOExceptionHandler = request2.getIOExceptionHandler();
        this.originalUnsuccessfulHandler = request2.getUnsuccessfulResponseHandler();
        request2.setIOExceptionHandler(this);
        request2.setUnsuccessfulResponseHandler(this);
    }

    @Override
    public boolean handleIOException(HttpRequest request2, boolean supportsRetry) throws IOException {
        boolean handled;
        boolean bl = handled = this.originalIOExceptionHandler != null && this.originalIOExceptionHandler.handleIOException(request2, supportsRetry);
        if (handled) {
            try {
                this.uploader.serverErrorCallback();
            }
            catch (IOException e2) {
                LOGGER.log(Level.WARNING, "exception thrown while calling server callback", e2);
            }
        }
        return handled;
    }

    @Override
    public boolean handleResponse(HttpRequest request2, HttpResponse response, boolean supportsRetry) throws IOException {
        boolean handled;
        boolean bl = handled = this.originalUnsuccessfulHandler != null && this.originalUnsuccessfulHandler.handleResponse(request2, response, supportsRetry);
        if (handled && supportsRetry && response.getStatusCode() / 100 == 5) {
            try {
                this.uploader.serverErrorCallback();
            }
            catch (IOException e2) {
                LOGGER.log(Level.WARNING, "exception thrown while calling server callback", e2);
            }
        }
        return handled;
    }
}

