/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http;

import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.util.Preconditions;
import java.io.IOException;

public final class BasicAuthentication
implements HttpRequestInitializer,
HttpExecuteInterceptor {
    private final String username;
    private final String password;

    public BasicAuthentication(String username, String password) {
        this.username = Preconditions.checkNotNull(username);
        this.password = Preconditions.checkNotNull(password);
    }

    @Override
    public void initialize(HttpRequest request2) throws IOException {
        request2.setInterceptor(this);
    }

    @Override
    public void intercept(HttpRequest request2) throws IOException {
        request2.getHeaders().setBasicAuthentication(this.username, this.password);
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }
}

