/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.client.http.javanet;

import ai.h2o.com.google.common.annotations.VisibleForTesting;
import com.google.api.client.http.LowLevelHttpRequest;
import com.google.api.client.http.LowLevelHttpResponse;
import com.google.api.client.http.javanet.NetHttpResponse;
import com.google.api.client.util.Preconditions;
import com.google.api.client.util.StreamingContent;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class NetHttpRequest
extends LowLevelHttpRequest {
    private final HttpURLConnection connection;
    private int writeTimeout;
    private static final OutputWriter DEFAULT_CONNECTION_WRITER = new DefaultOutputWriter();

    NetHttpRequest(HttpURLConnection connection) {
        this.connection = connection;
        this.writeTimeout = 0;
        connection.setInstanceFollowRedirects(false);
    }

    @Override
    public void addHeader(String name, String value) {
        this.connection.addRequestProperty(name, value);
    }

    @VisibleForTesting
    String getRequestProperty(String name) {
        return this.connection.getRequestProperty(name);
    }

    @Override
    public void setTimeout(int connectTimeout, int readTimeout) {
        this.connection.setReadTimeout(readTimeout);
        this.connection.setConnectTimeout(connectTimeout);
    }

    @Override
    public void setWriteTimeout(int writeTimeout) throws IOException {
        this.writeTimeout = writeTimeout;
    }

    @Override
    public LowLevelHttpResponse execute() throws IOException {
        return this.execute(DEFAULT_CONNECTION_WRITER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @VisibleForTesting
    LowLevelHttpResponse execute(OutputWriter outputWriter) throws IOException {
        connection = this.connection;
        if (this.getStreamingContent() != null) {
            contentType = this.getContentType();
            if (contentType != null) {
                this.addHeader("Content-Type", contentType);
            }
            if ((contentEncoding = this.getContentEncoding()) != null) {
                this.addHeader("Content-Encoding", contentEncoding);
            }
            if ((contentLength = this.getContentLength()) >= 0L) {
                connection.setRequestProperty("Content-Length", Long.toString(contentLength));
            }
            if ("POST".equals(requestMethod = connection.getRequestMethod()) || "PUT".equals(requestMethod)) {
                connection.setDoOutput(true);
                if (contentLength >= 0L && contentLength <= 0x7FFFFFFFL) {
                    connection.setFixedLengthStreamingMode((int)contentLength);
                } else {
                    connection.setChunkedStreamingMode(0);
                }
                out = connection.getOutputStream();
                threw = true;
                try {
                    this.writeContentToOutputStream(outputWriter, out);
                    threw = false;
                }
                catch (IOException e) {
                    if (this.hasResponse(connection)) ** GOTO lbl39
                    throw e;
                }
                finally {
                    block25: {
                        try {
                            out.close();
                        }
                        catch (IOException exception) {
                            if (threw) break block25;
                            throw exception;
                        }
                    }
                }
            } else {
                Preconditions.checkArgument(contentLength == 0L, "%s with non-zero content length is not supported", new Object[]{requestMethod});
            }
        } else if ("DELETE".equals(connection.getRequestMethod())) {
            connection.setDoOutput(true);
            connection.setFixedLengthStreamingMode(0L);
        }
lbl39:
        // 6 sources

        successfulConnection = false;
        try {
            connection.connect();
            response = new NetHttpResponse(connection);
            successfulConnection = true;
            var5_7 = response;
            return var5_7;
        }
        finally {
            if (!successfulConnection) {
                connection.disconnect();
            }
        }
    }

    private boolean hasResponse(HttpURLConnection connection) {
        try {
            return connection.getResponseCode() > 0;
        }
        catch (IOException e2) {
            return false;
        }
    }

    private void writeContentToOutputStream(final OutputWriter outputWriter, final OutputStream out) throws IOException {
        if (this.writeTimeout == 0) {
            outputWriter.write(out, this.getStreamingContent());
        } else {
            final StreamingContent content = this.getStreamingContent();
            Callable<Boolean> writeContent = new Callable<Boolean>(){

                @Override
                public Boolean call() throws IOException {
                    outputWriter.write(out, content);
                    return Boolean.TRUE;
                }
            };
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<Object> future = executor.submit(new FutureTask<Boolean>(writeContent), null);
            executor.shutdown();
            try {
                future.get(this.writeTimeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e2) {
                throw new IOException("Socket write interrupted", e2);
            }
            catch (ExecutionException e3) {
                throw new IOException("Exception in socket write", e3);
            }
            catch (TimeoutException e4) {
                throw new IOException("Socket write timed out", e4);
            }
            if (!executor.isTerminated()) {
                executor.shutdown();
            }
        }
    }

    static class DefaultOutputWriter
    implements OutputWriter {
        DefaultOutputWriter() {
        }

        @Override
        public void write(OutputStream outputStream, StreamingContent content) throws IOException {
            content.writeTo(outputStream);
        }
    }

    static interface OutputWriter {
        public void write(OutputStream var1, StreamingContent var2) throws IOException;
    }
}

