/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import ai.h2o.com.google.common.base.Preconditions;
import com.google.api.gax.batching.Semaphore64;

class BlockingSemaphore
implements Semaphore64 {
    private long availablePermits;
    private long limit;

    private static void checkNotNegative(long l2) {
        Preconditions.checkArgument(l2 >= 0L, "negative permits not allowed: %s", l2);
    }

    BlockingSemaphore(long permits) {
        BlockingSemaphore.checkNotNegative(permits);
        this.availablePermits = permits;
        this.limit = permits;
    }

    @Override
    public synchronized void release(long permits) {
        BlockingSemaphore.checkNotNegative(permits);
        this.availablePermits = Math.min(this.availablePermits + permits, this.limit);
        this.notifyAll();
    }

    @Override
    public synchronized boolean acquire(long permits) {
        BlockingSemaphore.checkNotNegative(permits);
        boolean interrupted = false;
        while (this.availablePermits < permits) {
            try {
                this.wait();
            }
            catch (InterruptedException e2) {
                interrupted = true;
            }
        }
        this.availablePermits -= permits;
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        return true;
    }

    @Override
    public synchronized boolean acquirePartial(long permits) {
        BlockingSemaphore.checkNotNegative(permits);
        boolean interrupted = false;
        while (this.availablePermits < Math.min(this.limit, permits)) {
            try {
                this.wait();
            }
            catch (InterruptedException e2) {
                interrupted = true;
            }
        }
        if (interrupted) {
            Thread.currentThread().interrupt();
        }
        this.availablePermits -= permits;
        return true;
    }

    @Override
    public synchronized void increasePermitLimit(long permits) {
        BlockingSemaphore.checkNotNegative(permits);
        this.availablePermits += permits;
        this.limit += permits;
        this.notifyAll();
    }

    @Override
    public synchronized void reducePermitLimit(long reduction) {
        BlockingSemaphore.checkNotNegative(reduction);
        Preconditions.checkState(this.limit - reduction > 0L, "permit limit underflow");
        this.availablePermits -= reduction;
        this.limit -= reduction;
    }

    @Override
    public synchronized long getPermitLimit() {
        return this.limit;
    }
}

