/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.batching;

import ai.h2o.com.google.common.base.Preconditions;
import com.google.api.gax.batching.Semaphore64;
import java.util.concurrent.atomic.AtomicLong;

class NonBlockingSemaphore
implements Semaphore64 {
    private AtomicLong acquiredPermits;
    private AtomicLong limit;

    private static void checkNotNegative(long l2) {
        Preconditions.checkArgument(l2 >= 0L, "negative permits not allowed: %s", l2);
    }

    NonBlockingSemaphore(long permits) {
        NonBlockingSemaphore.checkNotNegative(permits);
        this.acquiredPermits = new AtomicLong(0L);
        this.limit = new AtomicLong(permits);
    }

    @Override
    public void release(long permits) {
        long newAcquired;
        long old;
        NonBlockingSemaphore.checkNotNegative(permits);
        while (!this.acquiredPermits.compareAndSet(old = this.acquiredPermits.get(), newAcquired = Math.max(0L, old - permits))) {
        }
    }

    @Override
    public boolean acquire(long permits) {
        long old;
        NonBlockingSemaphore.checkNotNegative(permits);
        do {
            if ((old = this.acquiredPermits.get()) + permits <= this.limit.get()) continue;
            return false;
        } while (!this.acquiredPermits.compareAndSet(old, old + permits));
        return true;
    }

    @Override
    public boolean acquirePartial(long permits) {
        long old;
        NonBlockingSemaphore.checkNotNegative(permits);
        do {
            if ((old = this.acquiredPermits.get()) + permits <= this.limit.get() || old <= 0L) continue;
            return false;
        } while (!this.acquiredPermits.compareAndSet(old, old + permits));
        return true;
    }

    @Override
    public void increasePermitLimit(long permits) {
        NonBlockingSemaphore.checkNotNegative(permits);
        this.limit.addAndGet(permits);
    }

    @Override
    public void reducePermitLimit(long reduction) {
        long oldLimit;
        NonBlockingSemaphore.checkNotNegative(reduction);
        do {
            Preconditions.checkState((oldLimit = this.limit.get()) - reduction > 0L, "permit limit underflow");
        } while (!this.limit.compareAndSet(oldLimit, oldLimit - reduction));
    }

    @Override
    public long getPermitLimit() {
        return this.limit.get();
    }
}

