/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.httpjson;

import ai.h2o.com.google.common.base.Preconditions;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonClientCall;
import com.google.api.gax.httpjson.HttpJsonClientCalls;
import com.google.api.gax.httpjson.HttpJsonDirectStreamController;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;

class HttpJsonDirectServerStreamingCallable<RequestT, ResponseT>
extends ServerStreamingCallable<RequestT, ResponseT> {
    private final ApiMethodDescriptor<RequestT, ResponseT> descriptor;

    HttpJsonDirectServerStreamingCallable(ApiMethodDescriptor<RequestT, ResponseT> descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void call(RequestT request2, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
        Preconditions.checkNotNull(request2);
        Preconditions.checkNotNull(responseObserver);
        HttpJsonClientCall<RequestT, ResponseT> call = HttpJsonClientCalls.newCall(this.descriptor, context);
        HttpJsonDirectStreamController<RequestT, ResponseT> controller = new HttpJsonDirectStreamController<RequestT, ResponseT>(call, responseObserver);
        controller.start(request2);
    }
}

