/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import ai.h2o.com.google.common.base.MoreObjects;
import ai.h2o.com.google.common.base.Preconditions;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.api.gax.rpc.Watchdog;
import org.threeten.bp.Duration;

class WatchdogServerStreamingCallable<RequestT, ResponseT>
extends ServerStreamingCallable<RequestT, ResponseT> {
    private final ServerStreamingCallable<RequestT, ResponseT> inner;
    private final Watchdog watchdog;

    WatchdogServerStreamingCallable(ServerStreamingCallable<RequestT, ResponseT> inner, Watchdog watchdog) {
        Preconditions.checkNotNull(inner);
        Preconditions.checkNotNull(watchdog);
        this.inner = inner;
        this.watchdog = watchdog;
    }

    @Override
    public void call(RequestT request2, ResponseObserver<ResponseT> responseObserver, ApiCallContext context) {
        Duration waitTimeout = MoreObjects.firstNonNull(context.getStreamWaitTimeout(), Duration.ZERO);
        Duration idleTimeout = MoreObjects.firstNonNull(context.getStreamIdleTimeout(), Duration.ZERO);
        responseObserver = this.watchdog.watch(responseObserver, waitTimeout, idleTimeout);
        this.inner.call(request2, responseObserver, context);
    }
}

