/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import ai.h2o.com.google.common.base.Preconditions;
import ai.h2o.com.google.common.base.Strings;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.BaseApiTracer;
import io.opencensus.common.Scope;
import io.opencensus.trace.AttributeValue;
import io.opencensus.trace.EndSpanOptions;
import io.opencensus.trace.Span;
import io.opencensus.trace.Status;
import io.opencensus.trace.Tracer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import org.threeten.bp.Duration;

@BetaApi(value="Surface for tracing is not yet stable")
public class OpencensusTracer
extends BaseApiTracer {
    private final Tracer tracer;
    private final Span span;
    private final ApiTracerFactory.OperationType operationType;
    private volatile String lastConnectionId;
    private volatile long currentAttemptId;
    private AtomicLong attemptSentMessages = new AtomicLong(0L);
    private long attemptReceivedMessages = 0L;
    private AtomicLong totalSentMessages = new AtomicLong(0L);
    private long totalReceivedMessages = 0L;

    OpencensusTracer(@Nonnull Tracer tracer, @Nonnull Span span, @Nonnull ApiTracerFactory.OperationType operationType) {
        this.tracer = Preconditions.checkNotNull(tracer, "tracer can't be null");
        this.span = Preconditions.checkNotNull(span, "span can't be null");
        this.operationType = Preconditions.checkNotNull(operationType, "operationType can't be null");
    }

    Span getSpan() {
        return this.span;
    }

    @Override
    public ApiTracer.Scope inScope() {
        final Scope scope = this.tracer.withSpan(this.span);
        return new ApiTracer.Scope(){

            @Override
            public void close() {
                scope.close();
            }
        };
    }

    @Override
    public void operationSucceeded() {
        Map<String, AttributeValue> attributes = this.baseOperationAttributes();
        this.span.putAttributes(attributes);
        this.span.end();
    }

    @Override
    public void operationCancelled() {
        Map<String, AttributeValue> attributes = this.baseOperationAttributes();
        this.span.putAttributes(attributes);
        this.span.end(EndSpanOptions.builder().setStatus(Status.CANCELLED.withDescription("Cancelled by caller")).build());
    }

    @Override
    public void operationFailed(Throwable error) {
        Map<String, AttributeValue> attributes = this.baseOperationAttributes();
        this.span.putAttributes(attributes);
        this.span.end(EndSpanOptions.builder().setStatus(OpencensusTracer.convertErrorToStatus(error)).build());
    }

    @Override
    public void lroStartFailed(Throwable error) {
        HashMap<String, AttributeValue> attributes = new HashMap<String, AttributeValue>();
        this.populateError(attributes, error);
        this.span.addAnnotation("Operation failed to start", attributes);
    }

    @Override
    public void lroStartSucceeded() {
        this.span.addAnnotation("Operation started");
    }

    @Override
    public void connectionSelected(String id) {
        this.lastConnectionId = id;
    }

    @Override
    public void attemptStarted(int attemptNumber) {
        this.currentAttemptId = attemptNumber;
        this.attemptSentMessages.set(0L);
        this.attemptReceivedMessages = 0L;
    }

    @Override
    public void attemptStarted(Object request2, int attemptNumber) {
        this.attemptStarted(attemptNumber);
    }

    @Override
    public void attemptSucceeded() {
        Map<String, AttributeValue> attributes = this.baseAttemptAttributes();
        if (this.operationType == ApiTracerFactory.OperationType.LongRunning) {
            this.span.addAnnotation("Polling completed", attributes);
        } else {
            this.span.addAnnotation("Attempt succeeded", attributes);
        }
    }

    @Override
    public void attemptCancelled() {
        Map<String, AttributeValue> attributes = this.baseAttemptAttributes();
        if (this.operationType == ApiTracerFactory.OperationType.LongRunning) {
            this.span.addAnnotation("Polling was cancelled", attributes);
        } else {
            this.span.addAnnotation("Attempt cancelled", attributes);
        }
        this.lastConnectionId = null;
    }

    @Override
    public void attemptFailed(Throwable error, Duration delay) {
        Map<String, AttributeValue> attributes = this.baseAttemptAttributes();
        attributes.put("delay ms", AttributeValue.longAttributeValue(delay.toMillis()));
        this.populateError(attributes, error);
        if (this.operationType == ApiTracerFactory.OperationType.LongRunning) {
            this.span.addAnnotation("Scheduling next poll", attributes);
        } else {
            this.span.addAnnotation("Attempt failed, scheduling next attempt", attributes);
        }
        this.lastConnectionId = null;
    }

    @Override
    public void attemptFailedRetriesExhausted(Throwable error) {
        Map<String, AttributeValue> attributes = this.baseAttemptAttributes();
        this.populateError(attributes, error);
        if (this.operationType == ApiTracerFactory.OperationType.LongRunning) {
            this.span.addAnnotation("Polling attempts exhausted", attributes);
        } else {
            this.span.addAnnotation("Attempts exhausted", attributes);
        }
        this.lastConnectionId = null;
    }

    @Override
    public void attemptPermanentFailure(Throwable error) {
        Map<String, AttributeValue> attributes = this.baseAttemptAttributes();
        this.populateError(attributes, error);
        if (this.operationType == ApiTracerFactory.OperationType.LongRunning) {
            this.span.addAnnotation("Polling failed", attributes);
        } else {
            this.span.addAnnotation("Attempt failed, error not retryable", attributes);
        }
        this.lastConnectionId = null;
    }

    @Override
    public void responseReceived() {
        ++this.attemptReceivedMessages;
        ++this.totalReceivedMessages;
    }

    @Override
    public void requestSent() {
        this.attemptSentMessages.incrementAndGet();
        this.totalSentMessages.incrementAndGet();
    }

    @Override
    public void batchRequestSent(long elementCount, long requestSize) {
        this.span.putAttribute("batch count", AttributeValue.longAttributeValue(elementCount));
        this.span.putAttribute("batch size", AttributeValue.longAttributeValue(requestSize));
    }

    private Map<String, AttributeValue> baseOperationAttributes() {
        HashMap<String, AttributeValue> attributes = new HashMap<String, AttributeValue>();
        attributes.put("attempt count", AttributeValue.longAttributeValue(this.currentAttemptId + 1L));
        long localTotalSentMessages = this.totalSentMessages.get();
        if (localTotalSentMessages > 0L) {
            attributes.put("total request count", AttributeValue.longAttributeValue(localTotalSentMessages));
        }
        if (this.totalReceivedMessages > 0L) {
            attributes.put("total response count", AttributeValue.longAttributeValue(this.totalReceivedMessages));
        }
        return attributes;
    }

    private Map<String, AttributeValue> baseAttemptAttributes() {
        String localLastConnectionId;
        HashMap<String, AttributeValue> attributes = new HashMap<String, AttributeValue>();
        this.populateAttemptNumber(attributes);
        long localAttemptSentMessages = this.attemptSentMessages.get();
        if (localAttemptSentMessages > 0L) {
            attributes.put("attempt request count", AttributeValue.longAttributeValue(localAttemptSentMessages));
        }
        if (this.attemptReceivedMessages > 0L) {
            attributes.put("attempt response count", AttributeValue.longAttributeValue(this.attemptReceivedMessages));
        }
        if ((localLastConnectionId = this.lastConnectionId) != null) {
            attributes.put("connection", AttributeValue.stringAttributeValue(localLastConnectionId));
        }
        return attributes;
    }

    private void populateAttemptNumber(Map<String, AttributeValue> attributes) {
        attributes.put("attempt", AttributeValue.longAttributeValue(this.currentAttemptId));
    }

    private void populateError(Map<String, AttributeValue> attributes, Throwable error) {
        if (error == null) {
            attributes.put("status", AttributeValue.stringAttributeValue("OK"));
            return;
        }
        Status status = OpencensusTracer.convertErrorToStatus(error);
        attributes.put("status", AttributeValue.stringAttributeValue(status.getCanonicalCode().toString()));
        if (!Strings.isNullOrEmpty(status.getDescription())) {
            attributes.put("status message", AttributeValue.stringAttributeValue(status.getDescription()));
        }
    }

    @InternalApi(value="Visible for testing")
    static Status convertErrorToStatus(Throwable error) {
        Status.CanonicalCode code;
        StatusCode.Code gaxCode = StatusCode.Code.UNKNOWN;
        if (error instanceof ApiException) {
            gaxCode = ((ApiException)error).getStatusCode().getCode();
        } else if (error.getCause() instanceof ApiException) {
            gaxCode = ((ApiException)error.getCause()).getStatusCode().getCode();
        }
        try {
            code = Status.CanonicalCode.valueOf(gaxCode.name());
        }
        catch (IllegalArgumentException e2) {
            code = Status.CanonicalCode.UNKNOWN;
        }
        return code.toStatus().withDescription(error.getMessage());
    }
}

