/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import ai.h2o.com.google.common.util.concurrent.MoreExecutors;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.api.gax.longrunning.OperationSnapshot;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TracedUnaryCallable;

public class TracedOperationInitialCallable<RequestT>
extends TracedUnaryCallable<RequestT, OperationSnapshot> {
    public TracedOperationInitialCallable(UnaryCallable<RequestT, OperationSnapshot> innerCallable, ApiTracerFactory tracedFactory, SpanName spanName) {
        super(innerCallable, tracedFactory, spanName);
    }

    @Override
    public ApiFuture<OperationSnapshot> futureCall(RequestT request2, ApiCallContext context) {
        InitialCallableFinisher finisher = new InitialCallableFinisher(context.getTracer());
        try {
            ApiFuture<OperationSnapshot> future = super.futureCall(request2, context);
            ApiFutures.addCallback(future, finisher, MoreExecutors.directExecutor());
            return future;
        }
        catch (RuntimeException e2) {
            finisher.onFailure(e2);
            throw e2;
        }
    }

    private static class InitialCallableFinisher
    implements ApiFutureCallback<OperationSnapshot> {
        private final ApiTracer operationTracer;

        private InitialCallableFinisher(ApiTracer operationTracer) {
            this.operationTracer = operationTracer;
        }

        @Override
        public void onSuccess(OperationSnapshot result) {
            this.operationTracer.lroStartSucceeded();
        }

        @Override
        public void onFailure(Throwable t2) {
            this.operationTracer.lroStartFailed(t2);
        }
    }
}

