/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.tracing;

import ai.h2o.com.google.common.util.concurrent.MoreExecutors;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.gax.tracing.ApiTracer;
import com.google.api.gax.tracing.ApiTracerFactory;
import com.google.api.gax.tracing.SpanName;
import com.google.api.gax.tracing.TraceFinisher;

@BetaApi(value="The surface for tracing is not stable and might change in the future")
@InternalApi(value="For internal use by google-cloud-java clients only")
public class TracedUnaryCallable<RequestT, ResponseT>
extends UnaryCallable<RequestT, ResponseT> {
    private final UnaryCallable<RequestT, ResponseT> innerCallable;
    private final ApiTracerFactory tracerFactory;
    private final SpanName spanName;

    public TracedUnaryCallable(UnaryCallable<RequestT, ResponseT> innerCallable, ApiTracerFactory tracerFactory, SpanName spanName) {
        this.innerCallable = innerCallable;
        this.tracerFactory = tracerFactory;
        this.spanName = spanName;
    }

    @Override
    public ApiFuture<ResponseT> futureCall(RequestT request2, ApiCallContext context) {
        ApiTracer tracer = this.tracerFactory.newTracer(context.getTracer(), this.spanName, ApiTracerFactory.OperationType.Unary);
        TraceFinisher finisher = new TraceFinisher(tracer);
        try {
            context = context.withTracer(tracer);
            ApiFuture<ResponseT> future = this.innerCallable.futureCall(request2, context);
            ApiFutures.addCallback(future, finisher, MoreExecutors.directExecutor());
            return future;
        }
        catch (RuntimeException e2) {
            finisher.onFailure(e2);
            throw e2;
        }
    }
}

