/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import ai.h2o.com.google.common.base.Joiner;
import com.google.api.client.http.GenericUrl;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestFactory;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpResponseException;
import com.google.api.client.http.UrlEncodedContent;
import com.google.api.client.json.GenericJson;
import com.google.api.client.json.JsonObjectParser;
import com.google.api.client.json.JsonParser;
import com.google.api.client.util.GenericData;
import com.google.auth.oauth2.OAuth2Utils;
import com.google.auth.oauth2.OAuthException;
import com.google.auth.oauth2.StsTokenExchangeRequest;
import com.google.auth.oauth2.StsTokenExchangeResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.annotation.Nullable;

final class StsRequestHandler {
    private static final String TOKEN_EXCHANGE_GRANT_TYPE = "urn:ietf:params:oauth:grant-type:token-exchange";
    private static final String PARSE_ERROR_PREFIX = "Error parsing token response.";
    private final String tokenExchangeEndpoint;
    private final StsTokenExchangeRequest request;
    private final HttpRequestFactory httpRequestFactory;
    @Nullable
    private final HttpHeaders headers;
    @Nullable
    private final String internalOptions;

    private StsRequestHandler(String tokenExchangeEndpoint, StsTokenExchangeRequest request2, HttpRequestFactory httpRequestFactory, @Nullable HttpHeaders headers, @Nullable String internalOptions) {
        this.tokenExchangeEndpoint = tokenExchangeEndpoint;
        this.request = request2;
        this.httpRequestFactory = httpRequestFactory;
        this.headers = headers;
        this.internalOptions = internalOptions;
    }

    public static Builder newBuilder(String tokenExchangeEndpoint, StsTokenExchangeRequest stsTokenExchangeRequest, HttpRequestFactory httpRequestFactory) {
        return new Builder(tokenExchangeEndpoint, stsTokenExchangeRequest, httpRequestFactory);
    }

    public StsTokenExchangeResponse exchangeToken() throws IOException {
        UrlEncodedContent content = new UrlEncodedContent(this.buildTokenRequest());
        HttpRequest httpRequest = this.httpRequestFactory.buildPostRequest(new GenericUrl(this.tokenExchangeEndpoint), content);
        httpRequest.setParser(new JsonObjectParser(OAuth2Utils.JSON_FACTORY));
        if (this.headers != null) {
            httpRequest.setHeaders(this.headers);
        }
        try {
            HttpResponse response = httpRequest.execute();
            GenericData responseData = response.parseAs(GenericData.class);
            return this.buildResponse(responseData);
        }
        catch (HttpResponseException e2) {
            GenericJson errorResponse = this.parseJson(e2.getContent());
            String errorCode = (String)errorResponse.get("error");
            String errorDescription = null;
            String errorUri = null;
            if (errorResponse.containsKey("error_description")) {
                errorDescription = (String)errorResponse.get("error_description");
            }
            if (errorResponse.containsKey("error_uri")) {
                errorUri = (String)errorResponse.get("error_uri");
            }
            throw new OAuthException(errorCode, errorDescription, errorUri);
        }
    }

    private GenericData buildTokenRequest() {
        GenericData tokenRequest = new GenericData().set("grant_type", TOKEN_EXCHANGE_GRANT_TYPE).set("subject_token_type", this.request.getSubjectTokenType()).set("subject_token", this.request.getSubjectToken());
        ArrayList<String> scopes = new ArrayList<String>();
        if (this.request.hasScopes()) {
            scopes.addAll(this.request.getScopes());
            tokenRequest.set("scope", Joiner.on(' ').join(scopes));
        }
        String requestTokenType = this.request.hasRequestedTokenType() ? this.request.getRequestedTokenType() : "urn:ietf:params:oauth:token-type:access_token";
        tokenRequest.set("requested_token_type", requestTokenType);
        if (this.request.hasResource()) {
            tokenRequest.set("resource", this.request.getResource());
        }
        if (this.request.hasAudience()) {
            tokenRequest.set("audience", this.request.getAudience());
        }
        if (this.request.hasActingParty()) {
            tokenRequest.set("actor_token", this.request.getActingParty().getActorToken());
            tokenRequest.set("actor_token_type", this.request.getActingParty().getActorTokenType());
        }
        if (this.internalOptions != null && !this.internalOptions.isEmpty()) {
            tokenRequest.set("options", this.internalOptions);
        }
        return tokenRequest;
    }

    private StsTokenExchangeResponse buildResponse(GenericData responseData) throws IOException {
        String accessToken = OAuth2Utils.validateString(responseData, "access_token", PARSE_ERROR_PREFIX);
        String issuedTokenType = OAuth2Utils.validateString(responseData, "issued_token_type", PARSE_ERROR_PREFIX);
        String tokenType = OAuth2Utils.validateString(responseData, "token_type", PARSE_ERROR_PREFIX);
        StsTokenExchangeResponse.Builder builder = StsTokenExchangeResponse.newBuilder(accessToken, issuedTokenType, tokenType);
        if (responseData.containsKey("expires_in")) {
            builder.setExpiresInSeconds(OAuth2Utils.validateLong(responseData, "expires_in", PARSE_ERROR_PREFIX));
        }
        if (responseData.containsKey("refresh_token")) {
            builder.setRefreshToken(OAuth2Utils.validateString(responseData, "refresh_token", PARSE_ERROR_PREFIX));
        }
        if (responseData.containsKey("scope")) {
            String scope = OAuth2Utils.validateString(responseData, "scope", PARSE_ERROR_PREFIX);
            builder.setScopes(Arrays.asList(scope.trim().split("\\s+")));
        }
        return builder.build();
    }

    private GenericJson parseJson(String json) throws IOException {
        JsonParser parser = OAuth2Utils.JSON_FACTORY.createJsonParser(json);
        return parser.parseAndClose(GenericJson.class);
    }

    public static class Builder {
        private final String tokenExchangeEndpoint;
        private final StsTokenExchangeRequest request;
        private final HttpRequestFactory httpRequestFactory;
        @Nullable
        private HttpHeaders headers;
        @Nullable
        private String internalOptions;

        private Builder(String tokenExchangeEndpoint, StsTokenExchangeRequest stsTokenExchangeRequest, HttpRequestFactory httpRequestFactory) {
            this.tokenExchangeEndpoint = tokenExchangeEndpoint;
            this.request = stsTokenExchangeRequest;
            this.httpRequestFactory = httpRequestFactory;
        }

        public Builder setHeaders(HttpHeaders headers) {
            this.headers = headers;
            return this;
        }

        public Builder setInternalOptions(String internalOptions) {
            this.internalOptions = internalOptions;
            return this;
        }

        public StsRequestHandler build() {
            return new StsRequestHandler(this.tokenExchangeEndpoint, this.request, this.httpRequestFactory, this.headers, this.internalOptions);
        }
    }
}

