/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud;

import ai.h2o.com.google.common.base.Preconditions;
import com.google.api.core.BetaApi;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Objects;

@BetaApi(value="This is going to be replaced with LocalDate from threetenbp")
public final class Date
implements Comparable<Date>,
Serializable {
    private static final long serialVersionUID = 8067099123096783929L;
    private final int year;
    private final int month;
    private final int dayOfMonth;

    private Date(int year, int month, int dayOfMonth) {
        Preconditions.checkArgument(year > 0, "Invalid year: " + year);
        Preconditions.checkArgument(month > 0 && month <= 12, "Invalid month: " + month);
        Preconditions.checkArgument(dayOfMonth > 0 && dayOfMonth <= 31, "Invalid day: " + dayOfMonth);
        this.year = year;
        this.month = month;
        this.dayOfMonth = dayOfMonth;
    }

    public static Date fromYearMonthDay(int year, int month, int dayOfMonth) {
        return new Date(year, month, dayOfMonth);
    }

    public static Date parseDate(String date) {
        Preconditions.checkNotNull(date);
        String invalidDate = "Invalid date: " + date;
        Preconditions.checkArgument(date.length() == 10, invalidDate);
        Preconditions.checkArgument(date.charAt(4) == '-', invalidDate);
        Preconditions.checkArgument(date.charAt(7) == '-', invalidDate);
        try {
            int year = Integer.parseInt(date.substring(0, 4));
            int month = Integer.parseInt(date.substring(5, 7));
            int dayOfMonth = Integer.parseInt(date.substring(8, 10));
            return new Date(year, month, dayOfMonth);
        }
        catch (NumberFormatException e2) {
            throw new IllegalArgumentException(invalidDate, e2);
        }
    }

    public static java.util.Date toJavaUtilDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.set(date.year, date.month - 1, date.dayOfMonth);
        return cal.getTime();
    }

    public static Date fromJavaUtilDate(java.util.Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new Date(cal.get(1), cal.get(2) + 1, cal.get(5));
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDayOfMonth() {
        return this.dayOfMonth;
    }

    public String toString() {
        return String.format("%04d-%02d-%02d", this.year, this.month, this.dayOfMonth);
    }

    StringBuilder toString(StringBuilder b2) {
        return b2.append(this.toString());
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        Date that = (Date)o2;
        return this.year == that.year && this.month == that.month && this.dayOfMonth == that.dayOfMonth;
    }

    public int hashCode() {
        return Objects.hash(this.year, this.month, this.dayOfMonth);
    }

    @Override
    public int compareTo(Date other) {
        int r2 = Integer.compare(this.year, other.year);
        if (r2 == 0 && (r2 = Integer.compare(this.month, other.month)) == 0) {
            r2 = Integer.compare(this.dayOfMonth, other.dayOfMonth);
        }
        return r2;
    }
}

