/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.http;

import ai.h2o.com.google.common.annotations.VisibleForTesting;
import ai.h2o.com.google.common.base.Preconditions;
import com.google.api.client.http.HttpExecuteInterceptor;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import io.opencensus.contrib.http.util.HttpPropagationUtil;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.propagation.TextFormat;
import java.io.IOException;
import javax.annotation.Nullable;

public final class CensusHttpModule {
    private final Tracer tracer;
    @Nullable
    private final TextFormat propagationTextFormat;
    @Nullable
    private final TextFormat.Setter<HttpHeaders> propagationTextFormatSetter;
    private final boolean isRecordEvents;

    public CensusHttpModule(Tracer tracer, boolean isRecordEvents) {
        Preconditions.checkNotNull(tracer, "tracer");
        this.tracer = tracer;
        this.isRecordEvents = isRecordEvents;
        this.propagationTextFormat = HttpPropagationUtil.getCloudTraceFormat();
        this.propagationTextFormatSetter = DefaultPropagationTextFormatSetter.INSTANCE;
    }

    public Tracer getTracer() {
        return this.tracer;
    }

    public boolean isRecordEvents() {
        return this.isRecordEvents;
    }

    public HttpRequestInitializer getHttpRequestInitializer(HttpRequestInitializer initializer) {
        return new CensusHttpRequestInitializer(initializer);
    }

    @VisibleForTesting
    final class CensusHttpRequestInitializer
    implements HttpRequestInitializer {
        @Nullable
        HttpRequestInitializer initializer;

        CensusHttpRequestInitializer(HttpRequestInitializer initializer) {
            this.initializer = initializer;
        }

        @Override
        public void initialize(HttpRequest request2) throws IOException {
            Preconditions.checkNotNull(request2);
            if (this.initializer != null) {
                this.initializer.initialize(request2);
            }
            request2.setInterceptor(new CensusHttpExecuteInterceptor(request2.getInterceptor()));
        }
    }

    @VisibleForTesting
    final class CensusHttpExecuteInterceptor
    implements HttpExecuteInterceptor {
        @Nullable
        HttpExecuteInterceptor interceptor;

        CensusHttpExecuteInterceptor(HttpExecuteInterceptor interceptor) {
            this.interceptor = interceptor;
        }

        @Override
        public void intercept(HttpRequest request2) throws IOException {
            SpanContext spanContext;
            Preconditions.checkNotNull(request2);
            if (this.interceptor != null) {
                this.interceptor.intercept(request2);
            }
            if (CensusHttpModule.this.propagationTextFormat != null && CensusHttpModule.this.propagationTextFormatSetter != null && !SpanContext.INVALID.equals(spanContext = CensusHttpModule.this.tracer.getCurrentSpan().getContext())) {
                CensusHttpModule.this.propagationTextFormat.inject(spanContext, request2.getHeaders(), CensusHttpModule.this.propagationTextFormatSetter);
            }
        }
    }

    @VisibleForTesting
    static final class DefaultPropagationTextFormatSetter
    extends TextFormat.Setter<HttpHeaders> {
        static final TextFormat.Setter<HttpHeaders> INSTANCE = new DefaultPropagationTextFormatSetter();

        DefaultPropagationTextFormatSetter() {
        }

        @Override
        public void put(HttpHeaders carrier, String key, String value) {
            carrier.set(key, value);
        }
    }
}

