/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import ai.h2o.com.google.common.base.Function;
import ai.h2o.com.google.common.base.MoreObjects;
import ai.h2o.com.google.common.base.Preconditions;
import ai.h2o.com.google.common.collect.ImmutableList;
import ai.h2o.com.google.common.collect.ImmutableSet;
import ai.h2o.com.google.common.collect.Lists;
import ai.h2o.com.google.common.collect.Maps;
import ai.h2o.com.google.common.io.BaseEncoding;
import com.google.api.client.util.Data;
import com.google.api.client.util.DateTime;
import com.google.api.core.BetaApi;
import com.google.api.services.storage.model.ObjectAccessControl;
import com.google.api.services.storage.model.StorageObject;
import com.google.cloud.storage.Acl;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.StorageClass;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BlobInfo
implements Serializable {
    static final Function<BlobInfo, StorageObject> INFO_TO_PB_FUNCTION = new Function<BlobInfo, StorageObject>(){

        @Override
        public StorageObject apply(BlobInfo blobInfo) {
            return blobInfo.toPb();
        }
    };
    private static final long serialVersionUID = -5625857076205028976L;
    private final BlobId blobId;
    private final String generatedId;
    private final String selfLink;
    private final String cacheControl;
    private final List<Acl> acl;
    private final Acl.Entity owner;
    private final Long size;
    private final String etag;
    private final String md5;
    private final String crc32c;
    private final Long customTime;
    private final String mediaLink;
    private final Map<String, String> metadata;
    private final Long metageneration;
    private final Long deleteTime;
    private final Long updateTime;
    private final Long createTime;
    private final String contentType;
    private final String contentEncoding;
    private final String contentDisposition;
    private final String contentLanguage;
    private final StorageClass storageClass;
    private final Long timeStorageClassUpdated;
    private final Integer componentCount;
    private final boolean isDirectory;
    private final CustomerEncryption customerEncryption;
    private final String kmsKeyName;
    private final Boolean eventBasedHold;
    private final Boolean temporaryHold;
    private final Long retentionExpirationTime;

    BlobInfo(BuilderImpl builder) {
        this.blobId = builder.blobId;
        this.generatedId = builder.generatedId;
        this.cacheControl = builder.cacheControl;
        this.contentEncoding = builder.contentEncoding;
        this.contentType = builder.contentType;
        this.contentDisposition = builder.contentDisposition;
        this.contentLanguage = builder.contentLanguage;
        this.componentCount = builder.componentCount;
        this.customerEncryption = builder.customerEncryption;
        this.acl = builder.acl;
        this.owner = builder.owner;
        this.size = builder.size;
        this.etag = builder.etag;
        this.selfLink = builder.selfLink;
        this.md5 = builder.md5;
        this.crc32c = builder.crc32c;
        this.customTime = builder.customTime;
        this.mediaLink = builder.mediaLink;
        this.metadata = builder.metadata;
        this.metageneration = builder.metageneration;
        this.deleteTime = builder.deleteTime;
        this.updateTime = builder.updateTime;
        this.createTime = builder.createTime;
        this.isDirectory = MoreObjects.firstNonNull(builder.isDirectory, Boolean.FALSE);
        this.storageClass = builder.storageClass;
        this.timeStorageClassUpdated = builder.timeStorageClassUpdated;
        this.kmsKeyName = builder.kmsKeyName;
        this.eventBasedHold = builder.eventBasedHold;
        this.temporaryHold = builder.temporaryHold;
        this.retentionExpirationTime = builder.retentionExpirationTime;
    }

    public BlobId getBlobId() {
        return this.blobId;
    }

    public String getBucket() {
        return this.getBlobId().getBucket();
    }

    public String getGeneratedId() {
        return this.generatedId;
    }

    public String getName() {
        return this.getBlobId().getName();
    }

    public String getCacheControl() {
        return Data.isNull(this.cacheControl) ? null : this.cacheControl;
    }

    public List<Acl> getAcl() {
        return this.acl;
    }

    public Acl.Entity getOwner() {
        return this.owner;
    }

    public Long getSize() {
        return this.size;
    }

    public String getContentType() {
        return Data.isNull(this.contentType) ? null : this.contentType;
    }

    public String getContentEncoding() {
        return Data.isNull(this.contentEncoding) ? null : this.contentEncoding;
    }

    public String getContentDisposition() {
        return Data.isNull(this.contentDisposition) ? null : this.contentDisposition;
    }

    public String getContentLanguage() {
        return Data.isNull(this.contentLanguage) ? null : this.contentLanguage;
    }

    public Integer getComponentCount() {
        return this.componentCount;
    }

    public String getEtag() {
        return this.etag;
    }

    public String getSelfLink() {
        return this.selfLink;
    }

    public String getMd5() {
        return Data.isNull(this.md5) ? null : this.md5;
    }

    public String getMd5ToHexString() {
        if (this.md5 == null) {
            return null;
        }
        byte[] decodedMd5 = BaseEncoding.base64().decode(this.md5);
        StringBuilder stringBuilder = new StringBuilder();
        for (byte b2 : decodedMd5) {
            stringBuilder.append(String.format("%02x", b2 & 0xFF));
        }
        return stringBuilder.toString();
    }

    public String getCrc32c() {
        return Data.isNull(this.crc32c) ? null : this.crc32c;
    }

    public String getCrc32cToHexString() {
        if (this.crc32c == null) {
            return null;
        }
        byte[] decodeCrc32c = BaseEncoding.base64().decode(this.crc32c);
        StringBuilder stringBuilder = new StringBuilder();
        for (byte b2 : decodeCrc32c) {
            stringBuilder.append(String.format("%02x", b2 & 0xFF));
        }
        return stringBuilder.toString();
    }

    public String getMediaLink() {
        return this.mediaLink;
    }

    public Map<String, String> getMetadata() {
        return this.metadata == null || Data.isNull(this.metadata) ? null : Collections.unmodifiableMap(this.metadata);
    }

    public Long getGeneration() {
        return this.getBlobId().getGeneration();
    }

    public Long getMetageneration() {
        return this.metageneration;
    }

    public Long getDeleteTime() {
        return this.deleteTime;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Long getCustomTime() {
        return this.customTime;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public CustomerEncryption getCustomerEncryption() {
        return this.customerEncryption;
    }

    public StorageClass getStorageClass() {
        return this.storageClass;
    }

    public Long getTimeStorageClassUpdated() {
        return this.timeStorageClassUpdated;
    }

    public String getKmsKeyName() {
        return this.kmsKeyName;
    }

    @BetaApi
    public Boolean getEventBasedHold() {
        return Data.isNull(this.eventBasedHold) ? null : this.eventBasedHold;
    }

    @BetaApi
    public Boolean getTemporaryHold() {
        return Data.isNull(this.temporaryHold) ? null : this.temporaryHold;
    }

    @BetaApi
    public Long getRetentionExpirationTime() {
        return Data.isNull(this.retentionExpirationTime) ? null : this.retentionExpirationTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("bucket", this.getBucket()).add("name", this.getName()).add("generation", this.getGeneration()).add("size", this.getSize()).add("content-type", this.getContentType()).add("metadata", this.getMetadata()).toString();
    }

    public int hashCode() {
        return Objects.hash(this.blobId);
    }

    public boolean equals(Object obj) {
        return obj == this || obj != null && obj.getClass().equals(BlobInfo.class) && Objects.equals(this.toPb(), ((BlobInfo)obj).toPb());
    }

    StorageObject toPb() {
        StorageObject storageObject = this.blobId.toPb();
        if (this.acl != null) {
            storageObject.setAcl(Lists.transform(this.acl, new Function<Acl, ObjectAccessControl>(){

                @Override
                public ObjectAccessControl apply(Acl acl) {
                    return acl.toObjectPb();
                }
            }));
        }
        if (this.deleteTime != null) {
            storageObject.setTimeDeleted(new DateTime(this.deleteTime));
        }
        if (this.updateTime != null) {
            storageObject.setUpdated(new DateTime(this.updateTime));
        }
        if (this.createTime != null) {
            storageObject.setTimeCreated(new DateTime(this.createTime));
        }
        if (this.customTime != null) {
            storageObject.setCustomTime(new DateTime(this.customTime));
        }
        if (this.size != null) {
            storageObject.setSize(BigInteger.valueOf(this.size));
        }
        if (this.owner != null) {
            storageObject.setOwner(new StorageObject.Owner().setEntity(this.owner.toPb()));
        }
        if (this.storageClass != null) {
            storageObject.setStorageClass(this.storageClass.toString());
        }
        if (this.timeStorageClassUpdated != null) {
            storageObject.setTimeStorageClassUpdated(new DateTime(this.timeStorageClassUpdated));
        }
        Map<String, String> pbMetadata = this.metadata;
        if (this.metadata != null && !Data.isNull(this.metadata)) {
            pbMetadata = Maps.newHashMapWithExpectedSize(this.metadata.size());
            for (Map.Entry<String, String> entry : this.metadata.entrySet()) {
                pbMetadata.put(entry.getKey(), MoreObjects.firstNonNull(entry.getValue(), Data.nullOf(String.class)));
            }
        }
        if (this.customerEncryption != null) {
            storageObject.setCustomerEncryption(this.customerEncryption.toPb());
        }
        if (this.retentionExpirationTime != null) {
            storageObject.setRetentionExpirationTime(new DateTime(this.retentionExpirationTime));
        }
        storageObject.setKmsKeyName(this.kmsKeyName);
        storageObject.setEventBasedHold(this.eventBasedHold);
        storageObject.setTemporaryHold(this.temporaryHold);
        storageObject.setMetadata(pbMetadata);
        storageObject.setCacheControl(this.cacheControl);
        storageObject.setContentEncoding(this.contentEncoding);
        storageObject.setCrc32c(this.crc32c);
        storageObject.setContentType(this.contentType);
        storageObject.setMd5Hash(this.md5);
        storageObject.setMediaLink(this.mediaLink);
        storageObject.setMetageneration(this.metageneration);
        storageObject.setContentDisposition(this.contentDisposition);
        storageObject.setComponentCount(this.componentCount);
        storageObject.setContentLanguage(this.contentLanguage);
        storageObject.setEtag(this.etag);
        storageObject.setId(this.generatedId);
        storageObject.setSelfLink(this.selfLink);
        return storageObject;
    }

    public static Builder newBuilder(BucketInfo bucketInfo, String name) {
        return BlobInfo.newBuilder(bucketInfo.getName(), name);
    }

    public static Builder newBuilder(String bucket, String name) {
        return BlobInfo.newBuilder(BlobId.of(bucket, name));
    }

    public static Builder newBuilder(BucketInfo bucketInfo, String name, Long generation) {
        return BlobInfo.newBuilder(bucketInfo.getName(), name, generation);
    }

    public static Builder newBuilder(String bucket, String name, Long generation) {
        return BlobInfo.newBuilder(BlobId.of(bucket, name, generation));
    }

    public static Builder newBuilder(BlobId blobId) {
        return new BuilderImpl(blobId);
    }

    static BlobInfo fromPb(StorageObject storageObject) {
        Builder builder = BlobInfo.newBuilder(BlobId.fromPb(storageObject));
        if (storageObject.getCacheControl() != null) {
            builder.setCacheControl(storageObject.getCacheControl());
        }
        if (storageObject.getContentEncoding() != null) {
            builder.setContentEncoding(storageObject.getContentEncoding());
        }
        if (storageObject.getCrc32c() != null) {
            builder.setCrc32c(storageObject.getCrc32c());
        }
        if (storageObject.getContentType() != null) {
            builder.setContentType(storageObject.getContentType());
        }
        if (storageObject.getMd5Hash() != null) {
            builder.setMd5(storageObject.getMd5Hash());
        }
        if (storageObject.getMediaLink() != null) {
            builder.setMediaLink(storageObject.getMediaLink());
        }
        if (storageObject.getMetageneration() != null) {
            builder.setMetageneration(storageObject.getMetageneration());
        }
        if (storageObject.getContentDisposition() != null) {
            builder.setContentDisposition(storageObject.getContentDisposition());
        }
        if (storageObject.getComponentCount() != null) {
            builder.setComponentCount(storageObject.getComponentCount());
        }
        if (storageObject.getContentLanguage() != null) {
            builder.setContentLanguage(storageObject.getContentLanguage());
        }
        if (storageObject.getEtag() != null) {
            builder.setEtag(storageObject.getEtag());
        }
        if (storageObject.getId() != null) {
            builder.setGeneratedId(storageObject.getId());
        }
        if (storageObject.getSelfLink() != null) {
            builder.setSelfLink(storageObject.getSelfLink());
        }
        if (storageObject.getMetadata() != null) {
            builder.setMetadata(storageObject.getMetadata());
        }
        if (storageObject.getTimeDeleted() != null) {
            builder.setDeleteTime(storageObject.getTimeDeleted().getValue());
        }
        if (storageObject.getUpdated() != null) {
            builder.setUpdateTime(storageObject.getUpdated().getValue());
        }
        if (storageObject.getTimeCreated() != null) {
            builder.setCreateTime(storageObject.getTimeCreated().getValue());
        }
        if (storageObject.getCustomTime() != null) {
            builder.setCustomTime(storageObject.getCustomTime().getValue());
        }
        if (storageObject.getSize() != null) {
            builder.setSize(storageObject.getSize().longValue());
        }
        if (storageObject.getOwner() != null) {
            builder.setOwner(Acl.Entity.fromPb(storageObject.getOwner().getEntity()));
        }
        if (storageObject.getAcl() != null) {
            builder.setAcl(Lists.transform(storageObject.getAcl(), new Function<ObjectAccessControl, Acl>(){

                @Override
                public Acl apply(ObjectAccessControl objectAccessControl) {
                    return Acl.fromPb(objectAccessControl);
                }
            }));
        }
        if (storageObject.containsKey("isDirectory")) {
            builder.setIsDirectory(Boolean.TRUE);
        }
        if (storageObject.getCustomerEncryption() != null) {
            builder.setCustomerEncryption(CustomerEncryption.fromPb(storageObject.getCustomerEncryption()));
        }
        if (storageObject.getStorageClass() != null) {
            builder.setStorageClass(StorageClass.valueOf(storageObject.getStorageClass()));
        }
        if (storageObject.getTimeStorageClassUpdated() != null) {
            builder.setTimeStorageClassUpdated(storageObject.getTimeStorageClassUpdated().getValue());
        }
        if (storageObject.getKmsKeyName() != null) {
            builder.setKmsKeyName(storageObject.getKmsKeyName());
        }
        if (storageObject.getEventBasedHold() != null) {
            builder.setEventBasedHold(storageObject.getEventBasedHold());
        }
        if (storageObject.getTemporaryHold() != null) {
            builder.setTemporaryHold(storageObject.getTemporaryHold());
        }
        if (storageObject.getRetentionExpirationTime() != null) {
            builder.setRetentionExpirationTime(storageObject.getRetentionExpirationTime().getValue());
        }
        return builder.build();
    }

    static final class BuilderImpl
    extends Builder {
        private final String hexDecimalValues = "0123456789abcdef";
        private BlobId blobId;
        private String generatedId;
        private String contentType;
        private String contentEncoding;
        private String contentDisposition;
        private String contentLanguage;
        private Integer componentCount;
        private String cacheControl;
        private List<Acl> acl;
        private Acl.Entity owner;
        private Long size;
        private String etag;
        private String selfLink;
        private String md5;
        private String crc32c;
        private Long customTime;
        private String mediaLink;
        private Map<String, String> metadata;
        private Long metageneration;
        private Long deleteTime;
        private Long updateTime;
        private Long createTime;
        private Boolean isDirectory;
        private CustomerEncryption customerEncryption;
        private StorageClass storageClass;
        private Long timeStorageClassUpdated;
        private String kmsKeyName;
        private Boolean eventBasedHold;
        private Boolean temporaryHold;
        private Long retentionExpirationTime;

        BuilderImpl(BlobId blobId) {
            this.blobId = blobId;
        }

        BuilderImpl(BlobInfo blobInfo) {
            this.blobId = blobInfo.blobId;
            this.generatedId = blobInfo.generatedId;
            this.cacheControl = blobInfo.cacheControl;
            this.contentEncoding = blobInfo.contentEncoding;
            this.contentType = blobInfo.contentType;
            this.contentDisposition = blobInfo.contentDisposition;
            this.contentLanguage = blobInfo.contentLanguage;
            this.componentCount = blobInfo.componentCount;
            this.customerEncryption = blobInfo.customerEncryption;
            this.acl = blobInfo.acl;
            this.owner = blobInfo.owner;
            this.size = blobInfo.size;
            this.etag = blobInfo.etag;
            this.selfLink = blobInfo.selfLink;
            this.md5 = blobInfo.md5;
            this.crc32c = blobInfo.crc32c;
            this.customTime = blobInfo.customTime;
            this.mediaLink = blobInfo.mediaLink;
            this.metadata = blobInfo.metadata;
            this.metageneration = blobInfo.metageneration;
            this.deleteTime = blobInfo.deleteTime;
            this.updateTime = blobInfo.updateTime;
            this.createTime = blobInfo.createTime;
            this.isDirectory = blobInfo.isDirectory;
            this.storageClass = blobInfo.storageClass;
            this.timeStorageClassUpdated = blobInfo.timeStorageClassUpdated;
            this.kmsKeyName = blobInfo.kmsKeyName;
            this.eventBasedHold = blobInfo.eventBasedHold;
            this.temporaryHold = blobInfo.temporaryHold;
            this.retentionExpirationTime = blobInfo.retentionExpirationTime;
        }

        @Override
        public Builder setBlobId(BlobId blobId) {
            this.blobId = Preconditions.checkNotNull(blobId);
            return this;
        }

        @Override
        Builder setGeneratedId(String generatedId) {
            this.generatedId = generatedId;
            return this;
        }

        @Override
        public Builder setContentType(String contentType) {
            this.contentType = MoreObjects.firstNonNull(contentType, Data.nullOf(String.class));
            return this;
        }

        @Override
        public Builder setContentDisposition(String contentDisposition) {
            this.contentDisposition = MoreObjects.firstNonNull(contentDisposition, Data.nullOf(String.class));
            return this;
        }

        @Override
        public Builder setContentLanguage(String contentLanguage) {
            this.contentLanguage = MoreObjects.firstNonNull(contentLanguage, Data.nullOf(String.class));
            return this;
        }

        @Override
        public Builder setContentEncoding(String contentEncoding) {
            this.contentEncoding = MoreObjects.firstNonNull(contentEncoding, Data.nullOf(String.class));
            return this;
        }

        @Override
        Builder setComponentCount(Integer componentCount) {
            this.componentCount = componentCount;
            return this;
        }

        @Override
        public Builder setCacheControl(String cacheControl) {
            this.cacheControl = MoreObjects.firstNonNull(cacheControl, Data.nullOf(String.class));
            return this;
        }

        @Override
        public Builder setAcl(List<Acl> acl) {
            this.acl = acl != null ? ImmutableList.copyOf(acl) : null;
            return this;
        }

        @Override
        Builder setOwner(Acl.Entity owner) {
            this.owner = owner;
            return this;
        }

        @Override
        Builder setSize(Long size) {
            this.size = size;
            return this;
        }

        @Override
        Builder setEtag(String etag) {
            this.etag = etag;
            return this;
        }

        @Override
        Builder setSelfLink(String selfLink) {
            this.selfLink = selfLink;
            return this;
        }

        @Override
        public Builder setMd5(String md5) {
            this.md5 = MoreObjects.firstNonNull(md5, Data.nullOf(String.class));
            return this;
        }

        @Override
        public Builder setMd5FromHexString(String md5HexString) {
            if (md5HexString == null) {
                return this;
            }
            if (md5HexString.length() % 2 != 0) {
                throw new IllegalArgumentException("each byte must be represented by 2 valid hexadecimal characters");
            }
            String md5HexStringLower = md5HexString.toLowerCase();
            ByteBuffer md5ByteBuffer = ByteBuffer.allocate(md5HexStringLower.length() / 2);
            for (int charIndex = 0; charIndex < md5HexStringLower.length(); charIndex += 2) {
                int higherOrderBits = this.hexDecimalValues.indexOf(md5HexStringLower.charAt(charIndex));
                int lowerOrderBits = this.hexDecimalValues.indexOf(md5HexStringLower.charAt(charIndex + 1));
                if (higherOrderBits == -1 || lowerOrderBits == -1) {
                    throw new IllegalArgumentException("each byte must be represented by 2 valid hexadecimal characters");
                }
                md5ByteBuffer.put((byte)(higherOrderBits << 4 | lowerOrderBits));
            }
            this.md5 = BaseEncoding.base64().encode(md5ByteBuffer.array());
            return this;
        }

        @Override
        public Builder setCrc32c(String crc32c) {
            this.crc32c = MoreObjects.firstNonNull(crc32c, Data.nullOf(String.class));
            return this;
        }

        @Override
        public Builder setCustomTime(Long customTime) {
            this.customTime = customTime;
            return this;
        }

        @Override
        public Builder setCrc32cFromHexString(String crc32cHexString) {
            if (crc32cHexString == null) {
                return this;
            }
            if (crc32cHexString.length() % 2 != 0) {
                throw new IllegalArgumentException("each byte must be represented by 2 valid hexadecimal characters");
            }
            String crc32cHexStringLower = crc32cHexString.toLowerCase();
            ByteBuffer crc32cByteBuffer = ByteBuffer.allocate(crc32cHexStringLower.length() / 2);
            for (int charIndex = 0; charIndex < crc32cHexStringLower.length(); charIndex += 2) {
                int higherOrderBits = this.hexDecimalValues.indexOf(crc32cHexStringLower.charAt(charIndex));
                int lowerOrderBits = this.hexDecimalValues.indexOf(crc32cHexStringLower.charAt(charIndex + 1));
                if (higherOrderBits == -1 || lowerOrderBits == -1) {
                    throw new IllegalArgumentException("each byte must be represented by 2 valid hexadecimal characters");
                }
                crc32cByteBuffer.put((byte)(higherOrderBits << 4 | lowerOrderBits));
            }
            this.crc32c = BaseEncoding.base64().encode(crc32cByteBuffer.array());
            return this;
        }

        @Override
        Builder setMediaLink(String mediaLink) {
            this.mediaLink = mediaLink;
            return this;
        }

        @Override
        public Builder setMetadata(Map<String, String> metadata) {
            this.metadata = metadata != null ? new HashMap<String, String>(metadata) : (Map)Data.nullOf(ImmutableEmptyMap.class);
            return this;
        }

        @Override
        public Builder setStorageClass(StorageClass storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public Builder setTimeStorageClassUpdated(Long timeStorageClassUpdated) {
            this.timeStorageClassUpdated = timeStorageClassUpdated;
            return this;
        }

        @Override
        Builder setMetageneration(Long metageneration) {
            this.metageneration = metageneration;
            return this;
        }

        @Override
        Builder setDeleteTime(Long deleteTime) {
            this.deleteTime = deleteTime;
            return this;
        }

        @Override
        Builder setUpdateTime(Long updateTime) {
            this.updateTime = updateTime;
            return this;
        }

        @Override
        Builder setCreateTime(Long createTime) {
            this.createTime = createTime;
            return this;
        }

        @Override
        Builder setIsDirectory(boolean isDirectory) {
            this.isDirectory = isDirectory;
            return this;
        }

        @Override
        Builder setCustomerEncryption(CustomerEncryption customerEncryption) {
            this.customerEncryption = customerEncryption;
            return this;
        }

        @Override
        Builder setKmsKeyName(String kmsKeyName) {
            this.kmsKeyName = kmsKeyName;
            return this;
        }

        @Override
        public Builder setEventBasedHold(Boolean eventBasedHold) {
            this.eventBasedHold = eventBasedHold;
            return this;
        }

        @Override
        public Builder setTemporaryHold(Boolean temporaryHold) {
            this.temporaryHold = temporaryHold;
            return this;
        }

        @Override
        Builder setRetentionExpirationTime(Long retentionExpirationTime) {
            this.retentionExpirationTime = retentionExpirationTime;
            return this;
        }

        @Override
        public BlobInfo build() {
            Preconditions.checkNotNull(this.blobId);
            return new BlobInfo(this);
        }
    }

    public static abstract class Builder {
        public abstract Builder setBlobId(BlobId var1);

        abstract Builder setGeneratedId(String var1);

        public abstract Builder setContentType(String var1);

        public abstract Builder setContentDisposition(String var1);

        public abstract Builder setContentLanguage(String var1);

        public abstract Builder setContentEncoding(String var1);

        abstract Builder setComponentCount(Integer var1);

        public abstract Builder setCacheControl(String var1);

        public abstract Builder setAcl(List<Acl> var1);

        abstract Builder setOwner(Acl.Entity var1);

        abstract Builder setSize(Long var1);

        abstract Builder setEtag(String var1);

        abstract Builder setSelfLink(String var1);

        public abstract Builder setMd5(String var1);

        public abstract Builder setMd5FromHexString(String var1);

        public abstract Builder setCrc32c(String var1);

        public Builder setCustomTime(Long customTime) {
            throw new UnsupportedOperationException("Override setCustomTime with your own implementation, or use com.google.cloud.storage.Blob.");
        }

        public abstract Builder setCrc32cFromHexString(String var1);

        abstract Builder setMediaLink(String var1);

        public abstract Builder setStorageClass(StorageClass var1);

        public Builder setTimeStorageClassUpdated(Long timeStorageClassUpdated) {
            throw new UnsupportedOperationException("Override setTimeStorageClassUpdated with your own implementation, or use com.google.cloud.storage.Blob.");
        }

        public abstract Builder setMetadata(Map<String, String> var1);

        abstract Builder setMetageneration(Long var1);

        abstract Builder setDeleteTime(Long var1);

        abstract Builder setUpdateTime(Long var1);

        abstract Builder setCreateTime(Long var1);

        abstract Builder setIsDirectory(boolean var1);

        abstract Builder setCustomerEncryption(CustomerEncryption var1);

        abstract Builder setKmsKeyName(String var1);

        @BetaApi
        public abstract Builder setEventBasedHold(Boolean var1);

        @BetaApi
        public abstract Builder setTemporaryHold(Boolean var1);

        @BetaApi
        abstract Builder setRetentionExpirationTime(Long var1);

        public abstract BlobInfo build();
    }

    public static class CustomerEncryption
    implements Serializable {
        private static final long serialVersionUID = -2133042982786959351L;
        private final String encryptionAlgorithm;
        private final String keySha256;

        CustomerEncryption(String encryptionAlgorithm, String keySha256) {
            this.encryptionAlgorithm = encryptionAlgorithm;
            this.keySha256 = keySha256;
        }

        public String getEncryptionAlgorithm() {
            return this.encryptionAlgorithm;
        }

        public String getKeySha256() {
            return this.keySha256;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("encryptionAlgorithm", this.getEncryptionAlgorithm()).add("keySha256", this.getKeySha256()).toString();
        }

        public final int hashCode() {
            return Objects.hash(this.encryptionAlgorithm, this.keySha256);
        }

        public final boolean equals(Object obj) {
            return obj == this || obj != null && obj.getClass().equals(CustomerEncryption.class) && Objects.equals(this.toPb(), ((CustomerEncryption)obj).toPb());
        }

        StorageObject.CustomerEncryption toPb() {
            return new StorageObject.CustomerEncryption().setEncryptionAlgorithm(this.encryptionAlgorithm).setKeySha256(this.keySha256);
        }

        static CustomerEncryption fromPb(StorageObject.CustomerEncryption customerEncryptionPb) {
            return new CustomerEncryption(customerEncryptionPb.getEncryptionAlgorithm(), customerEncryptionPb.getKeySha256());
        }
    }

    public static final class ImmutableEmptyMap<K, V>
    extends AbstractMap<K, V> {
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return ImmutableSet.of();
        }
    }
}

