/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import ai.h2o.com.google.common.collect.ImmutableList;
import com.google.api.services.storage.model.Expr;
import com.google.api.services.storage.model.Policy;
import com.google.cloud.Binding;
import com.google.cloud.Condition;
import com.google.cloud.Policy;
import java.util.ArrayList;
import java.util.List;

class PolicyHelper {
    static Policy convertFromApiPolicy(com.google.api.services.storage.model.Policy apiPolicy) {
        Policy.Builder policyBuilder = Policy.newBuilder();
        List<Policy.Bindings> bindings = apiPolicy.getBindings();
        ImmutableList.Builder coreBindings = ImmutableList.builder();
        if (null != bindings && !bindings.isEmpty()) {
            for (Policy.Bindings binding : bindings) {
                Binding.Builder bindingBuilder = Binding.newBuilder();
                bindingBuilder.setRole(binding.getRole());
                bindingBuilder.setMembers(binding.getMembers());
                if (binding.getCondition() != null) {
                    Condition.Builder conditionBuilder = Condition.newBuilder();
                    conditionBuilder.setTitle(binding.getCondition().getTitle());
                    conditionBuilder.setDescription(binding.getCondition().getDescription());
                    conditionBuilder.setExpression(binding.getCondition().getExpression());
                    bindingBuilder.setCondition(conditionBuilder.build());
                }
                coreBindings.add(bindingBuilder.build());
            }
        }
        policyBuilder.setBindings((List<Binding>)((Object)coreBindings.build()));
        return policyBuilder.setEtag(apiPolicy.getEtag()).setVersion(apiPolicy.getVersion()).build();
    }

    static com.google.api.services.storage.model.Policy convertToApiPolicy(Policy policy) {
        ArrayList<Policy.Bindings> bindings = new ArrayList<Policy.Bindings>(policy.getBindingsList().size());
        for (Binding binding : policy.getBindingsList()) {
            Policy.Bindings apiBinding = new Policy.Bindings();
            apiBinding.setRole(binding.getRole());
            apiBinding.setMembers(new ArrayList<String>(binding.getMembers()));
            if (binding.getCondition() != null) {
                Expr expr2 = new Expr();
                expr2.setTitle(binding.getCondition().getTitle());
                expr2.setDescription(binding.getCondition().getDescription());
                expr2.setExpression(binding.getCondition().getExpression());
                apiBinding.setCondition(expr2);
            }
            bindings.add(apiBinding);
        }
        return new com.google.api.services.storage.model.Policy().setBindings(bindings).setEtag(policy.getEtag()).setVersion(policy.getVersion());
    }

    private PolicyHelper() {
    }
}

