/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jffi;

import com.kenai.jffi.CallContextCache;
import com.kenai.jffi.CallingConvention;
import com.kenai.jffi.Foreign;
import com.kenai.jffi.Type;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CallContext {
    final long contextAddress;
    private final int parameterCount;
    private final int rawParameterSize;
    final Type returnType;
    final Type[] parameterTypes;
    final long[] parameterTypeHandles;
    final int flags;
    private final Foreign foreign = Foreign.getInstance();

    public static CallContext getCallContext(Type returnType, Type[] parameterTypes, CallingConvention convention, boolean saveErrno) {
        return CallContextCache.getInstance().getCallContext(returnType, parameterTypes, convention, saveErrno);
    }

    public static CallContext getCallContext(Type returnType, Type[] parameterTypes, CallingConvention convention, boolean saveErrno, boolean faultProtect) {
        return CallContextCache.getInstance().getCallContext(returnType, parameterTypes, convention, saveErrno, faultProtect);
    }

    public CallContext(Type returnType, Type ... parameterTypes) {
        this(returnType, parameterTypes, CallingConvention.DEFAULT, true);
    }

    public CallContext(Type returnType, Type[] parameterTypes, CallingConvention convention) {
        this(returnType, parameterTypes, convention, true);
    }

    public CallContext(Type returnType, Type[] parameterTypes, CallingConvention convention, boolean saveErrno) {
        this(returnType, parameterTypes, convention, saveErrno, false);
    }

    CallContext(Type returnType, Type[] parameterTypes, CallingConvention convention, boolean saveErrno, boolean faultProtect) {
        int flags = (!saveErrno ? 2 : 0) | (convention == CallingConvention.STDCALL ? 1 : 0) | (faultProtect ? 4 : 0);
        long h2 = this.foreign.newCallContext(returnType.handle(), Type.nativeHandles(parameterTypes), flags);
        if (h2 == 0L) {
            throw new RuntimeException("Failed to create native function");
        }
        this.contextAddress = h2;
        this.returnType = returnType;
        this.parameterTypes = (Type[])parameterTypes.clone();
        this.parameterCount = parameterTypes.length;
        this.rawParameterSize = this.foreign.getCallContextRawParameterSize(h2);
        this.parameterTypeHandles = Type.nativeHandles(parameterTypes);
        this.flags = flags;
    }

    public final int getParameterCount() {
        return this.parameterCount;
    }

    public final int getRawParameterSize() {
        return this.rawParameterSize;
    }

    final long getAddress() {
        return this.contextAddress;
    }

    public final Type getReturnType() {
        return this.returnType;
    }

    public final Type getParameterType(int index) {
        return this.parameterTypes[index];
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        CallContext that = (CallContext)o2;
        if (this.flags != that.flags) {
            return false;
        }
        if (this.parameterCount != that.parameterCount) {
            return false;
        }
        if (this.rawParameterSize != that.rawParameterSize) {
            return false;
        }
        if (!Arrays.equals(this.parameterTypes, that.parameterTypes)) {
            return false;
        }
        return this.returnType.equals(that.returnType);
    }

    public int hashCode() {
        int result = this.parameterCount;
        result = 31 * result + this.returnType.hashCode();
        result = 31 * result + Arrays.hashCode(this.parameterTypes);
        result = 31 * result + this.flags;
        return result;
    }

    @Deprecated
    public final void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (this.contextAddress != 0L) {
                this.foreign.freeCallContext(this.contextAddress);
            }
        }
        catch (Throwable t2) {
            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, "exception when freeing " + this.getClass() + ": %s", t2.getLocalizedMessage());
        }
        finally {
            super.finalize();
        }
    }
}

