/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.shaded.json.parser;

import com.nimbusds.jose.shaded.json.JSONValue;
import com.nimbusds.jose.shaded.json.parser.JSONParserMemory;
import com.nimbusds.jose.shaded.json.parser.ParseException;
import com.nimbusds.jose.shaded.json.writer.JsonReaderI;
import java.nio.charset.StandardCharsets;

class JSONParserByteArray
extends JSONParserMemory {
    private byte[] in;

    public JSONParserByteArray(int permissiveMode) {
        super(permissiveMode);
    }

    public Object parse(byte[] in) throws ParseException {
        return this.parse(in, JSONValue.defaultReader.DEFAULT);
    }

    public <T> T parse(byte[] in, JsonReaderI<T> mapper) throws ParseException {
        this.base = mapper.base;
        this.in = in;
        this.len = in.length;
        return this.parse(mapper);
    }

    @Override
    protected void extractString(int beginIndex, int endIndex) {
        this.xs = new String(this.in, beginIndex, endIndex - beginIndex, StandardCharsets.UTF_8);
    }

    @Override
    protected void extractStringTrim(int start, int stop2) {
        byte[] val = this.in;
        while (start < stop2 && val[start] <= 32) {
            ++start;
        }
        while (start < stop2 && val[stop2 - 1] <= 32) {
            --stop2;
        }
        this.xs = new String(this.in, start, stop2 - start, StandardCharsets.UTF_8);
    }

    @Override
    protected int indexOf(char c2, int pos) {
        for (int i2 = pos; i2 < this.len; ++i2) {
            if (this.in[i2] != (byte)c2) continue;
            return i2;
        }
        return -1;
    }

    @Override
    protected void read() {
        this.c = ++this.pos >= this.len ? (char)26 : (char)this.in[this.pos];
    }

    @Override
    protected void readS() {
        this.c = ++this.pos >= this.len ? (char)26 : (char)this.in[this.pos];
    }

    @Override
    protected void readNoEnd() throws ParseException {
        if (++this.pos >= this.len) {
            this.c = (char)26;
            throw new ParseException(this.pos - 1, 3, "EOF");
        }
        this.c = (char)this.in[this.pos];
    }
}

