/*
 * Decompiled with CFR 0.152.
 */
package hex;

import java.util.Arrays;
import water.Iced;
import water.MRTask;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Chunk;
import water.fvec.Vec;
import water.util.fp.Function;

public class AUC2
extends Iced {
    public final int _nBins;
    public final double[] _ths;
    public final double[] _tps;
    public final double[] _fps;
    public final double _p;
    public final double _n;
    public double _auc;
    public double _gini;
    public double _pr_auc;
    public final int _max_idx;
    public static final ThresholdCriterion DEFAULT_CM = ThresholdCriterion.f1;
    public static final int NBINS = 400;

    public double threshold(int idx) {
        return this._ths[idx];
    }

    public double tp(int idx) {
        return this._tps[idx];
    }

    public double fp(int idx) {
        return this._fps[idx];
    }

    public double tn(int idx) {
        return this._n - this._fps[idx];
    }

    public double fn(int idx) {
        return this._p - this._tps[idx];
    }

    public double maxF1() {
        return ThresholdCriterion.f1.max_criterion(this);
    }

    public Function<Integer, Double> forCriterion(final ThresholdCriterion tc) {
        return new Function<Integer, Double>(){

            @Override
            public Double apply(Integer i2) {
                return tc.exec(AUC2.this, i2);
            }
        };
    }

    public AUC2(Vec probs, Vec actls) {
        this(400, probs, actls);
    }

    AUC2(int nBins, Vec probs, Vec actls) {
        this(((AUC_Impl)new AUC_Impl((int)nBins).doAll((Vec[])new Vec[]{probs, actls}))._bldr);
    }

    public AUC2(AUCBuilder bldr) {
        this(bldr, true);
    }

    private AUC2(AUCBuilder bldr, boolean trueProbabilities) {
        this._nBins = bldr._n;
        assert (this._nBins >= 1) : "Must have >= 1 bins for AUC calculation, but got " + this._nBins;
        assert (trueProbabilities || bldr._ths[this._nBins - 1] == 1.0) : "Bins need to contain pred = 1 when 0-1 probabilities are used";
        this._ths = Arrays.copyOf(bldr._ths, this._nBins);
        this._tps = Arrays.copyOf(bldr._tps, this._nBins);
        this._fps = Arrays.copyOf(bldr._fps, this._nBins);
        for (int i2 = 0; i2 < this._nBins >> 1; ++i2) {
            double tmp = this._ths[i2];
            this._ths[i2] = this._ths[this._nBins - 1 - i2];
            this._ths[this._nBins - 1 - i2] = tmp;
            double tmpt = this._tps[i2];
            this._tps[i2] = this._tps[this._nBins - 1 - i2];
            this._tps[this._nBins - 1 - i2] = tmpt;
            double tmpf = this._fps[i2];
            this._fps[i2] = this._fps[this._nBins - 1 - i2];
            this._fps[this._nBins - 1 - i2] = tmpf;
        }
        double p2 = 0.0;
        double n2 = 0.0;
        for (int i3 = 0; i3 < this._nBins; ++i3) {
            this._tps[i3] = p2 += this._tps[i3];
            this._fps[i3] = n2 += this._fps[i3];
        }
        this._p = p2;
        this._n = n2;
        if (trueProbabilities) {
            this._auc = this.compute_auc();
            this._pr_auc = this.pr_auc();
            this._gini = 2.0 * this._auc - 1.0;
            this._max_idx = DEFAULT_CM.max_criterion_idx(this);
        } else {
            this._auc = Double.NaN;
            this._pr_auc = Double.NaN;
            this._gini = Double.NaN;
            this._max_idx = 0;
        }
    }

    private AUC2(AUC2 auc, int idx) {
        this._nBins = 1;
        this._ths = new double[]{auc._ths[idx]};
        this._tps = new double[]{auc._tps[idx]};
        this._fps = new double[]{auc._fps[idx]};
        this._p = auc._p;
        this._n = auc._n;
        this._auc = auc._auc;
        this._pr_auc = auc._pr_auc;
        this._gini = auc._gini;
        this._max_idx = auc._max_idx >= 0 ? 0 : -1;
    }

    AUC2 restrictToMaxCriterion() {
        return this._max_idx >= 0 ? new AUC2(this, this._max_idx) : null;
    }

    public static AUC2 make01AUC(AUCBuilder bldr) {
        bldr.perRow(1.0, 0, 0.0);
        return new AUC2(bldr, false).restrictToMaxCriterion();
    }

    AUC2() {
        this._nBins = 0;
        this._fps = new double[0];
        this._tps = this._fps;
        this._ths = this._fps;
        this._n = 0.0;
        this._p = 0.0;
        this._pr_auc = Double.NaN;
        this._gini = Double.NaN;
        this._auc = Double.NaN;
        this._max_idx = -1;
    }

    public static AUC2 emptyAUC() {
        return new AUC2();
    }

    public boolean isEmpty() {
        return this._nBins == 0;
    }

    void checkRecallValidity() {
        double x0 = ThresholdCriterion.recall.exec(this, 0);
        for (int i2 = 1; i2 < this._nBins; ++i2) {
            double x1 = ThresholdCriterion.recall.exec(this, i2);
            if (x0 > x1) {
                throw new H2OIllegalArgumentException(String.valueOf(i2), "recall", x0 + " > " + x1);
            }
            x0 = x1;
        }
    }

    private double compute_auc() {
        if (this._fps[this._nBins - 1] == 0.0) {
            return 1.0;
        }
        if (this._tps[this._nBins - 1] == 0.0) {
            return 0.0;
        }
        double tp0 = 0.0;
        double fp0 = 0.0;
        double area = 0.0;
        for (int i2 = 0; i2 < this._nBins; ++i2) {
            area += (this._fps[i2] - fp0) * (this._tps[i2] + tp0) / 2.0;
            tp0 = this._tps[i2];
            fp0 = this._fps[i2];
        }
        return area / this._p / this._n;
    }

    public double pr_auc() {
        if (this.isEmpty()) {
            return Double.NaN;
        }
        this.checkRecallValidity();
        if (this._fps[this._nBins - 1] == 0.0) {
            return 1.0;
        }
        if (this._tps[this._nBins - 1] == 0.0) {
            return 0.0;
        }
        double area = 0.0;
        assert (this._p > 0.0 && this._n > 0.0) : "AUC-PR calculation error, sum of positives and sum of negatives should be greater than zero.";
        double prevtp = 0.0;
        double prevfp = 0.0;
        for (int j2 = 0; j2 < this._nBins; ++j2) {
            double b2;
            double a2;
            double tp = this._tps[j2];
            double fp = this._fps[j2];
            if (tp == prevtp) {
                a2 = 1.0;
                b2 = 0.0;
            } else {
                double h2 = (fp - prevfp) / (tp - prevtp);
                a2 = 1.0 + h2;
                b2 = (prevfp - h2 * prevtp) / this._p;
            }
            double tpp = tp / this._p;
            double prevtpp = prevtp / this._p;
            area = 0.0 != b2 ? (area += (tpp - prevtpp - b2 / a2 * (Math.log(a2 * tpp + b2) - Math.log(a2 * prevtpp + b2))) / a2) : (area += (tpp - prevtpp) / a2);
            prevtp = tp;
            prevfp = fp;
        }
        return area;
    }

    public double[][] buildCM(int idx) {
        return new double[][]{{this.tn(idx), this.fp(idx)}, {this.fn(idx), this.tp(idx)}};
    }

    public double[][] defaultCM() {
        return this._max_idx == -1 ? (double[][])null : this.buildCM(this._max_idx);
    }

    public double[][] cmByCriterion(ThresholdCriterion criterion) {
        int maxIdx = criterion.max_criterion_idx(this);
        return this.buildCM(maxIdx);
    }

    public double defaultThreshold() {
        return this._max_idx == -1 ? 0.5 : this._ths[this._max_idx];
    }

    public double defaultErr() {
        return this._max_idx == -1 ? Double.NaN : (this.fp(this._max_idx) + this.fn(this._max_idx)) / (this._p + this._n);
    }

    public static double perfectAUC(Vec vprob, Vec vacts) {
        if (vacts.min() < 0.0 || vacts.max() > 1.0 || !vacts.isInt()) {
            throw new IllegalArgumentException("Actuals are either 0 or 1");
        }
        if (vprob.min() < 0.0 || vprob.max() > 1.0) {
            throw new IllegalArgumentException("Probabilities are between 0 and 1");
        }
        Vec.Reader rprob = new Vec.Reader(vprob);
        Vec.Reader racts = new Vec.Reader(vacts);
        int posCnt = (int)vacts.nzCnt();
        int negCnt = (int)(vacts.length() - (long)posCnt);
        double[] posProbs = new double[posCnt];
        double[] negProbs = new double[negCnt];
        int pc = 0;
        int nc = 0;
        for (int i2 = 0; i2 < posCnt + negCnt; ++i2) {
            byte actual = (byte)racts.at8(i2);
            double prob = rprob.at(i2);
            if (actual == 1) {
                posProbs[pc++] = prob;
                continue;
            }
            negProbs[nc++] = prob;
        }
        assert (pc == posProbs.length);
        assert (nc == negProbs.length);
        return AUC2.perfectAUCFromComponents(negProbs, posProbs);
    }

    static double perfectAUC(double[] ds, double[] acts) {
        int posCnt = 0;
        for (double act : acts) {
            if (act != 1.0) continue;
            ++posCnt;
        }
        double[] posProbs = new double[posCnt];
        double[] negProbs = new double[acts.length - posCnt];
        int pi = 0;
        int ni = 0;
        for (int i2 = 0; i2 < acts.length; ++i2) {
            if (acts[i2] == 1.0) {
                posProbs[pi++] = ds[i2];
                continue;
            }
            negProbs[ni++] = ds[i2];
        }
        return AUC2.perfectAUCFromComponents(negProbs, posProbs);
    }

    private static double perfectAUCFromComponents(double[] negProbs, double[] posProbs) {
        Arrays.sort(posProbs);
        Arrays.sort(negProbs);
        double[] probs = new double[negProbs.length + posProbs.length];
        byte[] acts = new byte[probs.length];
        int pi = 0;
        int ni = 0;
        for (int i2 = 0; i2 < probs.length; ++i2) {
            boolean takeNeg;
            boolean bl = takeNeg = pi == posProbs.length || ni < negProbs.length && negProbs[ni] <= posProbs[pi];
            if (takeNeg) {
                probs[i2] = negProbs[ni++];
                acts[i2] = 0;
                continue;
            }
            probs[i2] = posProbs[pi++];
            acts[i2] = 1;
        }
        return AUC2.perfectAUC(probs, acts);
    }

    private static double perfectAUC(double[] sortedProbs, byte[] sortedActs) {
        int tp0 = 0;
        int fp0 = 0;
        int tp1 = 0;
        int fp1 = 0;
        double prob = 1.0;
        double area = 0.0;
        for (int i2 = sortedProbs.length - 1; i2 >= 0; --i2) {
            if (sortedProbs[i2] != prob) {
                area += (double)((fp1 - fp0) * (tp1 + tp0)) / 2.0;
                tp0 = tp1;
                fp0 = fp1;
                prob = sortedProbs[i2];
            }
            if (sortedActs[i2] == 1) {
                ++tp1;
                continue;
            }
            ++fp1;
        }
        area += (double)tp0 * (double)(fp1 - fp0);
        return (area += (double)(tp1 - tp0) * (double)(fp1 - fp0) / 2.0) / (double)tp1 / (double)fp1;
    }

    public static class AUCBuilder
    extends Iced {
        final int _nBins;
        int _n;
        final double[] _ths;
        final double[] _sqe;
        final double[] _tps;
        final double[] _fps;
        int _ssx;
        private boolean _useFastPath = true;

        public AUCBuilder(int nBins) {
            this._nBins = nBins;
            this._ths = new double[nBins << 1];
            this._sqe = new double[nBins << 1];
            this._tps = new double[nBins << 1];
            this._fps = new double[nBins << 1];
            this._ssx = -1;
        }

        AUCBuilder(int nBins, boolean useFastPath) {
            this(nBins);
            this._useFastPath = useFastPath;
        }

        public void perRow(double pred, int act, double w2) {
            assert (!Double.isNaN(pred));
            assert (act == 0 || act == 1);
            assert (!Double.isNaN(w2) && !Double.isInfinite(w2));
            int idx = Arrays.binarySearch(this._ths, 0, this._n, pred);
            if (idx >= 0) {
                if (act == 0) {
                    int n2 = idx;
                    this._fps[n2] = this._fps[n2] + w2;
                } else {
                    int n3 = idx;
                    this._tps[n3] = this._tps[n3] + w2;
                }
                this._ssx = -1;
                return;
            }
            idx = -idx - 1;
            if (this._n == this._nBins && this._useFastPath && idx > 0 && idx < this._n && this._ths[idx - 1] != this._ths[idx]) {
                int ssx = this.find_smallest();
                double dssx = this._sqe[ssx] + this._sqe[ssx + 1] + this.compute_delta_error(this._ths[ssx + 1], this.k(ssx + 1), this._ths[ssx], this.k(ssx));
                double d0 = this._sqe[idx - 1] + this.compute_delta_error(pred, w2, this._ths[idx - 1], this.k(idx - 1));
                double d1 = this._sqe[idx] + this.compute_delta_error(this._ths[idx], this.k(idx), pred, w2);
                if (d0 < dssx || d1 < dssx) {
                    if (d0 <= d1) {
                        --idx;
                    }
                    if (ssx == idx - 1 || ssx == idx) {
                        this._ssx = -1;
                    }
                    double k2 = this.k(idx);
                    if (act == 0) {
                        int n4 = idx;
                        this._fps[n4] = this._fps[n4] + w2;
                    } else {
                        int n5 = idx;
                        this._tps[n5] = this._tps[n5] + w2;
                    }
                    this._sqe[idx] = this._sqe[idx] + this.compute_delta_error(pred, w2, this._ths[idx], k2);
                    this._ths[idx] = AUCBuilder.combine_centers(this._ths[idx], k2, pred, w2);
                    return;
                }
            }
            if (idx == 0 || idx == this._n || idx == this._ssx) {
                this._ssx = -1;
            } else if (idx < this._ssx) {
                ++this._ssx;
            }
            System.arraycopy(this._ths, idx, this._ths, idx + 1, this._n - idx);
            System.arraycopy(this._sqe, idx, this._sqe, idx + 1, this._n - idx);
            System.arraycopy(this._tps, idx, this._tps, idx + 1, this._n - idx);
            System.arraycopy(this._fps, idx, this._fps, idx + 1, this._n - idx);
            this._ths[idx] = pred;
            this._sqe[idx] = 0.0;
            if (act == 0) {
                this._tps[idx] = 0.0;
                this._fps[idx] = w2;
            } else {
                this._tps[idx] = w2;
                this._fps[idx] = 0.0;
            }
            ++this._n;
            if (this._n > this._nBins) {
                this.mergeOneBin();
            }
        }

        public void reduce(AUCBuilder bldr) {
            int x2 = this._n - 1;
            int y2 = bldr._n - 1;
            while (x2 + y2 + 1 >= 0) {
                boolean self_is_larger = y2 < 0 || x2 >= 0 && this._ths[x2] >= bldr._ths[y2];
                AUCBuilder b2 = self_is_larger ? this : bldr;
                int idx = self_is_larger ? x2 : y2;
                this._ths[x2 + y2 + 1] = b2._ths[idx];
                this._sqe[x2 + y2 + 1] = b2._sqe[idx];
                this._tps[x2 + y2 + 1] = b2._tps[idx];
                this._fps[x2 + y2 + 1] = b2._fps[idx];
                if (self_is_larger) {
                    --x2;
                    continue;
                }
                --y2;
            }
            this._n += bldr._n;
            this._ssx = -1;
            while (this._n > this._nBins || this.dups()) {
                this.mergeOneBin();
            }
        }

        static double combine_centers(double ths1, double n1, double ths0, double n0) {
            double center = (ths0 * n0 + ths1 * n1) / (n0 + n1);
            if (Double.isNaN(center) || Double.isInfinite(center)) {
                return (ths0 + ths1) / 2.0;
            }
            return center;
        }

        private void mergeOneBin() {
            int ssx = this.find_smallest();
            double k0 = this.k(ssx);
            double k1 = this.k(ssx + 1);
            this._sqe[ssx] = this._sqe[ssx] + this._sqe[ssx + 1] + this.compute_delta_error(this._ths[ssx + 1], k1, this._ths[ssx], k0);
            this._ths[ssx] = AUCBuilder.combine_centers(this._ths[ssx], k0, this._ths[ssx + 1], k1);
            int n2 = ssx;
            this._tps[n2] = this._tps[n2] + this._tps[ssx + 1];
            int n3 = ssx;
            this._fps[n3] = this._fps[n3] + this._fps[ssx + 1];
            System.arraycopy(this._ths, ssx + 2, this._ths, ssx + 1, this._n - ssx - 2);
            System.arraycopy(this._sqe, ssx + 2, this._sqe, ssx + 1, this._n - ssx - 2);
            System.arraycopy(this._tps, ssx + 2, this._tps, ssx + 1, this._n - ssx - 2);
            System.arraycopy(this._fps, ssx + 2, this._fps, ssx + 1, this._n - ssx - 2);
            --this._n;
            this._ssx = -1;
        }

        private int find_smallest() {
            if (this._ssx == -1) {
                this._ssx = this.find_smallest_impl();
                assert (this._ssx != -1) : this.toDebugString();
            }
            return this._ssx;
        }

        private String toDebugString() {
            return "_ssx = " + this._ssx + "; n = " + this._n + "; ths = " + Arrays.toString(this._ths) + "; tps = " + Arrays.toString(this._tps) + "; fps = " + Arrays.toString(this._fps) + "; sqe = " + Arrays.toString(this._sqe);
        }

        private int find_smallest_impl() {
            if (this._n == 1) {
                return 0;
            }
            double minSQE = Double.MAX_VALUE;
            int minI = -1;
            int n2 = this._n;
            for (int i2 = 0; i2 < n2 - 1; ++i2) {
                double derr = this.compute_delta_error(this._ths[i2 + 1], this.k(i2 + 1), this._ths[i2], this.k(i2));
                if (derr == 0.0) {
                    return i2;
                }
                double sqe = this._sqe[i2] + this._sqe[i2 + 1] + derr;
                if (!(sqe < minSQE)) continue;
                minI = i2;
                minSQE = sqe;
            }
            if (minI == -1) {
                minI = 0;
                double minDist = this._ths[1] - this._ths[0];
                for (int i3 = 1; i3 < n2 - 1; ++i3) {
                    double dist = this._ths[i3 + 1] - this._ths[i3];
                    if (!(dist < minDist)) continue;
                    minDist = dist;
                    minI = i3;
                }
            }
            return minI;
        }

        private boolean dups() {
            int n2 = this._n;
            for (int i2 = 0; i2 < n2 - 1; ++i2) {
                double derr = this.compute_delta_error(this._ths[i2 + 1], this.k(i2 + 1), this._ths[i2], this.k(i2));
                if (derr != 0.0) continue;
                this._ssx = i2;
                return true;
            }
            return false;
        }

        private double compute_delta_error(double ths1, double n1, double ths0, double n0) {
            double delta = (float)ths1 - (float)ths0;
            if (delta == 0.0) {
                return 0.0;
            }
            return delta * delta * n0 * n1 / (n0 + n1);
        }

        private double k(int idx) {
            return this._tps[idx] + this._fps[idx];
        }
    }

    private static class AUC_Impl
    extends MRTask<AUC_Impl> {
        final int _nBins;
        AUCBuilder _bldr;

        AUC_Impl(int nBins) {
            this._nBins = nBins;
        }

        @Override
        public void map(Chunk ps, Chunk as) {
            AUCBuilder bldr = this._bldr = new AUCBuilder(this._nBins);
            for (int row = 0; row < ps._len; ++row) {
                if (ps.isNA(row) || as.isNA(row)) continue;
                bldr.perRow(ps.atd(row), (int)as.at8(row), 1.0);
            }
        }

        @Override
        public void reduce(AUC_Impl auc) {
            this._bldr.reduce(auc._bldr);
        }
    }

    public static enum ThresholdCriterion {
        f1(false){

            @Override
            double exec(double tp, double fp, double fn, double tn) {
                double prec = precision.exec(tp, fp, fn, tn);
                double recl = tpr.exec(tp, fp, fn, tn);
                return 2.0 * (prec * recl) / (prec + recl);
            }
        }
        ,
        f2(false){

            @Override
            double exec(double tp, double fp, double fn, double tn) {
                double prec = precision.exec(tp, fp, fn, tn);
                double recl = tpr.exec(tp, fp, fn, tn);
                return 5.0 * (prec * recl) / (4.0 * prec + recl);
            }
        }
        ,
        f0point5(false){

            @Override
            double exec(double tp, double fp, double fn, double tn) {
                double prec = precision.exec(tp, fp, fn, tn);
                double recl = tpr.exec(tp, fp, fn, tn);
                return 1.25 * (prec * recl) / (0.25 * prec + recl);
            }
        }
        ,
        accuracy(false){

            @Override
            double exec(double tp, double fp, double fn, double tn) {
                return (tn + tp) / (tp + fn + tn + fp);
            }
        }
        ,
        precision(false){

            @Override
            double exec(double tp, double fp, double fn, double tn) {
                return tp / (tp + fp);
            }
        }
        ,
        recall(false){

            @Override
            double exec(double tp, double fp, double fn, double tn) {
                return tp / (tp + fn);
            }
        }
        ,
        specificity(false){

            @Override
            double exec(double tp, double fp, double fn, double tn) {
                return tn / (tn + fp);
            }
        }
        ,
        absolute_mcc(false){

            @Override
            double exec(double tp, double fp, double fn, double tn) {
                double mcc = tp * tn - fp * fn;
                if (mcc == 0.0) {
                    return 0.0;
                }
                double eps = 1.0E-10;
                double absMcc = Math.abs(mcc /= Math.sqrt((tp + fp) * (tp + fn) * (tn + fp) * (tn + fn)));
                assert (absMcc <= 1.0 + eps) : "Absolute mcc is greater than 1: mcc=" + absMcc + " tp=" + tp + " fp=" + fp + " fn=" + fn + " tn=" + tn;
                if (absMcc > 1.0) {
                    return 1.0;
                }
                return absMcc;
            }
        }
        ,
        min_per_class_accuracy(false){

            @Override
            double exec(double tp, double fp, double fn, double tn) {
                return Math.min(tp / (tp + fn), tn / (tn + fp));
            }
        }
        ,
        mean_per_class_accuracy(false){

            @Override
            double exec(double tp, double fp, double fn, double tn) {
                return 0.5 * (tp / (tp + fn) + tn / (tn + fp));
            }
        }
        ,
        tns(true){

            @Override
            double exec(double tp, double fp, double fn, double tn) {
                return tn;
            }
        }
        ,
        fns(true){

            @Override
            double exec(double tp, double fp, double fn, double tn) {
                return fn;
            }
        }
        ,
        fps(true){

            @Override
            double exec(double tp, double fp, double fn, double tn) {
                return fp;
            }
        }
        ,
        tps(true){

            @Override
            double exec(double tp, double fp, double fn, double tn) {
                return tp;
            }
        }
        ,
        tnr(false){

            @Override
            double exec(double tp, double fp, double fn, double tn) {
                return tn / (fp + tn);
            }
        }
        ,
        fnr(false){

            @Override
            double exec(double tp, double fp, double fn, double tn) {
                return fn / (fn + tp);
            }
        }
        ,
        fpr(false){

            @Override
            double exec(double tp, double fp, double fn, double tn) {
                return fp / (fp + tn);
            }
        }
        ,
        tpr(false){

            @Override
            double exec(double tp, double fp, double fn, double tn) {
                return tp / (tp + fn);
            }
        };

        public final boolean _isInt;
        public static final ThresholdCriterion[] VALUES;

        private ThresholdCriterion(boolean isInt) {
            this._isInt = isInt;
        }

        abstract double exec(double var1, double var3, double var5, double var7);

        public double exec(AUC2 auc, int idx) {
            return this.exec(auc.tp(idx), auc.fp(idx), auc.fn(idx), auc.tn(idx));
        }

        public double max_criterion(AUC2 auc) {
            return this.exec(auc, this.max_criterion_idx(auc));
        }

        public int max_criterion_idx(AUC2 auc) {
            double md = -1.7976931348623157E308;
            int mx = -1;
            for (int i2 = 0; i2 < auc._nBins; ++i2) {
                double d2 = this.exec(auc, i2);
                if (!(d2 > md)) continue;
                md = d2;
                mx = i2;
            }
            return mx;
        }

        public static ThresholdCriterion fromString(String strRepr) {
            for (ThresholdCriterion tc : ThresholdCriterion.values()) {
                if (!tc.toString().equalsIgnoreCase(strRepr)) continue;
                return tc;
            }
            return null;
        }

        static {
            VALUES = ThresholdCriterion.values();
        }
    }
}

