/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Distribution;
import hex.LinkFunction;
import hex.LogExpUtil;
import hex.LogitFunction;
import hex.genmodel.utils.DistributionFamily;

class BernoulliDistribution
extends Distribution {
    public BernoulliDistribution(DistributionFamily family) {
        super(family, (LinkFunction)new LogitFunction());
    }

    @Override
    public double deviance(double w2, double y2, double f2) {
        return -2.0 * w2 * (y2 * LogExpUtil.log(f2) + (1.0 - y2) * LogExpUtil.log(1.0 - f2));
    }

    @Override
    public double negHalfGradient(double y2, double f2) {
        return y2 - this.linkInv(f2);
    }

    @Override
    public double initFNum(double w2, double o2, double y2) {
        return w2 * (y2 - o2);
    }

    @Override
    public double initFDenom(double w2, double o2, double y2) {
        return w2;
    }

    @Override
    public double gammaNum(double w2, double y2, double z2, double f2) {
        return w2 * z2;
    }

    @Override
    public double gammaDenom(double w2, double y2, double z2, double f2) {
        double ff = y2 - z2;
        return w2 * ff * (1.0 - ff);
    }
}

