/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.ModelBuilder;
import org.apache.log4j.Logger;
import water.Job;

public class CVModelBuilder {
    private static final Logger LOG = Logger.getLogger(CVModelBuilder.class);
    private final Job job;
    private final ModelBuilder<?, ?, ?>[] modelBuilders;
    private final int parallelization;

    public CVModelBuilder(Job job, ModelBuilder<?, ?, ?>[] modelBuilders, int parallelization) {
        this.job = job;
        this.modelBuilders = modelBuilders;
        this.parallelization = parallelization;
    }

    protected void prepare(ModelBuilder m4) {
    }

    protected void finished(ModelBuilder m4) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bulkBuildModels() {
        int i2;
        int N2 = this.modelBuilders.length;
        ModelBuilder.TrainModelTaskController[] submodel_tasks = new ModelBuilder.TrainModelTaskController[N2];
        int nRunning = 0;
        RuntimeException rt = null;
        for (i2 = 0; i2 < N2; ++i2) {
            if (this.job.stop_requested()) {
                LOG.info((Object)("Skipping build of last " + (N2 - i2) + " out of " + N2 + " cross-validation models"));
                this.stopAll(submodel_tasks);
                throw new Job.JobCancelledException();
            }
            LOG.info((Object)("Building cross-validation model " + (i2 + 1) + " / " + N2 + "."));
            this.prepare(this.modelBuilders[i2]);
            this.modelBuilders[i2].startClock();
            submodel_tasks[i2] = this.modelBuilders[i2].submitTrainModelTask();
            if (++nRunning != this.parallelization) continue;
            while (nRunning > 0) {
                int waitForTaskIndex = i2 + 1 - nRunning;
                try {
                    submodel_tasks[waitForTaskIndex].join();
                    this.finished(this.modelBuilders[waitForTaskIndex]);
                }
                catch (RuntimeException t2) {
                    if (rt == null) {
                        LOG.info((Object)("Exception from CV model #" + waitForTaskIndex + " will be reported as main exception."));
                        rt = t2;
                        continue;
                    }
                    LOG.warn((Object)("CV model #" + waitForTaskIndex + " failed, the exception will not be reported"), (Throwable)t2);
                }
                finally {
                    LOG.info((Object)("Completed cross-validation model " + waitForTaskIndex + " / " + N2 + "."));
                    --nRunning;
                }
            }
            if (rt == null) continue;
            throw rt;
        }
        for (i2 = 0; i2 < N2; ++i2) {
            try {
                ModelBuilder.TrainModelTaskController task = submodel_tasks[i2];
                assert (task != null);
                task.join();
                continue;
            }
            catch (RuntimeException t3) {
                if (rt == null) {
                    LOG.info((Object)("Exception from CV model #" + i2 + " will be reported as main exception."));
                    rt = t3;
                    continue;
                }
                LOG.warn((Object)("CV model #" + i2 + " failed, the exception will not be reported"), (Throwable)t3);
                continue;
            }
            finally {
                LOG.info((Object)("Completed cross-validation model " + i2 + " / " + N2 + "."));
            }
        }
        if (rt != null) {
            throw rt;
        }
    }

    private void stopAll(ModelBuilder.TrainModelTaskController[] tasks) {
        for (ModelBuilder.TrainModelTaskController task : tasks) {
            if (task == null) continue;
            task.cancel(true);
        }
    }
}

