/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.CustomDistributionWrapper;
import hex.Distribution;
import hex.LinkFunctionFactory;
import hex.Model;
import water.H2O;
import water.udf.CDistributionFunc;
import water.udf.CFuncRef;

class CustomDistribution
extends Distribution {
    private CustomDistributionWrapper _wrapper;
    private static CustomDistribution _instance;
    private String _distributionDef;

    private CustomDistribution(Model.Parameters params) {
        super(params);
        this._distributionDef = params._custom_distribution_func;
        this._wrapper = new CustomDistributionWrapper(CFuncRef.from(params._custom_distribution_func));
        assert (this._wrapper != null);
        assert (this._wrapper.getFunc() != null);
        this._linkFunction = LinkFunctionFactory.getLinkFunction(((CDistributionFunc)this._wrapper.getFunc()).link());
    }

    public static CustomDistribution getCustomDistribution(Model.Parameters params) {
        if (_instance == null || !params._custom_distribution_func.equals(CustomDistribution._instance._distributionDef)) {
            _instance = new CustomDistribution(params);
        }
        return _instance;
    }

    @Override
    public double deviance(double w2, double y2, double f2) {
        throw H2O.unimpl("Deviance is not supported in Custom Distribution.");
    }

    @Override
    public double negHalfGradient(double y2, double f2) {
        return ((CDistributionFunc)this._wrapper.getFunc()).gradient(y2, f2);
    }

    @Override
    public double negHalfGradient(double y2, double f2, int l2) {
        return ((CDistributionFunc)this._wrapper.getFunc()).gradient(y2, f2, l2);
    }

    @Override
    public double initFNum(double w2, double o2, double y2) {
        double[] init = ((CDistributionFunc)this._wrapper.getFunc()).init(w2, o2, y2);
        assert (init.length == 2);
        return init[0];
    }

    @Override
    public double initFDenom(double w2, double o2, double y2) {
        double[] init = ((CDistributionFunc)this._wrapper.getFunc()).init(w2, o2, y2);
        assert (init.length == 2);
        return init[1];
    }

    @Override
    public double gammaNum(double w2, double y2, double z2, double f2) {
        double[] gamma = ((CDistributionFunc)this._wrapper.getFunc()).gamma(w2, y2, z2, f2);
        assert (gamma.length == 2);
        return gamma[0];
    }

    @Override
    public double gammaDenom(double w2, double y2, double z2, double f2) {
        double[] gamma = ((CDistributionFunc)this._wrapper.getFunc()).gamma(w2, y2, z2, f2);
        assert (gamma.length == 2);
        return gamma[1];
    }

    @Override
    public void reset() {
        this._wrapper.setupLocal();
    }
}

