/*
 * Decompiled with CFR 0.152.
 */
package hex;

import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import water.DKV;
import water.H2O;
import water.Iced;
import water.Key;
import water.MRTask;
import water.MemoryManager;
import water.TAtomic;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.Log;

public class DMatrix {
    static int cnt = 0;

    public static Frame transpose(Frame src) {
        if (src.numRows() != (long)((int)src.numRows())) {
            throw H2O.unimpl();
        }
        int nchunks = Math.max(1, src.numCols() / 10000);
        long[] espc = new long[nchunks + 1];
        int rpc = src.numCols() / nchunks;
        int rem = src.numCols() % nchunks;
        Arrays.fill(espc, (long)rpc);
        int i2 = 0;
        while (i2 < rem) {
            int n2 = i2++;
            espc[n2] = espc[n2] + 1L;
        }
        long sum = 0L;
        for (int i3 = 0; i3 < espc.length; ++i3) {
            long s2 = espc[i3];
            espc[i3] = sum;
            sum += s2;
        }
        Key<Vec> key = Vec.newKey();
        int rowLayout = Vec.ESPC.rowLayout(key, espc);
        return DMatrix.transpose(src, new Frame(new Vec(key, rowLayout).makeZeros((int)src.numRows())));
    }

    public static Frame transpose(Frame src, Frame tgt) {
        if (src.numRows() != (long)tgt.numCols() || (long)src.numCols() != tgt.numRows()) {
            throw new IllegalArgumentException("dimension do not match!");
        }
        for (Vec v2 : src.vecs()) {
            if (v2.isCategorical()) {
                throw new IllegalArgumentException("transpose can only be applied to all-numeric frames (representing a matrix)");
            }
            if (v2.length() <= 1000000L) continue;
            throw new IllegalArgumentException("too many rows, transpose only works for frames with < 1M rows.");
        }
        new TransposeTsk(tgt).doAll(src);
        return tgt;
    }

    public static Frame mmul(Frame x2, Frame y2) {
        MatrixMulTsk t2 = new MatrixMulTsk(null, null, x2, y2);
        if (Thread.currentThread() instanceof H2O.FJWThr) {
            t2.fork().join();
        } else {
            H2O.submitTask(t2).join();
        }
        return t2._z;
    }

    private static class UpdateProgress
    extends TAtomic<MatrixMulStats> {
        final int _chunkSz;
        final int _chunkType;

        public UpdateProgress(int sz, int type) {
            this._chunkSz = sz;
            this._chunkType = type;
        }

        @Override
        public MatrixMulStats atomic(MatrixMulStats old) {
            old.chunkCnts = (long[])old.chunkCnts.clone();
            int j2 = -1;
            for (int i2 = 0; i2 < old.chunkTypes.length; ++i2) {
                if (this._chunkType != old.chunkTypes[i2]) continue;
                j2 = i2;
                break;
            }
            if (j2 == -1) {
                old.chunkTypes = Arrays.copyOf(old.chunkTypes, old.chunkTypes.length + 1);
                old.chunkCnts = Arrays.copyOf(old.chunkCnts, old.chunkCnts.length + 1);
                old.chunkTypes[old.chunkTypes.length - 1] = this._chunkType;
                j2 = old.chunkTypes.length - 1;
            }
            ++old.chunksDone;
            int n2 = j2;
            old.chunkCnts[n2] = old.chunkCnts[n2] + 1L;
            old.lastUpdateAt = System.currentTimeMillis();
            old.size += (long)this._chunkSz;
            return old;
        }
    }

    private static class VecTsk
    extends MRTask<VecTsk> {
        double[] _y;
        Key _progressKey;

        public VecTsk(H2O.H2OCountedCompleter cmp, Key progressKey, double[] y2) {
            super(cmp);
            this._progressKey = progressKey;
            this._y = y2;
        }

        @Override
        public void setupLocal() {
            this._fr.lastVec().preWriting();
        }

        @Override
        public void map(Chunk[] chks) {
            Chunk zChunk = chks[chks.length - 1];
            double[] res = MemoryManager.malloc8d(chks[0]._len);
            for (int i2 = 0; i2 < this._y.length; ++i2) {
                double yVal = this._y[i2];
                Chunk xChunk = chks[i2];
                int k2 = xChunk.nextNZ(-1);
                while (k2 < res.length) {
                    int n2 = k2;
                    res[n2] = res[n2] + yVal * xChunk.atd(k2);
                    k2 = xChunk.nextNZ(k2);
                }
            }
            Chunk modChunk = new NewChunk(res).setSparseRatio(2).compress();
            if (this._progressKey != null) {
                new UpdateProgress(modChunk.getBytes().length, modChunk.frozenType()).fork(this._progressKey);
            }
            DKV.put(zChunk.vec().chunkKey(zChunk.cidx()), modChunk, this._fs);
        }

        @Override
        public void closeLocal() {
            this._y = null;
            this._progressKey = null;
        }
    }

    private static class GetNonZerosTsk
    extends MRTask<GetNonZerosTsk> {
        final int _maxsz;
        int[] _idxs;
        double[] _vals;

        public GetNonZerosTsk(H2O.H2OCountedCompleter cmp) {
            super(cmp);
            this._maxsz = 10000000;
        }

        public GetNonZerosTsk(H2O.H2OCountedCompleter cmp, int maxsz) {
            super(cmp);
            this._maxsz = maxsz;
        }

        @Override
        public void map(Chunk c2) {
            int istart = (int)c2.start();
            assert (c2.start() + (long)c2._len == (long)(istart + c2._len));
            int n2 = c2.sparseLenZero();
            this._idxs = MemoryManager.malloc4(n2);
            this._vals = MemoryManager.malloc8d(n2);
            int j2 = 0;
            int i2 = c2.nextNZ(-1);
            while (i2 < c2._len) {
                this._idxs[j2] = i2 + istart;
                this._vals[j2] = c2.atd(i2);
                i2 = c2.nextNZ(i2);
                ++j2;
            }
            assert (j2 == n2);
            if (this._idxs.length > this._maxsz) {
                throw new RuntimeException("too many nonzeros! found at least " + this._idxs.length + " nonzeros.");
            }
        }

        @Override
        public void reduce(GetNonZerosTsk gnz) {
            if (this._idxs.length + gnz._idxs.length > this._maxsz) {
                throw new RuntimeException("too many nonzeros! found at least " + (this._idxs.length + gnz._idxs.length) + " nonzeros.");
            }
            int[] idxs = MemoryManager.malloc4(this._idxs.length + gnz._idxs.length);
            double[] vals = MemoryManager.malloc8d(this._vals.length + gnz._vals.length);
            ArrayUtils.sortedMerge(this._idxs, this._vals, gnz._idxs, gnz._vals, idxs, vals);
            this._idxs = idxs;
            this._vals = vals;
        }
    }

    public static class MatrixMulTsk
    extends H2O.H2OCountedCompleter {
        final transient Frame _x;
        Frame _y;
        Frame _z;
        final Key _progressKey;
        AtomicInteger _cntr;

        public MatrixMulTsk(H2O.H2OCountedCompleter cmp, Key progressKey, Frame x2, Frame y2) {
            super(cmp);
            if ((long)x2.numCols() != y2.numRows()) {
                throw new IllegalArgumentException("dimensions do not match! x.numcols = " + x2.numCols() + ", y.numRows = " + y2.numRows());
            }
            this._x = x2;
            this._y = y2;
            this._progressKey = progressKey;
        }

        @Override
        public void compute2() {
            this._z = new Frame(this._x.anyVec().makeZeros(this._y.numCols()));
            int total_cores = H2O.CLOUD.size() * H2O.NUMCPUS;
            int chunksPerCol = this._y.anyVec().nChunks();
            int maxP = 256 * total_cores / chunksPerCol;
            Log.info("maxP = " + maxP);
            this._cntr = new AtomicInteger(maxP - 1);
            this.addToPendingCount(2 * this._y.numCols() - 1);
            for (int i2 = 0; i2 < Math.min(this._y.numCols(), maxP); ++i2) {
                this.forkVecTask(i2);
            }
        }

        private void forkVecTask(final int i2) {
            new GetNonZerosTsk(new H2O.H2OCallback<GetNonZerosTsk>((H2O.H2OCountedCompleter)this){

                @Override
                public void callback(GetNonZerosTsk gnz) {
                    new VecTsk(new Callback(), _progressKey, gnz._vals).dfork(ArrayUtils.append(_x.vecs(gnz._idxs), _z.vec(i2)));
                }
            }).dfork(this._y.vec(i2));
        }

        private class Callback
        extends H2O.H2OCallback {
            public Callback() {
                super(MatrixMulTsk.this);
            }

            public void callback(H2O.H2OCountedCompleter h2OCountedCompleter) {
                int i2 = MatrixMulTsk.this._cntr.incrementAndGet();
                if (i2 < MatrixMulTsk.this._y.numCols()) {
                    MatrixMulTsk.this.forkVecTask(i2);
                }
            }
        }
    }

    public static class MatrixMulStats
    extends Iced {
        public final Key jobKey;
        public final long chunksTotal;
        public final long _startTime;
        public long lastUpdateAt;
        public long chunksDone;
        public long size;
        public int[] chunkTypes = new int[0];
        public long[] chunkCnts = new long[0];

        public MatrixMulStats(long n2, Key jobKey) {
            this.chunksTotal = n2;
            this._startTime = System.currentTimeMillis();
            this.jobKey = jobKey;
        }

        public float progress() {
            return (float)((double)this.chunksDone / (double)this.chunksTotal);
        }
    }

    public static class TransposeTsk
    extends MRTask<TransposeTsk> {
        final Frame _tgt;

        public TransposeTsk(Frame tgt) {
            this._tgt = tgt;
        }

        @Override
        public void map(Chunk[] chks) {
            Frame tgt = this._tgt;
            long[] espc = tgt.anyVec().espc();
            int colStart = (int)chks[0].start();
            for (int i2 = 0; i2 < espc.length - 1; ++i2) {
                int j2;
                int fi = i2;
                NewChunk[] tgtChunks = new NewChunk[chks[0]._len];
                for (j2 = 0; j2 < tgtChunks.length; ++j2) {
                    tgtChunks[j2] = new NewChunk(tgt.vec(j2 + colStart), fi);
                }
                for (int c2 = (int)espc[fi]; c2 < (int)espc[fi + 1]; ++c2) {
                    int k2;
                    Chunk nc = chks[c2];
                    if (nc.isSparseZero()) {
                        k2 = nc.nextNZ(-1);
                        while (k2 < nc._len) {
                            tgtChunks[k2].addZeros((int)((long)c2 - espc[fi]) - tgtChunks[k2]._len);
                            nc.extractRows(tgtChunks[k2], k2);
                            k2 = nc.nextNZ(k2);
                        }
                        continue;
                    }
                    for (k2 = 0; k2 < nc._len; ++k2) {
                        tgtChunks[k2].addZeros((int)((long)c2 - espc[fi]) - tgtChunks[k2]._len);
                        nc.extractRows(tgtChunks[k2], k2);
                    }
                }
                j2 = 0;
                while (j2 < tgtChunks.length) {
                    int fj = j2++;
                    tgtChunks[fj].addZeros((int)(espc[fi + 1] - espc[fi]) - tgtChunks[fj]._len);
                    tgtChunks[fj].close(this._fs);
                    tgtChunks[fj] = null;
                }
            }
        }
    }
}

