/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Model;
import java.util.ArrayList;
import java.util.Arrays;
import water.DKV;
import water.H2O;
import water.Iced;
import water.IcedUtils;
import water.Key;
import water.Keyed;
import water.MemoryManager;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.InteractionWrappedVec;
import water.fvec.Vec;
import water.util.ArrayUtils;

public class DataInfo
extends Keyed<DataInfo> {
    public int[] _activeCols;
    public Frame _adaptedFrame;
    public int _responses;
    public TransformType _predictor_transform;
    public TransformType _response_transform;
    public boolean _useAllFactorLevels;
    public int _nums;
    public int _cats;
    public int[] _catOffsets;
    public boolean[] _catMissing;
    private int[] _catNAFill;
    public double[] _numNAFill;
    public int[] _permutation;
    public double[] _normMul;
    public double[] _normSub;
    public double[] _normSigmaStandardizationOff;
    public double[] _normSubStandardizationOff;
    public double[] _normRespMul;
    public double[] _normRespSub;
    public double[] _numMeans;
    public boolean _intercept = true;
    public boolean _offset;
    public boolean _weights;
    public boolean _fold;
    public boolean _treatment;
    public Model.InteractionPair[] _interactions;
    public Model.InteractionSpec _interactionSpec;
    public int[] _interactionVecs;
    public int[] _numOffsets;
    public final boolean _skipMissing;
    public final boolean _imputeMissing;
    public boolean _valid;
    public final int[][] _catLvls;
    public final int[][] _intLvls;
    public String[] _coefNames;
    public int[] _coefOriginalIndices;
    private int[] _fullCatOffsets;
    private int[][] _catMap;

    public Vec setWeights(String name, Vec vec) {
        if (this._weights) {
            return this._adaptedFrame.replace(this.weightChunkId(), vec);
        }
        this._adaptedFrame.insertVec(this.weightChunkId(), name, vec);
        this._weights = true;
        return null;
    }

    public void dropWeights() {
        if (!this._weights) {
            return;
        }
        this._adaptedFrame.remove(this.weightChunkId());
        this._weights = false;
    }

    public void dropInteractions() {
        if (this._interactions != null) {
            Vec[] vecs;
            for (Vec v2 : vecs = this._adaptedFrame.remove(this._interactionVecs)) {
                v2.remove();
            }
            this._interactions = null;
        }
    }

    public int[] activeCols() {
        if (this._activeCols != null) {
            return this._activeCols;
        }
        int[] res = new int[this.fullN() + 1];
        for (int i2 = 0; i2 < res.length; ++i2) {
            res[i2] = i2;
        }
        return res;
    }

    public void addResponse(String[] names, Vec[] vecs) {
        this._adaptedFrame.add(names, vecs);
        this._responses += vecs.length;
    }

    public int[] catNAFill() {
        return this._catNAFill;
    }

    public int catNAFill(int cid) {
        return this._catNAFill[cid];
    }

    public double[] numNAFill() {
        return this._numNAFill;
    }

    public double numNAFill(int nid) {
        return this._numNAFill[nid];
    }

    public void setCatNAFill(int[] catNAFill) {
        this._catNAFill = catNAFill;
    }

    public double normSub(int i2) {
        return this._normSub == null ? 0.0 : this._normSub[i2];
    }

    public double normMul(int i2) {
        return this._normMul == null ? 1.0 : this._normMul[i2];
    }

    public int responseChunkId(int n2) {
        return n2 + this._cats + this._nums + (this._weights ? 1 : 0) + (this._offset ? 1 : 0) + (this._fold ? 1 : 0) + (this._treatment ? 1 : 0);
    }

    public int treatmentChunkId() {
        return this._cats + this._nums + (this._weights ? 1 : 0) + (this._offset ? 1 : 0) + (this._fold ? 1 : 0);
    }

    public int foldChunkId() {
        return this._cats + this._nums + (this._weights ? 1 : 0) + (this._offset ? 1 : 0);
    }

    public int offsetChunkId() {
        return this._cats + this._nums + (this._weights ? 1 : 0);
    }

    public int weightChunkId() {
        return this._cats + this._nums;
    }

    public int outputChunkId() {
        return this.outputChunkId(0);
    }

    public int outputChunkId(int n2) {
        return n2 + this._cats + this._nums + (this._weights ? 1 : 0) + (this._offset ? 1 : 0) + (this._fold ? 1 : 0) + (this._treatment ? 1 : 0) + this._responses;
    }

    public void addOutput(String name, Vec v2) {
        this._adaptedFrame.add(name, v2);
    }

    public Vec getOutputVec(int i2) {
        return this._adaptedFrame.vec(this.outputChunkId(i2));
    }

    public void setResponse(String name, Vec v2) {
        this.setResponse(name, v2, 0);
    }

    public void setResponse(String name, Vec v2, int n2) {
        this._adaptedFrame.insertVec(this.responseChunkId(n2), name, v2);
    }

    private DataInfo() {
        this._intLvls = null;
        this._catLvls = null;
        this._skipMissing = true;
        this._imputeMissing = false;
        this._valid = false;
        this._offset = false;
        this._weights = false;
        this._fold = false;
        this._treatment = false;
    }

    @Override
    protected long checksum_impl() {
        throw H2O.unimpl();
    }

    public DataInfo(Frame train, Frame valid, boolean useAllFactorLevels, TransformType predictor_transform, boolean skipMissing, boolean imputeMissing, boolean missingBucket) {
        this(train, valid, 0, useAllFactorLevels, predictor_transform, TransformType.NONE, skipMissing, imputeMissing, missingBucket, false, false, false, false);
    }

    public DataInfo(Frame train, Frame valid, int nResponses, boolean useAllFactorLevels, TransformType predictor_transform, TransformType response_transform, boolean skipMissing, boolean imputeMissing, boolean missingBucket, boolean weight, boolean offset, boolean fold) {
        this(train, valid, nResponses, useAllFactorLevels, predictor_transform, response_transform, skipMissing, imputeMissing, missingBucket, weight, offset, fold, null);
    }

    public DataInfo(Frame train, Frame valid, int nResponses, boolean useAllFactorLevels, TransformType predictor_transform, TransformType response_transform, boolean skipMissing, boolean imputeMissing, boolean missingBucket, boolean weight, boolean offset, boolean fold, Model.InteractionSpec interactions) {
        this(train, valid, nResponses, useAllFactorLevels, predictor_transform, response_transform, skipMissing, imputeMissing, new MeanImputer(), missingBucket, weight, offset, fold, false, interactions);
    }

    public DataInfo(Frame train, Frame valid, int nResponses, boolean useAllFactorLevels, TransformType predictor_transform, TransformType response_transform, boolean skipMissing, boolean imputeMissing, boolean missingBucket, boolean weight, boolean offset, boolean fold, boolean treatment, Model.InteractionSpec interactions) {
        this(train, valid, nResponses, useAllFactorLevels, predictor_transform, response_transform, skipMissing, imputeMissing, new MeanImputer(), missingBucket, weight, offset, fold, treatment, interactions);
    }

    public DataInfo(Frame train, Frame valid, int nResponses, boolean useAllFactorLevels, TransformType predictor_transform, TransformType response_transform, boolean skipMissing, boolean imputeMissing, Imputer imputer, boolean missingBucket, boolean weight, boolean offset, boolean fold, Model.InteractionSpec interactions) {
        this(train, valid, nResponses, useAllFactorLevels, predictor_transform, response_transform, skipMissing, imputeMissing, imputer, missingBucket, weight, offset, fold, false, interactions);
    }

    public DataInfo(Frame train, Frame valid, int nResponses, boolean useAllFactorLevels, TransformType predictor_transform, TransformType response_transform, boolean skipMissing, boolean imputeMissing, Imputer imputer, boolean missingBucket, boolean weight, boolean offset, boolean fold, boolean treatment, Model.InteractionSpec interactions) {
        super(Key.make());
        int i2;
        int i3;
        int i4;
        assert (predictor_transform != null);
        assert (response_transform != null);
        this._valid = valid != null;
        this._offset = offset;
        this._weights = weight;
        this._fold = fold;
        this._treatment = treatment;
        assert (!skipMissing || !imputeMissing) : "skipMissing and imputeMissing cannot both be true";
        this._skipMissing = skipMissing;
        this._imputeMissing = imputeMissing;
        this._predictor_transform = predictor_transform;
        this._response_transform = response_transform;
        this._responses = nResponses;
        this._useAllFactorLevels = useAllFactorLevels;
        this._interactionSpec = interactions;
        if (interactions != null) {
            train = interactions.reorderColumns(train);
            valid = interactions.reorderColumns(valid);
            this._interactions = interactions.makeInteractionPairs(train);
        }
        if (this._interactions != null) {
            this._interactionVecs = new int[this._interactions.length];
            Frame inter = Model.makeInteractions(train, false, this._interactions, this._useAllFactorLevels, this._skipMissing, predictor_transform == TransformType.STANDARDIZE);
            train = inter.add(this._interactionSpec.removeInteractionOnlyColumns(train));
            if (valid != null) {
                inter = Model.makeInteractions(valid, true, this._interactions, this._useAllFactorLevels, this._skipMissing, predictor_transform == TransformType.STANDARDIZE);
                valid = inter.add(this._interactionSpec.removeInteractionOnlyColumns(valid));
            }
        }
        this._permutation = new int[train.numCols()];
        Vec[] tvecs = train.vecs();
        int n2 = tvecs.length - this._responses - (offset ? 1 : 0) - (weight ? 1 : 0) - (fold ? 1 : 0) - (treatment ? 1 : 0);
        int[] nums = MemoryManager.malloc4(n2);
        int[] cats = MemoryManager.malloc4(n2);
        int nnums = 0;
        int ncats = 0;
        for (i4 = 0; i4 < n2; ++i4) {
            if (tvecs[i4].isCategorical()) {
                cats[ncats++] = i4;
                continue;
            }
            nums[nnums++] = i4;
        }
        this._nums = nnums;
        this._cats = ncats;
        this._catLvls = new int[ncats][];
        for (i4 = 0; i4 < ncats; ++i4) {
            for (int j2 = i4 + 1; j2 < ncats; ++j2) {
                if (tvecs[cats[i4]].domain().length >= tvecs[cats[j2]].domain().length) continue;
                int x2 = cats[i4];
                cats[i4] = cats[j2];
                cats[j2] = x2;
            }
        }
        String[] names = new String[train.numCols()];
        Vec[] tvecs2 = new Vec[train.numCols()];
        this._catNAFill = new int[ncats];
        this._catOffsets = MemoryManager.malloc4(ncats + 1);
        this._catMissing = new boolean[ncats];
        this._catOffsets[0] = 0;
        int len = 0;
        int interactionIdx = 0;
        if (this._interactions == null) {
            ArrayList<Integer> interactionIds = new ArrayList<Integer>();
            for (i3 = 0; i3 < tvecs.length; ++i3) {
                if (!(tvecs[i3] instanceof InteractionWrappedVec)) continue;
                interactionIds.add(i3);
            }
            if (interactionIds.size() > 0) {
                this._interactionVecs = new int[interactionIds.size()];
                for (i3 = 0; i3 < this._interactionVecs.length; ++i3) {
                    this._interactionVecs[i3] = (Integer)interactionIds.get(i3);
                }
            }
        }
        for (i3 = 0; i3 < ncats; ++i3) {
            names[i3] = train._names[cats[i3]];
            Vec v2 = tvecs2[i3] = tvecs[cats[i3]];
            this._catMissing[i3] = missingBucket;
            if (v2 instanceof InteractionWrappedVec) {
                this._interactionVecs[interactionIdx++] = i3;
                this._catOffsets[i3 + 1] = len += v2.domain().length + (missingBucket ? 1 : 0);
            } else {
                this._catOffsets[i3 + 1] = len += v2.domain().length - (useAllFactorLevels ? 0 : 1) + (missingBucket ? 1 : 0);
            }
            this._catNAFill[i3] = imputeMissing ? imputer.imputeCat(names[i3], train.vec(cats[i3]), this._useAllFactorLevels) : (this._catMissing[i3] ? v2.domain().length - (this._useAllFactorLevels || this.isInteractionVec(i3) ? 0 : 1) : -100);
            this._permutation[i3] = cats[i3];
        }
        this._numOffsets = MemoryManager.malloc4(nnums + 1);
        this._numOffsets[0] = len;
        for (int i5 = 0; i5 < nnums; ++i5) {
            Vec v3;
            names[i5 + ncats] = train._names[nums[i5]];
            tvecs2[i5 + ncats] = v3 = train.vec(nums[i5]);
            boolean isIWV = v3 instanceof InteractionWrappedVec;
            if (isIWV) {
                this._interactionVecs[interactionIdx++] = i5 + ncats;
            }
            this._numOffsets[i5 + 1] = len += isIWV ? ((InteractionWrappedVec)v3).expandedLength() : 1;
            this._permutation[i5 + ncats] = nums[i5];
        }
        this._numMeans = new double[this.numNums()];
        this._numNAFill = new double[this.numNums()];
        int numIdx = 0;
        for (i2 = 0; i2 < nnums; ++i2) {
            String name = train.name(nums[i2]);
            Vec v4 = train.vec(nums[i2]);
            if (v4 instanceof InteractionWrappedVec) {
                InteractionWrappedVec iwv = (InteractionWrappedVec)v4;
                int start = iwv._useAllFactorLevels ? 0 : 1;
                int length = iwv.expandedLength();
                double[] means = iwv.getMeans();
                System.arraycopy(means, start, this._numMeans, numIdx, length);
                double[] naFill = imputer.imputeInteraction(name, iwv, means);
                System.arraycopy(naFill, start, this._numNAFill, numIdx, length);
                numIdx += length;
                continue;
            }
            this._numMeans[numIdx] = v4.mean();
            this._numNAFill[numIdx] = imputer.imputeNum(name, v4);
            ++numIdx;
        }
        for (i2 = names.length - nResponses - (weight ? 1 : 0) - (offset ? 1 : 0) - (fold ? 1 : 0) - (treatment ? 1 : 0); i2 < names.length; ++i2) {
            names[i2] = train._names[i2];
            tvecs2[i2] = train.vec(i2);
        }
        this._adaptedFrame = new Frame(names, tvecs2);
        train.restructure(names, tvecs2);
        if (valid != null) {
            valid.restructure(names, valid.vecs(names));
        }
        this.setPredictorTransform(predictor_transform);
        if (this._responses > 0) {
            this.setResponseTransform(response_transform);
        }
        this._intLvls = new int[this._interactionVecs == null ? 0 : this._interactionVecs.length][];
    }

    public DataInfo disableIntercept() {
        this._intercept = false;
        return this;
    }

    public DataInfo(Frame train, Frame valid, int nResponses, boolean useAllFactorLevels, TransformType predictor_transform, TransformType response_transform, boolean skipMissing, boolean imputeMissing, boolean missingBucket, boolean weight, boolean offset, boolean fold, boolean intercept) {
        this(train, valid, nResponses, useAllFactorLevels, predictor_transform, response_transform, skipMissing, imputeMissing, missingBucket, weight, offset, fold);
        this._intercept = intercept;
    }

    public DataInfo validDinfo(Frame valid) {
        DataInfo res = new DataInfo(this._adaptedFrame, null, 1, this._useAllFactorLevels, TransformType.NONE, TransformType.NONE, this._skipMissing, this._imputeMissing, !this._skipMissing && !this._imputeMissing, this._weights, this._offset, this._fold);
        res._interactions = this._interactions;
        res._interactionSpec = this._interactionSpec;
        if (this._interactionSpec != null) {
            valid = Model.makeInteractions(valid, true, this._interactions, this._useAllFactorLevels, this._skipMissing, false).add(valid);
        }
        res._adaptedFrame = new Frame(this._adaptedFrame.names(), valid.vecs(this._adaptedFrame.names()));
        res._valid = true;
        return res;
    }

    public double[] denormalizeBeta(double[] beta) {
        int N2 = this.fullN() + 1;
        assert (beta.length % N2 == 0) : "beta len = " + beta.length + " expected multiple of" + N2;
        int nclasses = beta.length / N2;
        beta = MemoryManager.arrayCopyOf(beta, beta.length);
        if (this._predictor_transform == TransformType.STANDARDIZE) {
            for (int c2 = 0; c2 < nclasses; ++c2) {
                int numoff;
                int off = N2 * c2;
                double norm = 0.0;
                for (int i2 = numoff = this.numStart(); i2 < N2 - 1; ++i2) {
                    double b2 = beta[off + i2] * this._normMul[i2 - numoff];
                    norm += b2 * this._normSub[i2 - numoff];
                    beta[off + i2] = b2;
                }
                int n2 = off + N2 - 1;
                beta[n2] = beta[n2] - norm;
            }
        }
        return beta;
    }

    public double[] normalizeBeta(double[] beta, boolean standardize) {
        int N2 = this.fullN() + 1;
        assert (beta.length % N2 == 0) : "beta len = " + beta.length + " expected multiple of" + N2;
        int nclasses = beta.length / N2;
        beta = MemoryManager.arrayCopyOf(beta, beta.length);
        if (!standardize && this._predictor_transform == TransformType.NONE && this._normSubStandardizationOff != null && this._normSigmaStandardizationOff != null) {
            for (int c2 = 0; c2 < nclasses; ++c2) {
                int numoff;
                int off = N2 * c2;
                double norm = 0.0;
                for (int i2 = numoff = this.numStart(); i2 < N2 - 1; ++i2) {
                    double b2 = beta[off + i2] * this._normSigmaStandardizationOff[i2 - numoff];
                    norm += beta[off + i2] * this._normSubStandardizationOff[i2 - numoff];
                    beta[off + i2] = b2;
                }
                int n2 = off + N2 - 1;
                beta[n2] = beta[n2] + norm;
            }
        }
        return beta;
    }

    protected int[] fullCatOffsets() {
        return this._fullCatOffsets == null ? this._catOffsets : this._fullCatOffsets;
    }

    private DataInfo(DataInfo dinfo, Frame fr, double[] normMul, double[] normSub, int[][] catLevels, int[][] intLvls, int[] catModes, int[] activeCols) {
        int i2;
        this._activeCols = activeCols;
        this._fullCatOffsets = dinfo._catOffsets;
        if (!dinfo._useAllFactorLevels) {
            this._fullCatOffsets = (int[])dinfo._catOffsets.clone();
            for (int i3 = 0; i3 < this._fullCatOffsets.length; ++i3) {
                int n2 = i3;
                this._fullCatOffsets[n2] = this._fullCatOffsets[n2] + i3;
            }
        }
        this._cats = catLevels.length;
        this._catMap = new int[this._cats][];
        this._offset = dinfo._offset;
        this._weights = dinfo._weights;
        this._fold = dinfo._fold;
        this._treatment = dinfo._treatment;
        this._valid = false;
        this._interactions = null;
        ArrayList<Integer> interactionVecs = new ArrayList<Integer>();
        for (i2 = 0; i2 < fr.numCols(); ++i2) {
            if (!(fr.vec(i2) instanceof InteractionWrappedVec)) continue;
            interactionVecs.add(i2);
        }
        if (interactionVecs.size() > 0) {
            this._interactionVecs = new int[interactionVecs.size()];
            for (i2 = 0; i2 < this._interactionVecs.length; ++i2) {
                this._interactionVecs[i2] = (Integer)interactionVecs.get(i2);
            }
        }
        assert (dinfo._predictor_transform != null);
        assert (dinfo._response_transform != null);
        this._predictor_transform = dinfo._predictor_transform;
        this._response_transform = dinfo._response_transform;
        this._skipMissing = dinfo._skipMissing;
        this._imputeMissing = dinfo._imputeMissing;
        this._adaptedFrame = fr;
        this._catOffsets = MemoryManager.malloc4(catLevels.length + 1);
        this._catMissing = new boolean[catLevels.length];
        Arrays.fill(this._catMissing, !dinfo._imputeMissing && !dinfo._skipMissing);
        int s2 = 0;
        for (int i4 = 0; i4 < catLevels.length; ++i4) {
            if (catLevels[i4] != null) {
                this._catMap[i4] = new int[this._adaptedFrame.vec(i4).cardinality()];
                Arrays.fill(this._catMap[i4], -1);
                for (int j2 = 0; j2 < catLevels[i4].length; ++j2) {
                    this._catMap[i4][catLevels[i4][j2]] = j2;
                }
            }
            this._catOffsets[i4] = s2;
            s2 += catLevels[i4].length;
        }
        this._catOffsets[this._catOffsets.length - 1] = s2;
        this._catLvls = catLevels;
        this._intLvls = intLvls;
        this._responses = dinfo._responses;
        this._useAllFactorLevels = true;
        this._normMul = normMul;
        this._normSub = normSub;
        this._catNAFill = catModes;
    }

    public static int imputeCat(Vec v2) {
        return DataInfo.imputeCat(v2, true);
    }

    public static int imputeCat(Vec v2, boolean useAllFactorLevels) {
        if (v2.isCategorical()) {
            if (useAllFactorLevels) {
                return v2.mode();
            }
            long[] bins = v2.bins();
            return ArrayUtils.maxIndex(bins, 0);
        }
        return (int)Math.round(v2.mean());
    }

    public DataInfo filterExpandedColumns(int[] cols) {
        int k2;
        assert (this._activeCols == null);
        assert (this._predictor_transform != null);
        assert (this._response_transform != null);
        if (cols == null) {
            return IcedUtils.deepCopy(this);
        }
        int hasIcpt = cols.length > 0 && cols[cols.length - 1] == this.fullN() ? 1 : 0;
        int i2 = 0;
        int j2 = 0;
        int ignoredCnt = 0;
        int[][] catLvls = new int[this._cats][];
        int[][] intLvls = new int[this._interactionVecs == null ? 0 : this._interactionVecs.length][];
        int[] ignoredCols = MemoryManager.malloc4(this._nums + this._cats);
        if (this._catOffsets != null) {
            int coff;
            int n2 = coff = this._useAllFactorLevels ? 0 : 1;
            while (i2 < cols.length && cols[i2] < this.numStart()) {
                int[] levels = MemoryManager.malloc4(this._catOffsets[j2 + 1] - this._catOffsets[j2]);
                k2 = 0;
                while (i2 < cols.length && cols[i2] < this._catOffsets[j2 + 1]) {
                    levels[k2++] = cols[i2++] - this._catOffsets[j2] + coff;
                }
                if (k2 > 0) {
                    catLvls[j2] = Arrays.copyOf(levels, k2);
                }
                ++j2;
            }
        }
        int[] catModes = this._catNAFill;
        for (int k3 = 0; k3 < catLvls.length; ++k3) {
            if (catLvls[k3] != null) continue;
            ignoredCols[ignoredCnt++] = k3;
        }
        if (ignoredCnt > 0) {
            int[][] cs = new int[this._cats - ignoredCnt][];
            catModes = new int[this._cats - ignoredCnt];
            int y2 = 0;
            for (int c2 = 0; c2 < catLvls.length; ++c2) {
                if (catLvls[c2] == null) continue;
                catModes[y2] = this._catNAFill[c2];
                cs[y2++] = catLvls[c2];
            }
            assert (y2 == cs.length);
            catLvls = cs;
        }
        j2 = 0;
        int prev = 0;
        if (this._interactionVecs != null && this._numOffsets.length > intLvls.length) {
            int k4;
            while (i2 < cols.length && cols[i2] < this._numOffsets[intLvls.length]) {
                int[] lvls = MemoryManager.malloc4(this._numOffsets[j2 + 1] - this._numOffsets[j2]);
                k4 = 0;
                while (i2 < cols.length && cols[i2] < this._numOffsets[j2 + 1]) {
                    lvls[k4++] = cols[i2++] - this._numOffsets[j2];
                }
                if (k4 > 0) {
                    intLvls[j2] = Arrays.copyOf(lvls, k4);
                }
                ++j2;
            }
            int preIgnoredCnt = ignoredCnt;
            for (k4 = 0; k4 < intLvls.length; ++k4) {
                if (null != intLvls[k4]) continue;
                ignoredCols[ignoredCnt++] = k4 + this._cats;
            }
            if (ignoredCnt > preIgnoredCnt) {
                int[][] is = new int[this._interactionVecs.length - (ignoredCnt - preIgnoredCnt)][];
                int y3 = 0;
                for (int[] intLvl : intLvls) {
                    if (intLvl == null) continue;
                    is[y3++] = intLvl;
                }
                intLvls = is;
            }
        }
        j2 = this._interactionVecs == null ? 0 : this._interactionVecs.length;
        prev = j2;
        while (i2 < cols.length && j2 < this._numOffsets.length) {
            int numsToIgnore = cols[i2] - this._numOffsets[j2];
            for (int k5 = 0; k5 < numsToIgnore; ++k5) {
                ignoredCols[ignoredCnt++] = this._cats + prev++;
                ++j2;
            }
            prev = ++j2;
            ++i2;
        }
        for (k2 = prev; k2 < this._nums; ++k2) {
            ignoredCols[ignoredCnt++] = k2 + this._cats;
        }
        Frame f2 = new Frame((String[])this._adaptedFrame.names().clone(), (Vec[])this._adaptedFrame.vecs().clone());
        if (ignoredCnt > 0) {
            f2.remove(Arrays.copyOf(ignoredCols, ignoredCnt));
        }
        assert (catLvls.length <= f2.numCols()) : "cats = " + catLvls.length + " numcols = " + f2.numCols();
        double[] normSub = null;
        double[] normMul = null;
        int id = Arrays.binarySearch(cols, this.numStart());
        if (id < 0) {
            id = -id - 1;
        }
        int nnums = cols.length - id - hasIcpt;
        int off = this.numStart();
        if (this._normSub != null) {
            normSub = new double[nnums];
            for (int k6 = id; k6 < id + nnums; ++k6) {
                normSub[k6 - id] = this._normSub[cols[k6] - off];
            }
        }
        if (this._normMul != null) {
            normMul = new double[nnums];
            for (int k7 = id; k7 < id + nnums; ++k7) {
                normMul[k7 - id] = this._normMul[cols[k7] - off];
            }
        }
        DataInfo dinfo = new DataInfo(this, f2, normMul, normSub, catLvls, intLvls, catModes, cols);
        dinfo._nums = f2.numCols() - dinfo._cats - dinfo._responses - (dinfo._offset ? 1 : 0) - (dinfo._weights ? 1 : 0) - (dinfo._fold ? 1 : 0) - (dinfo._treatment ? 1 : 0);
        dinfo._numMeans = new double[nnums];
        dinfo._numNAFill = new double[nnums];
        int colsSize = id + nnums;
        for (int k8 = id; k8 < colsSize; ++k8) {
            int index1 = k8 - id;
            int index2 = cols[k8] - off;
            dinfo._numMeans[index1] = this._numMeans[index2];
            dinfo._numNAFill[index1] = this._numNAFill[index2];
        }
        return dinfo;
    }

    public void updateWeightedSigmaAndMean(double[] sigmas, double[] mean) {
        int i2;
        int sub = this.numNums() - this._nums;
        if (this._predictor_transform.isSigmaScaled()) {
            if (sigmas.length + sub != this._normMul.length) {
                throw new IllegalArgumentException("Length of sigmas does not match number of scaled columns.");
            }
            for (i2 = 0; i2 < this._normMul.length; ++i2) {
                this._normMul[i2] = i2 < sub ? this._normMul[i2] : (sigmas[i2 - sub] != 0.0 ? 1.0 / sigmas[i2 - sub] : 1.0);
            }
        }
        if (this._predictor_transform.isMeanAdjusted()) {
            if (mean.length + sub != this._normSub.length) {
                throw new IllegalArgumentException("Length of means does not match number of scaled columns.");
            }
            for (i2 = 0; i2 < this._normSub.length; ++i2) {
                this._normSub[i2] = i2 < sub ? this._normSub[i2] : mean[i2 - sub];
            }
        }
    }

    public void updateWeightedSigmaAndMeanForResponse(double[] sigmas, double[] mean) {
        if (this._response_transform.isSigmaScaled()) {
            if (sigmas.length != this._normRespMul.length) {
                throw new IllegalArgumentException("Length of sigmas does not match number of scaled columns.");
            }
            for (int i2 = 0; i2 < sigmas.length; ++i2) {
                this._normRespMul[i2] = sigmas[i2] != 0.0 ? 1.0 / sigmas[i2] : 1.0;
            }
        }
        if (this._response_transform.isMeanAdjusted()) {
            if (mean.length != this._normRespSub.length) {
                throw new IllegalArgumentException("Length of means does not match number of scaled columns.");
            }
            System.arraycopy(mean, 0, this._normRespSub, 0, mean.length);
        }
    }

    private void setTransform(TransformType t2, double[] normMul, double[] normSub, int vecStart, int n2) {
        int idx = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Vec v2 = this._adaptedFrame.vec(vecStart + i2);
            boolean isIWV = v2 instanceof InteractionWrappedVec;
            switch (t2) {
                case STANDARDIZE: {
                    int offset;
                    InteractionWrappedVec iwv;
                    if (isIWV) {
                        iwv = (InteractionWrappedVec)v2;
                        for (offset = 0; offset < iwv.expandedLength(); ++offset) {
                            normMul[idx + offset] = iwv.getMul(offset + (iwv._useAllFactorLevels ? 0 : 1));
                            normSub[idx + offset] = iwv.getSub(offset + (iwv._useAllFactorLevels ? 0 : 1));
                        }
                        break;
                    }
                    normMul[idx] = v2.sigma() != 0.0 ? 1.0 / v2.sigma() : 1.0;
                    normSub[idx] = v2.mean();
                    break;
                }
                case NONE: {
                    int offset;
                    InteractionWrappedVec iwv;
                    if (isIWV) {
                        iwv = (InteractionWrappedVec)v2;
                        for (offset = 0; offset < iwv.expandedLength(); ++offset) {
                            normMul[idx + offset] = iwv.getSigma(offset + (iwv._useAllFactorLevels ? 0 : 1));
                            normSub[idx + offset] = iwv.getSub(offset + (iwv._useAllFactorLevels ? 0 : 1));
                        }
                        break;
                    }
                    normMul[idx] = v2.sigma();
                    normSub[idx] = v2.mean();
                    break;
                }
                case NORMALIZE: {
                    if (isIWV) {
                        throw H2O.unimpl();
                    }
                    normMul[idx] = v2.max() - v2.min() > 0.0 ? 1.0 / (v2.max() - v2.min()) : 1.0;
                    normSub[idx] = v2.mean();
                    break;
                }
                case DEMEAN: {
                    int offset;
                    InteractionWrappedVec iwv;
                    if (isIWV) {
                        iwv = (InteractionWrappedVec)v2;
                        for (offset = 0; offset < iwv.expandedLength(); ++offset) {
                            normSub[idx + offset] = iwv.getMeans()[offset];
                            normMul[idx + offset] = 1.0;
                        }
                        break;
                    }
                    normSub[idx] = v2.mean();
                    normMul[idx] = 1.0;
                    break;
                }
                case DESCALE: {
                    if (isIWV) {
                        throw H2O.unimpl();
                    }
                    normMul[idx] = v2.sigma() != 0.0 ? 1.0 / v2.sigma() : 1.0;
                    normSub[idx] = 0.0;
                    break;
                }
                default: {
                    throw H2O.unimpl();
                }
            }
            assert (!Double.isNaN(normMul[idx]));
            assert (!Double.isNaN(normSub[idx]));
            idx = isIWV ? idx + this.nextNumericIdx(i2) : idx + 1;
        }
    }

    public void setPredictorTransform(TransformType t2) {
        this._predictor_transform = t2;
        if (t2 == TransformType.NONE) {
            this._normMul = null;
            this._normSub = null;
            if (this._adaptedFrame != null) {
                this._normSigmaStandardizationOff = MemoryManager.malloc8d(this.numNums());
                this._normSubStandardizationOff = MemoryManager.malloc8d(this.numNums());
                this.setTransform(t2, this._normSigmaStandardizationOff, this._normSubStandardizationOff, this._cats, this._nums);
            }
        } else {
            this._normMul = MemoryManager.malloc8d(this.numNums());
            this._normSub = MemoryManager.malloc8d(this.numNums());
            this.setTransform(t2, this._normMul, this._normSub, this._cats, this._nums);
        }
    }

    public void setResponseTransform(TransformType t2) {
        this._response_transform = t2;
        if (t2 == TransformType.NONE) {
            this._normRespMul = null;
            this._normRespSub = null;
        } else {
            this._normRespMul = MemoryManager.malloc8d(this._responses);
            this._normRespSub = MemoryManager.malloc8d(this._responses);
            this.setTransform(t2, this._normRespMul, this._normRespSub, this._adaptedFrame.numCols() - this._responses, this._responses);
        }
    }

    public boolean isInteractionVec(int colid) {
        if (null == this._interactions && null == this._interactionVecs) {
            return false;
        }
        if (this._adaptedFrame != null) {
            return this._adaptedFrame.vec(colid) instanceof InteractionWrappedVec;
        }
        return Arrays.binarySearch(this._interactionVecs, colid) >= 0;
    }

    public final int fullN() {
        return this.numNums() + this.numCats();
    }

    public final int largestCat() {
        return this._cats > 0 ? this._catOffsets[1] : 0;
    }

    public final int numStart() {
        return this._catOffsets[this._cats];
    }

    public final int numCats() {
        return this._catOffsets[this._cats];
    }

    public final int numNums() {
        int nnums = 0;
        if (this._numOffsets == null && this._intLvls.length > 0) {
            for (int[] _intLvl : this._intLvls) {
                nnums += _intLvl == null ? 0 : _intLvl.length - 1;
            }
            return nnums + this._nums;
        }
        return this._interactionVecs != null && this._numOffsets != null ? this._numOffsets[this._numOffsets.length - 1] - this.numStart() : this._nums;
    }

    public final int nextNumericIdx(int currentColIdx) {
        if (this._numOffsets == null) {
            if (currentColIdx < this._interactionVecs.length) {
                return this._intLvls[currentColIdx].length;
            }
            return 1;
        }
        if (currentColIdx + 1 >= this._numOffsets.length) {
            return this.fullN() - this._numOffsets[currentColIdx];
        }
        return this._numOffsets[currentColIdx + 1] - this._numOffsets[currentColIdx];
    }

    public final String[] coefNames() {
        int i2;
        if (this._coefNames != null) {
            return this._coefNames;
        }
        int k2 = 0;
        int n2 = this.fullN();
        String[] res = new String[n2];
        Vec[] vecs = this._adaptedFrame.vecs();
        for (i2 = 0; i2 < this._cats; ++i2) {
            InteractionWrappedVec iwv;
            int j2;
            int n3 = j2 = this._useAllFactorLevels || vecs[i2] instanceof InteractionWrappedVec ? 0 : 1;
            while (j2 < vecs[i2].domain().length) {
                int jj = this.getCategoricalId(i2, j2);
                if (jj >= 0) {
                    res[k2++] = this._adaptedFrame._names[i2] + "." + vecs[i2].domain()[j2];
                }
                ++j2;
            }
            if (this._catMissing[i2] && this.getCategoricalId(i2, -1) >= 0) {
                res[k2++] = this._adaptedFrame._names[i2] + ".missing(NA)";
            }
            if (!(vecs[i2] instanceof InteractionWrappedVec) || null == (iwv = (InteractionWrappedVec)vecs[i2]).missingDomains()) continue;
            for (String s2 : iwv.missingDomains()) {
                res[k2++] = s2 + ".missing(NA)";
            }
        }
        if (this._interactions == null) {
            int nums = n2 - k2;
            System.arraycopy(this._adaptedFrame._names, this._cats, res, k2, nums);
        } else {
            for (i2 = 0; i2 <= this._nums && i2 + this._cats < n2 && k2 < n2; ++i2) {
                InteractionWrappedVec v2;
                if (vecs[i2 + this._cats] instanceof InteractionWrappedVec && (v2 = (InteractionWrappedVec)vecs[i2 + this._cats]).domain() != null) {
                    int j3;
                    int n4 = j3 = v2._useAllFactorLevels ? 0 : 1;
                    while (j3 < v2.domain().length) {
                        if (this.getCategoricalIdFromInteraction(this._cats + i2, j3) >= 0) {
                            res[k2++] = this._adaptedFrame._names[i2 + this._cats] + "." + v2.domain()[j3];
                        }
                        ++j3;
                    }
                    continue;
                }
                res[k2++] = this._adaptedFrame._names[i2 + this._cats];
            }
        }
        this._coefNames = res;
        return res;
    }

    public final int[] coefOriginalColumnIndices() {
        int i2;
        if (this._coefOriginalIndices != null) {
            return this._coefOriginalIndices;
        }
        int k2 = 0;
        int n2 = this.fullN();
        int[] res = new int[n2];
        Vec[] vecs = this._adaptedFrame.vecs();
        for (i2 = 0; i2 < this._cats; ++i2) {
            InteractionWrappedVec iwv;
            int j2;
            int n3 = j2 = this._useAllFactorLevels || vecs[i2] instanceof InteractionWrappedVec ? 0 : 1;
            while (j2 < vecs[i2].domain().length) {
                int jj = this.getCategoricalId(i2, j2);
                if (jj >= 0) {
                    res[k2++] = i2;
                }
                ++j2;
            }
            if (this._catMissing[i2] && this.getCategoricalId(i2, -1) >= 0) {
                res[k2++] = i2;
            }
            if (!(vecs[i2] instanceof InteractionWrappedVec) || null == (iwv = (InteractionWrappedVec)vecs[i2]).missingDomains()) continue;
            for (String s2 : iwv.missingDomains()) {
                res[k2++] = i2;
            }
        }
        if (this._interactions == null) {
            int index = this._cats;
            for (int i3 = k2; i3 < n2; ++i3) {
                res[i3] = index++;
            }
        } else {
            for (i2 = 0; i2 <= this._nums && i2 + this._cats < n2 && k2 < n2; ++i2) {
                InteractionWrappedVec v2;
                if (vecs[i2 + this._cats] instanceof InteractionWrappedVec && (v2 = (InteractionWrappedVec)vecs[i2 + this._cats]).domain() != null) {
                    int j3;
                    int n4 = j3 = v2._useAllFactorLevels ? 0 : 1;
                    while (j3 < v2.domain().length) {
                        if (this.getCategoricalIdFromInteraction(this._cats + i2, j3) >= 0) {
                            res[k2++] = i2 + this._cats;
                        }
                        ++j3;
                    }
                    continue;
                }
                res[k2++] = i2 + this._cats;
            }
        }
        this._coefOriginalIndices = res;
        return res;
    }

    public final String[] coefOriginalNames() {
        int[] coefOriginalIndices = this.coefOriginalColumnIndices();
        String[] originalNames = new String[coefOriginalIndices[coefOriginalIndices.length - 1]];
        int i2 = 0;
        for (int j2 = 0; i2 < coefOriginalIndices.length && j2 < originalNames.length; ++j2) {
            ArrayList<Integer> coefOriginalIndicesList = new ArrayList<Integer>(coefOriginalIndices.length);
            for (int value : coefOriginalIndices) {
                coefOriginalIndicesList.add(value);
            }
            int end = coefOriginalIndicesList.lastIndexOf(coefOriginalIndices[i2]);
            String prefix = ArrayUtils.findLongestCommonPrefix(Arrays.copyOfRange(this.coefNames(), i2, end + 1));
            if (".".equals(prefix.substring(prefix.length() - 1))) {
                prefix = prefix.substring(0, prefix.length() - 1);
            }
            originalNames[j2] = prefix;
            i2 = end + 1;
        }
        return originalNames;
    }

    public int[] mapNames(String[] names) {
        assert (names.length == this._adaptedFrame._names.length) : "Names must be the same length!";
        int[] idx = new int[names.length];
        Arrays.fill(idx, -1);
        block0: for (int i2 = 0; i2 < this._adaptedFrame._names.length; ++i2) {
            for (int j2 = 0; j2 < names.length; ++j2) {
                if (!names[j2].equals(this._adaptedFrame.name(i2))) continue;
                idx[i2] = j2;
                continue block0;
            }
        }
        return idx;
    }

    public final void unScaleNumericals(double[] in, double[] out) {
        if (this._nums == 0) {
            return;
        }
        assert (in.length == out.length);
        assert (in.length == this.fullN());
        for (int k2 = this.numStart(); k2 < this.fullN(); ++k2) {
            double m4 = this._normMul == null ? 1.0 : this._normMul[k2 - this.numStart()];
            double s2 = this._normSub == null ? 0.0 : this._normSub[k2 - this.numStart()];
            out[k2] = in[k2] / m4 + s2;
        }
    }

    public final int getCategoricalId(int cid, double val) {
        if (Double.isNaN(val)) {
            return this.getCategoricalId(cid, -1);
        }
        int ival = (int)val;
        if ((double)ival != val) {
            throw new IllegalArgumentException("Categorical id must be an integer or NA (missing).");
        }
        return this.getCategoricalId(cid, ival);
    }

    public final int getCategoricalId(int cid, int val) {
        boolean isIWV = this.isInteractionVec(cid);
        if (val == -1) {
            val = isIWV && !this._useAllFactorLevels ? this._catNAFill[cid] - 1 : this._catNAFill[cid];
        }
        if (!this._useAllFactorLevels && !isIWV) {
            --val;
        }
        if (val < 0) {
            return -1;
        }
        int[] offs = this.fullCatOffsets();
        int expandedVal = val + offs[cid];
        if (expandedVal >= offs[cid + 1]) {
            assert (isIWV && !this._useAllFactorLevels || this._valid) : "Categorical value out of bounds, got " + val + ", next cat starts at " + this.fullCatOffsets()[cid + 1];
            if (this._skipMissing) {
                return -1;
            }
            val = this._catNAFill[cid];
            if (!this._useAllFactorLevels && !isIWV) {
                --val;
            }
        }
        if (this._catMap != null && this._catMap[cid] != null) {
            val = this._catMap[cid][val];
            assert (this._useAllFactorLevels);
        }
        return val < 0 ? -1 : val + this._catOffsets[cid];
    }

    public final int getCategoricalIdFromInteraction(int cid, int val) {
        InteractionWrappedVec v2 = (InteractionWrappedVec)this._adaptedFrame.vec(cid);
        if (v2.isCategorical()) {
            return this.getCategoricalId(cid, val);
        }
        assert (v2.domain() != null) : "No domain levels found for interactions! cid: " + cid + " val: " + val;
        cid -= this._cats;
        if (!v2._useAllFactorLevels) {
            --val;
        }
        assert (val >= 0);
        if (val >= this._numOffsets[cid + 1]) {
            assert (this._valid) : "interaction value out of bounds, got " + val + ", next cat starts at " + this._numOffsets[cid + 1];
            val = v2.mode();
        }
        if (cid < this._intLvls.length && this._intLvls[cid] != null) {
            assert (this._useAllFactorLevels);
            val = Arrays.binarySearch(this._intLvls[cid], val);
        }
        return val < 0 ? -1 : val + this._numOffsets[cid];
    }

    public final Row extractDenseRow(Chunk[] chunks, int rid, Row row) {
        int i2;
        int i3;
        row.predictors_bad = false;
        row.response_bad = false;
        row.rid = (long)rid + chunks[0].start();
        row.cid = rid;
        if (this._weights) {
            row.weight = chunks[this.weightChunkId()].atd(rid);
        }
        if (row.weight == 0.0) {
            return row;
        }
        if (this._skipMissing) {
            int N2 = this._cats + this._nums;
            for (i3 = 0; i3 < N2; ++i3) {
                if (!chunks[i3].isNA(rid)) continue;
                row.predictors_bad = true;
                return row;
            }
        }
        int nbins = 0;
        for (i3 = 0; i3 < this._cats; ++i3) {
            int cid = this.getCategoricalId(i3, chunks[i3].isNA(rid) ? this._catNAFill[i3] : (int)chunks[i3].at8(rid));
            if (cid < 0) continue;
            row.binIds[nbins++] = cid;
        }
        row.nBins = nbins;
        int n2 = this._nums;
        int numValsIdx = 0;
        for (i2 = 0; i2 < n2; ++i2) {
            if (this.isInteractionVec(this._cats + i2)) {
                InteractionWrappedVec iwv = (InteractionWrappedVec)this._adaptedFrame.vec(this._cats + i2);
                int interactionOffset = this.getInteractionOffset(chunks, this._cats + i2, rid);
                for (int offset = 0; offset < iwv.expandedLength(); ++offset) {
                    if (i2 < this._intLvls.length && this._intLvls[i2] != null && Arrays.binarySearch(this._intLvls[i2], offset) < 0) continue;
                    double d2 = 0.0;
                    if (offset == interactionOffset) {
                        d2 = chunks[this._cats + i2].atd(rid);
                    }
                    if (Double.isNaN(d2)) {
                        d2 = this._numNAFill[numValsIdx];
                    }
                    if (this._normMul != null && this._normSub != null) {
                        d2 = (d2 - this._normSub[numValsIdx]) * this._normMul[numValsIdx];
                    }
                    row.numVals[numValsIdx++] = d2;
                }
                continue;
            }
            double d3 = chunks[this._cats + i2].atd(rid);
            if (Double.isNaN(d3)) {
                d3 = this._numNAFill[numValsIdx];
            }
            if (this._normMul != null && this._normSub != null) {
                d3 = (d3 - this._normSub[numValsIdx]) * this._normMul[numValsIdx];
            }
            row.numVals[numValsIdx++] = d3;
        }
        for (i2 = 0; i2 < this._responses; ++i2) {
            row.response[i2] = chunks[this.responseChunkId(i2)].atd(rid);
            if (Double.isNaN(row.response[i2])) {
                row.response_bad = true;
                break;
            }
            if (this._normRespMul == null) continue;
            row.response[i2] = (row.response[i2] - this._normRespSub[i2]) * this._normRespMul[i2];
        }
        if (this._offset) {
            row.offset = chunks[this.offsetChunkId()].atd(rid);
        }
        return row;
    }

    public int getInteractionOffset(Chunk[] chunks, int cid, int rid) {
        boolean useAllFactors = ((InteractionWrappedVec)chunks[cid].vec())._useAllFactorLevels;
        InteractionWrappedVec.InteractionWrappedChunk c2 = (InteractionWrappedVec.InteractionWrappedChunk)chunks[cid];
        if (c2._c1IsCat) {
            if (!c2._c[0].isNA(rid)) {
                return (int)c2._c[0].at8(rid) - (useAllFactors ? 0 : 1);
            }
            return c2._c[0].vec().mode() - (useAllFactors ? 0 : 1);
        }
        if (c2._c2IsCat) {
            if (!c2._c[1].isNA(rid)) {
                return (int)c2._c[1].at8(rid) - (useAllFactors ? 0 : 1);
            }
            return c2._c[1].vec().mode() - (useAllFactors ? 0 : 1);
        }
        return 0;
    }

    public Vec getWeightsVec() {
        return this._adaptedFrame.vec(this.weightChunkId());
    }

    public Vec getOffsetVec() {
        return this._adaptedFrame.vec(this.offsetChunkId());
    }

    public Row newDenseRow() {
        return new Row(false, this.numNums(), this._cats, this._responses, 0, 0L);
    }

    public Row newDenseRow(double[] numVals, long start) {
        return new Row(false, numVals, null, null, 0, start);
    }

    public Rows rows(Chunk[] chks) {
        int cnt = 0;
        for (Chunk c2 : chks) {
            if (!c2.isSparseZero()) continue;
            ++cnt;
        }
        return this.rows(chks, cnt > chks.length >> 1);
    }

    public Rows rows(Chunk[] chks, boolean sparse) {
        return new Rows(chks, sparse);
    }

    public final Row[] extractSparseRows(Chunk[] chunks) {
        int i2;
        Row[] rows = new Row[chunks[0]._len];
        long startOff = chunks[0].start();
        for (i2 = 0; i2 < rows.length; ++i2) {
            rows[i2] = new Row(true, Math.min(this._nums, 16), this._cats, this._responses, i2, startOff);
            rows[i2].rid = chunks[0].start() + (long)i2;
            if (this._offset) {
                rows[i2].offset = chunks[this.offsetChunkId()].atd(i2);
                if (Double.isNaN(rows[i2].offset)) {
                    rows[i2].predictors_bad = true;
                    continue;
                }
            }
            if (!this._weights) continue;
            rows[i2].weight = chunks[this.weightChunkId()].atd(i2);
            if (!Double.isNaN(rows[i2].weight)) continue;
            rows[i2].predictors_bad = true;
        }
        for (i2 = 0; i2 < this._cats; ++i2) {
            for (int r2 = 0; r2 < chunks[0]._len; ++r2) {
                Row row = rows[r2];
                boolean isMissing = chunks[i2].isNA(r2);
                if (this._skipMissing && isMissing) {
                    row.predictors_bad = true;
                    continue;
                }
                int cid = this.getCategoricalId(i2, isMissing ? -1 : (int)chunks[i2].at8(r2));
                if (cid < 0) continue;
                row.binIds[row.nBins++] = cid;
            }
        }
        int interactionOffset = 0;
        for (int cid = 0; cid < this._nums; ++cid) {
            Chunk c2 = chunks[this._cats + cid];
            int oldRow = -1;
            if (c2 instanceof InteractionWrappedVec.InteractionWrappedChunk) {
                InteractionWrappedVec iwv = (InteractionWrappedVec)c2.vec();
                for (int r3 = 0; r3 < c2._len; ++r3) {
                    int cidVirtualOffset;
                    Row row = rows[r3];
                    if (c2.isNA(r3) && this._skipMissing) {
                        row.predictors_bad = true;
                    }
                    if (row.predictors_bad || (cidVirtualOffset = this.getInteractionOffset(chunks, this._cats + cid, r3)) < 0 || cid < this._intLvls.length && this._intLvls[cid] != null && Arrays.binarySearch(this._intLvls[cid], cidVirtualOffset) < 0 || c2.atd(r3) == 0.0) continue;
                    double d2 = c2.atd(r3);
                    if (Double.isNaN(d2)) {
                        d2 = this._numNAFill[interactionOffset + cidVirtualOffset];
                    }
                    if (this._normMul != null) {
                        d2 *= this._normMul[interactionOffset + cidVirtualOffset];
                    }
                    row.addNum(this.numStart() + interactionOffset + cidVirtualOffset, d2);
                }
                interactionOffset += this.nextNumericIdx(cid);
                continue;
            }
            int r4 = c2.nextNZ(-1, this._imputeMissing);
            while (r4 < c2._len) {
                if (c2.atd(r4) != 0.0) {
                    assert (r4 > oldRow);
                    oldRow = r4;
                    Row row = rows[r4];
                    if (c2.isNA(r4) && this._skipMissing) {
                        row.predictors_bad = true;
                    }
                    if (!row.predictors_bad) {
                        double d3 = c2.atd(r4);
                        if (Double.isNaN(d3)) {
                            d3 = this._numNAFill[cid];
                        }
                        if (this._normMul != null) {
                            d3 *= this._normMul[interactionOffset];
                        }
                        row.addNum(this.numStart() + interactionOffset, d3);
                    }
                }
                r4 = c2.nextNZ(r4, this._imputeMissing);
            }
            ++interactionOffset;
        }
        for (int i3 = 1; i3 <= this._responses; ++i3) {
            int rid = this.responseChunkId(i3 - 1);
            Chunk rChunk = chunks[rid];
            for (int r5 = 0; r5 < chunks[0]._len; ++r5) {
                Row row = rows[r5];
                row.response[i3 - 1] = rChunk.atd(r5);
                if (Double.isNaN(row.response[i3 - 1])) {
                    row.response_bad = true;
                }
                if (this._normRespMul == null) continue;
                row.response[i3 - 1] = (row.response[i3 - 1] - this._normRespSub[i3 - 1]) * this._normRespMul[i3 - 1];
            }
        }
        return rows;
    }

    public DataInfo scoringInfo(String[] names, Frame adaptFrame) {
        return this.scoringInfo(names, adaptFrame, -1, true);
    }

    public DataInfo scoringInfo(String[] names, Frame adaptFrame, int nResponses, boolean fixIVW) {
        int resId;
        DataInfo res = IcedUtils.deepCopy(this);
        res._normMul = null;
        res._normRespSub = null;
        res._normRespMul = null;
        res._normRespSub = null;
        res._predictor_transform = TransformType.NONE;
        res._response_transform = TransformType.NONE;
        res._adaptedFrame = adaptFrame;
        res._weights = this._weights && adaptFrame.find(names[this.weightChunkId()]) != -1;
        res._offset = this._offset && adaptFrame.find(names[this.offsetChunkId()]) != -1;
        res._fold = this._fold && adaptFrame.find(names[this.foldChunkId()]) != -1;
        boolean bl = res._treatment = this._treatment && adaptFrame.find(names[this.treatmentChunkId()]) != -1;
        res._responses = nResponses != -1 ? nResponses : ((resId = adaptFrame.find(names[this.responseChunkId(0)])) == -1 || adaptFrame.vec(resId).isBad() ? 0 : 1);
        res._valid = true;
        res._interactions = this._interactions;
        res._interactionSpec = this._interactionSpec;
        if (fixIVW) {
            for (Vec v2 : res._adaptedFrame.vecs()) {
                if (!(v2 instanceof InteractionWrappedVec)) continue;
                ((InteractionWrappedVec)v2)._useAllFactorLevels = this._useAllFactorLevels;
                ((InteractionWrappedVec)v2)._skipMissing = this._skipMissing;
                DKV.put(v2);
            }
        }
        return res;
    }

    public DataInfo scoringInfo() {
        DataInfo res = IcedUtils.deepCopy(this);
        res._valid = true;
        return res;
    }

    public static class MeanImputer
    implements Imputer {
        @Override
        public int imputeCat(String name, Vec v2, boolean useAllFactorLevels) {
            return DataInfo.imputeCat(v2, useAllFactorLevels);
        }

        @Override
        public double imputeNum(String name, Vec v2) {
            return v2.mean();
        }

        @Override
        public double[] imputeInteraction(String name, InteractionWrappedVec iv, double[] means) {
            return means;
        }
    }

    public static interface Imputer {
        public int imputeCat(String var1, Vec var2, boolean var3);

        public double imputeNum(String var1, Vec var2);

        public double[] imputeInteraction(String var1, InteractionWrappedVec var2, double[] var3);
    }

    public final class Rows {
        public final int _nrows;
        private final Row _denseRow;
        private final Row[] _sparseRows;
        public final boolean _sparse;
        private final Chunk[] _chks;

        private Rows(Chunk[] chks, boolean sparse) {
            this._nrows = chks[0]._len;
            this._sparse = sparse;
            long start = chks[0].start();
            if (sparse) {
                this._denseRow = null;
                this._chks = null;
                this._sparseRows = DataInfo.this.extractSparseRows(chks);
            } else {
                this._denseRow = DataInfo.this.newDenseRow();
                this._chks = chks;
                this._sparseRows = null;
            }
        }

        public Row row(int i2) {
            return this._sparse ? this._sparseRows[i2] : DataInfo.this.extractDenseRow(this._chks, i2, this._denseRow);
        }
    }

    public final class Row
    extends Iced {
        public boolean predictors_bad;
        public boolean response_bad;
        public double[] numVals;
        public double[] response;
        public int[] numIds;
        public int[] binIds;
        public long rid;
        public int cid;
        public int nBins;
        public int nNums;
        public double offset = 0.0;
        public double weight = 1.0;

        public boolean isBad() {
            return this.predictors_bad || this.response_bad;
        }

        public final boolean isSparse() {
            return this.numIds != null;
        }

        public double[] mtrxMul(double[][] m4, double[] res) {
            for (int i2 = 0; i2 < m4.length; ++i2) {
                res[i2] = this.innerProduct(m4[i2], false);
            }
            return res;
        }

        public Row(boolean sparse, int nNums, int nBins, int nresponses, int i2, long start) {
            this.binIds = MemoryManager.malloc4(nBins);
            this.numVals = MemoryManager.malloc8d(nNums);
            this.response = MemoryManager.malloc8d(nresponses);
            if (sparse) {
                this.numIds = MemoryManager.malloc4(nNums);
            }
            this.nNums = sparse ? 0 : nNums;
            this.cid = i2;
            this.rid = start + (long)i2;
        }

        public Row(boolean sparse, double[] numVals, int[] binIds, double[] response, int i2, long start) {
            int nNums = numVals == null ? 0 : numVals.length;
            this.numVals = numVals;
            if (sparse) {
                this.numIds = MemoryManager.malloc4(nNums);
            }
            this.nNums = sparse ? 0 : nNums;
            this.nBins = binIds == null ? 0 : binIds.length;
            this.binIds = binIds;
            this.response = response;
            this.cid = i2;
            this.rid = start + (long)i2;
        }

        public Row(double[] nums) {
            this.numVals = nums;
            this.nNums = nums.length;
        }

        public double response(int i2) {
            return this.response[i2];
        }

        public double get(int i2) {
            int off = DataInfo.this.numStart();
            if (i2 >= off) {
                if (this.numIds == null) {
                    return this.numVals[i2 - off];
                }
                int j2 = Arrays.binarySearch(this.numIds, 0, this.nNums, i2);
                return j2 >= 0 ? this.numVals[j2] : 0.0;
            }
            int j3 = Arrays.binarySearch(this.binIds, 0, this.nBins, i2);
            return j3 >= 0 ? 1.0 : 0.0;
        }

        public void addNum(int id, double val) {
            if (this.numIds.length == this.nNums) {
                int newSz = Math.max(4, this.numIds.length + (this.numIds.length >> 1));
                this.numIds = Arrays.copyOf(this.numIds, newSz);
                this.numVals = Arrays.copyOf(this.numVals, newSz);
            }
            int i2 = this.nNums++;
            this.numIds[i2] = id;
            this.numVals[i2] = val;
        }

        public final double dotSame(Row rowj) {
            double elementij = 0.0;
            for (int i2 = 0; i2 < this.nNums; ++i2) {
                elementij += this.numVals[i2] * rowj.numVals[i2];
            }
            if (this.binIds.length > 0) {
                for (int j2 = 0; j2 < this.nBins; ++j2) {
                    if (this.binIds[j2] != rowj.binIds[j2]) continue;
                    elementij += 1.0;
                }
            }
            return elementij * this.weight * rowj.weight;
        }

        public final double innerProduct(double[] vec) {
            return this.innerProduct(vec, false);
        }

        public final double innerProduct(double[] vec, boolean icptFirst) {
            int i2;
            double res = 0.0;
            int off = 0;
            if (icptFirst) {
                off = 1;
                res = vec[0];
            }
            int numStart = off + DataInfo.this.numStart();
            for (i2 = 0; i2 < this.nBins; ++i2) {
                res += vec[off + this.binIds[i2]];
            }
            if (this.numIds == null) {
                for (i2 = 0; i2 < this.numVals.length; ++i2) {
                    res += this.numVals[i2] * vec[numStart + i2];
                }
            } else {
                for (i2 = 0; i2 < this.nNums; ++i2) {
                    res += this.numVals[i2] * vec[off + this.numIds[i2]];
                }
            }
            if (DataInfo.this._intercept && !icptFirst) {
                res += vec[vec.length - 1];
            }
            return res;
        }

        public final double innerProduct(Row row) {
            int i2;
            assert (!DataInfo.this._intercept);
            assert (this.numIds == null);
            double res = 0.0;
            for (i2 = 0; i2 < this.nBins; ++i2) {
                if (this.binIds[i2] != row.binIds[i2]) continue;
                res += 1.0;
            }
            for (i2 = 0; i2 < this.numVals.length; ++i2) {
                res += this.numVals[i2] * row.numVals[i2];
            }
            return res;
        }

        public double[] scalarProduct(double w2, double[] rowContent, int catOffsets) {
            int i2;
            rowContent[0] = w2;
            for (i2 = 0; i2 < this.nBins; ++i2) {
                rowContent[this.binIds[i2] + 1] = w2;
            }
            for (i2 = 0; i2 < this.numVals.length; ++i2) {
                int n2 = i2 + catOffsets + 1;
                rowContent[n2] = rowContent[n2] + this.numVals[i2] * w2;
            }
            return rowContent;
        }

        public final double twoNormSq() {
            assert (!DataInfo.this._intercept);
            assert (this.numIds == null);
            double res = this.nBins;
            for (double v2 : this.numVals) {
                res += v2 * v2;
            }
            return res;
        }

        public double[] expandCats() {
            int i2;
            if (this.isSparse() || DataInfo.this._responses > 0) {
                throw H2O.unimpl();
            }
            int N2 = DataInfo.this.fullN();
            int numStart = DataInfo.this.numStart();
            double[] res = new double[N2 + (DataInfo.this._intercept ? 1 : 0)];
            for (i2 = 0; i2 < this.nBins; ++i2) {
                res[this.binIds[i2]] = 1.0;
            }
            if (this.numIds == null) {
                System.arraycopy(this.numVals, 0, res, numStart, this.numVals.length);
            } else {
                for (i2 = 0; i2 < this.nNums; ++i2) {
                    res[this.numIds[i2]] = this.numVals[i2];
                }
            }
            if (DataInfo.this._intercept) {
                res[res.length - 1] = 1.0;
            }
            return res;
        }

        public String toString() {
            return this.rid + Arrays.toString(Arrays.copyOf(this.binIds, this.nBins)) + ", " + Arrays.toString(this.numVals);
        }

        public void setResponse(int i2, double z2) {
            this.response[i2] = z2;
        }

        public void standardize(double[] normSub, double[] normMul) {
            if (this.numIds == null) {
                for (int i2 = 0; i2 < this.numVals.length; ++i2) {
                    this.numVals[i2] = (this.numVals[i2] - normSub[i2]) * normMul[i2];
                }
            } else {
                for (int i3 = 0; i3 < this.nNums; ++i3) {
                    int j2 = this.numIds[i3];
                    this.numVals[i3] = (this.numVals[i3] - normSub[j2]) * normMul[j2];
                }
            }
        }

        public Row deepClone() {
            Row cloned = (Row)this.clone();
            cloned.numVals = (double[])this.numVals.clone();
            if (this.numIds != null) {
                cloned.numIds = (int[])this.numIds.clone();
            }
            cloned.response = (double[])this.response.clone();
            cloned.binIds = (int[])this.binIds.clone();
            return cloned;
        }

        public void addToArray(double scale, double[] res) {
            for (int i2 = 0; i2 < this.nBins; ++i2) {
                int n2 = this.binIds[i2];
                res[n2] = res[n2] + scale;
            }
            int numstart = DataInfo.this.numStart();
            if (this.numIds != null) {
                for (int i3 = 0; i3 < this.nNums; ++i3) {
                    int n3 = this.numIds[i3];
                    res[n3] = res[n3] + scale * this.numVals[i3];
                }
            } else {
                for (int i4 = 0; i4 < this.numVals.length; ++i4) {
                    if (this.numVals[i4] == 0.0) continue;
                    int n4 = numstart + i4;
                    res[n4] = res[n4] + scale * this.numVals[i4];
                }
            }
            if (DataInfo.this._intercept) {
                int n5 = res.length - 1;
                res[n5] = res[n5] + scale;
            }
        }
    }

    public static enum TransformType {
        NONE,
        STANDARDIZE,
        NORMALIZE,
        DEMEAN,
        DESCALE;


        public boolean isMeanAdjusted() {
            switch (this) {
                case NONE: 
                case DESCALE: 
                case NORMALIZE: {
                    return false;
                }
                case STANDARDIZE: 
                case DEMEAN: {
                    return true;
                }
            }
            throw H2O.unimpl();
        }

        public boolean isSigmaScaled() {
            switch (this) {
                case NONE: 
                case NORMALIZE: 
                case DEMEAN: {
                    return false;
                }
                case DESCALE: 
                case STANDARDIZE: {
                    return true;
                }
            }
            throw H2O.unimpl();
        }
    }
}

