/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.TransformFoldAssignment;
import java.util.Arrays;
import water.Iced;
import water.Key;
import water.exceptions.H2OIllegalArgumentException;
import water.fvec.Frame;
import water.fvec.Vec;
import water.util.ArrayUtils;
import water.util.VecUtils;

public class FoldAssignment
extends Iced<FoldAssignment> {
    protected final Vec _fold;

    FoldAssignment(Vec fold) {
        this._fold = fold;
    }

    Frame toFrame(Key<Frame> key) {
        return new Frame(key, new String[]{"fold_assignment"}, new Vec[]{this._fold});
    }

    Vec getAdaptedFold() {
        return this._fold;
    }

    void remove(boolean keepOriginalFold) {
        if (!keepOriginalFold) {
            this._fold.remove();
        }
    }

    static FoldAssignment fromUserFoldSpecification(int N2, Vec fold) {
        int[] foldValues = FoldAssignment.findActualFoldValues(fold);
        if (!(fold.isCategorical() || fold.isInt() && foldValues.length == N2 && (fold.min() == 0.0 && fold.max() == (double)(N2 - 1) || fold.min() == 1.0 && fold.max() == (double)N2))) {
            throw new H2OIllegalArgumentException("Fold column must be either categorical or contiguous integers from 0..N-1 or 1..N");
        }
        return new TransformFoldAssignment(fold, foldValues);
    }

    static FoldAssignment fromInternalFold(int N2, Vec fold) {
        assert (fold.isInt());
        assert (fold.min() == 0.0 && fold.max() == (double)(N2 - 1));
        return new FoldAssignment(fold);
    }

    static int nFoldWork(Vec fold) {
        return FoldAssignment.findActualFoldValues(fold).length;
    }

    static int[] findActualFoldValues(Vec f2) {
        Object[] actualDomain;
        Vec fc = VecUtils.toCategoricalVec(f2);
        try {
            actualDomain = !f2.isCategorical() ? fc.domain() : VecUtils.collectDomainFast(fc);
        }
        finally {
            fc.remove();
        }
        int N2 = actualDomain.length;
        if (Arrays.equals(actualDomain, fc.domain())) {
            int offset = f2.isCategorical() ? 0 : (int)f2.min();
            return ArrayUtils.seq(offset, N2 + offset);
        }
        int[] mapping = new int[N2];
        String[] fullDomain = fc.domain();
        for (int i2 = 0; i2 < N2; ++i2) {
            int pos = ArrayUtils.find(fullDomain, actualDomain[i2]);
            assert (pos >= 0);
            mapping[i2] = pos;
        }
        return mapping;
    }
}

