/*
 * Decompiled with CFR 0.152.
 */
package hex;

import java.util.Arrays;
import jsr166y.CountedCompleter;
import water.ChunkSplitter;
import water.Futures;
import water.H2O;
import water.Job;
import water.Key;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.Vec;

public class FrameSplitter
extends H2O.H2OCountedCompleter<FrameSplitter> {
    final Frame dataset;
    final double[] ratios;
    final Key<Frame>[] destKeys;
    final Key<Job> jobKey;
    private Frame[] splits;

    public FrameSplitter(Frame dataset, double[] ratios, Key<Frame>[] destKeys, Key<Job> jobKey) {
        this(null, dataset, ratios, destKeys, jobKey);
    }

    public FrameSplitter(H2O.H2OCountedCompleter cc, Frame dataset, double[] ratios, Key<Frame>[] destKeys, Key<Job> jobKey) {
        super(cc);
        assert (ratios.length > 0) : "No ratio specified!";
        assert (ratios.length < 100) : "Too many frame splits demanded!";
        assert (destKeys != null) : "Destination keys are not specified!";
        assert (destKeys.length == ratios.length + 1) : "Unexpected number of destination keys.";
        this.dataset = dataset;
        this.ratios = ratios;
        this.jobKey = jobKey;
        this.destKeys = destKeys;
    }

    @Override
    public void compute2() {
        int s2;
        this.dataset.read_lock(this.jobKey);
        Vec[][] templates = this.makeTemplates(this.dataset, this.ratios);
        int nsplits = templates.length;
        assert (nsplits == this.ratios.length + 1) : "Unexpected number of split templates!";
        Vec[] datasetVecs = this.dataset.vecs();
        this.splits = new Frame[nsplits];
        for (s2 = 0; s2 < nsplits; ++s2) {
            Frame split2 = new Frame(this.destKeys[s2], this.dataset.names(), templates[s2]);
            split2.delete_and_lock(this.jobKey);
            this.splits[s2] = split2;
        }
        this.setPendingCount(nsplits);
        for (s2 = 0; s2 < nsplits; ++s2) {
            new FrameSplitTask(this, datasetVecs, this.ratios, s2).dfork(this.splits[s2]);
        }
        this.tryComplete();
    }

    public Frame[] getResult() {
        this.join();
        return this.splits;
    }

    @Override
    public void onCompletion(CountedCompleter caller) {
        this.dataset.unlock(this.jobKey);
        if (this.splits != null) {
            for (Frame s2 : this.splits) {
                if (s2 == null) continue;
                ((Frame)s2.update(this.jobKey)).unlock(this.jobKey);
            }
        }
    }

    @Override
    public boolean onExceptionalCompletion(Throwable ex, CountedCompleter caller) {
        this.dataset.unlock(this.jobKey);
        Futures fs = new Futures();
        if (this.splits != null) {
            for (Frame s2 : this.splits) {
                if (s2 == null) continue;
                ((Frame)s2.unlock(this.jobKey)).delete(this.jobKey, fs, true);
            }
        }
        fs.blockForPending();
        return true;
    }

    private Vec[][] makeTemplates(Frame dataset, double[] ratios) {
        Vec anyVec = dataset.anyVec();
        long[][] espcPerSplit = FrameSplitter.computeEspcPerSplit(anyVec.espc(), anyVec.length(), ratios);
        int num = dataset.numCols();
        int nsplits = espcPerSplit.length;
        String[][] domains = dataset.domains();
        byte[] types2 = new byte[num];
        int j2 = 0;
        for (Vec v2 : dataset.vecs()) {
            types2[j2++] = v2.get_type();
        }
        Vec[][] t2 = new Vec[nsplits][];
        for (int i2 = 0; i2 < nsplits; ++i2) {
            Key<Vec> vkey = Vec.newKey();
            int rowLayout = Vec.ESPC.rowLayout(vkey, espcPerSplit[i2]);
            t2[i2] = new Vec(vkey, rowLayout).makeCons(num, 0L, domains, types2);
        }
        return t2;
    }

    static long[][] computeEspcPerSplit(long[] espc, long len, double[] ratios) {
        assert (espc.length > 0 && espc[0] == 0L);
        assert (espc[espc.length - 1] == len);
        long[] partSizes = FrameSplitter.partitione(len, ratios);
        int nparts = ratios.length + 1;
        long[][] r2 = new long[nparts][espc.length];
        long nrows = 0L;
        long start = 0L;
        int c2 = 0;
        for (int p2 = 0; p2 < nparts; ++p2) {
            int nc = 0;
            while (c2 < espc.length - 1 && espc[c2 + 1] - start <= partSizes[p2]) {
                r2[p2][++nc] = espc[c2 + 1] - start;
                ++c2;
            }
            if (r2[p2][nc] < partSizes[p2]) {
                r2[p2][++nc] = partSizes[p2];
            }
            r2[p2] = Arrays.copyOf(r2[p2], nc + 1);
            nrows -= partSizes[p2];
            start += partSizes[p2];
        }
        return r2;
    }

    static final long[] partitione(long len, double[] ratio) {
        long[] r2 = new long[ratio.length + 1];
        long sum = 0L;
        int i2 = 0;
        float sr = 0.0f;
        for (i2 = 0; i2 < ratio.length; ++i2) {
            r2[i2] = (int)(ratio[i2] * (double)len);
            sum += r2[i2];
            sr = (float)((double)sr + ratio[i2]);
        }
        if (sr < 1.0f) {
            r2[i2] = len - sum;
        } else {
            int n2 = i2 - 1;
            r2[n2] = r2[n2] + (len - sum);
        }
        return r2;
    }

    private static class FrameSplitTask
    extends MRTask<FrameSplitTask> {
        final Vec[] _srcVecs;
        final double[] _ratios;
        final int _partIdx;
        transient int _pcidx;
        transient int _psrow;

        public FrameSplitTask(H2O.H2OCountedCompleter completer, Vec[] srcVecs, double[] ratios, int partIdx) {
            super(completer);
            this._srcVecs = srcVecs;
            this._ratios = ratios;
            this._partIdx = partIdx;
        }

        @Override
        protected void setupLocal() {
            Vec anyInVec = this._srcVecs[0];
            long[] partSizes = FrameSplitter.partitione(anyInVec.length(), this._ratios);
            long pnrows = 0L;
            for (int p2 = 0; p2 < this._partIdx; ++p2) {
                pnrows += partSizes[p2];
            }
            long[] espc = anyInVec.espc();
            while (this._pcidx < espc.length - 1 && (pnrows -= espc[this._pcidx + 1] - espc[this._pcidx]) >= 0L) {
                ++this._pcidx;
            }
            assert (pnrows <= 0L);
            this._psrow = (int)(pnrows + espc[this._pcidx + 1] - espc[this._pcidx]);
        }

        @Override
        public void map(Chunk[] cs) {
            int coutidx = cs[0].cidx();
            int cinidx = this._pcidx + coutidx;
            int startRow = coutidx > 0 ? 0 : this._psrow;
            int nrows = cs[0]._len;
            for (int i2 = 0; i2 < cs.length; ++i2) {
                ChunkSplitter.extractChunkPart(this._srcVecs[i2].chunkForChunkIdx(cinidx), cs[i2], startRow, nrows, this._fs);
            }
        }
    }
}

