/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.LinkFunction;
import hex.LogExpUtil;
import hex.genmodel.utils.LinkFunctionType;

class LogitFunction
extends LinkFunction {
    public LogitFunction() {
        this.linkFunctionType = LinkFunctionType.logit;
    }

    @Override
    public double link(double f2) {
        return LogExpUtil.log(f2 / (1.0 - f2));
    }

    @Override
    public double linkInv(double f2) {
        return 1.0 / (1.0 + LogExpUtil.exp(-f2));
    }

    @Override
    public String linkInvString(String f2) {
        return "1./(1. + " + LogitFunction.expString("-(" + f2 + ")") + ")";
    }

    @Override
    public String linkInvStringFloat(String f2) {
        return "1f/(1f + (float)" + LogitFunction.expString("-(" + f2 + ")") + ")";
    }
}

