/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.Distribution;
import hex.LinkFunction;
import hex.LogitFunction;
import hex.genmodel.utils.DistributionFamily;

class ModifiedHuberDistribution
extends Distribution {
    public ModifiedHuberDistribution(DistributionFamily family) {
        super(family, (LinkFunction)new LogitFunction());
    }

    @Override
    public double deviance(double w2, double y2, double f2) {
        double yf = (2.0 * y2 - 1.0) * f2;
        if (yf < -1.0) {
            return -w2 * 4.0 * yf;
        }
        if (yf > 1.0) {
            return 0.0;
        }
        return w2 * yf * yf;
    }

    @Override
    public double negHalfGradient(double y2, double f2) {
        double yf = (2.0 * y2 - 1.0) * f2;
        if (yf < -1.0) {
            return 2.0 * (2.0 * y2 - 1.0);
        }
        if (yf > 1.0) {
            return 0.0;
        }
        return -f2 * (2.0 * y2 - 1.0) * (2.0 * y2 - 1.0);
    }

    @Override
    public double initFNum(double w2, double o2, double y2) {
        return y2 == 1.0 ? w2 : 0.0;
    }

    @Override
    public double initFDenom(double w2, double o2, double y2) {
        return y2 == 1.0 ? 0.0 : w2;
    }

    @Override
    public double gammaNum(double w2, double y2, double z2, double f2) {
        double yf = (2.0 * y2 - 1.0) * f2;
        if (yf < -1.0) {
            return w2 * 4.0 * (2.0 * y2 - 1.0);
        }
        if (yf > 1.0) {
            return 0.0;
        }
        return w2 * 2.0 * (2.0 * y2 - 1.0) * (1.0 - yf);
    }

    @Override
    public double gammaDenom(double w2, double y2, double z2, double f2) {
        double yf = (2.0 * y2 - 1.0) * f2;
        if (yf < -1.0) {
            return -w2 * 4.0 * yf;
        }
        if (yf > 1.0) {
            return 0.0;
        }
        return w2 * (1.0 - yf) * (1.0 - yf);
    }
}

