/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.AUC2;
import hex.MultinomialAucType;
import hex.PairwiseAUC;
import hex.SimpleAUC;
import water.Iced;
import water.util.TwoDimTable;

public class MultinomialAUC
extends Iced {
    public SimpleAUC[] _ovrAucs;
    public PairwiseAUC[] _ovoAucs;
    public final MultinomialAucType _default_auc_type;
    public final String[] _domain;
    public static final int MAX_AUC_CLASSES = 50;
    public final boolean _calculateAuc;
    public final double _macroOvrAuc;
    public final double _weightedOvrAuc;
    public final double _macroOvoAuc;
    public final double _weightedOvoAuc;
    public final double _macroOvrAucPr;
    public final double _weightedOvrAucPr;
    public final double _macroOvoAucPr;
    public final double _weightedOvoAucPr;

    public MultinomialAUC(AUC2.AUCBuilder[] ovrAucs, AUC2.AUCBuilder[][] ovoAucs, String[] domain, boolean zeroWeights, MultinomialAucType type) {
        this._default_auc_type = type;
        this._domain = domain;
        int domainLength = this._domain.length;
        boolean bl = this._calculateAuc = !this._default_auc_type.equals((Object)MultinomialAucType.AUTO) && !this._default_auc_type.equals((Object)MultinomialAucType.NONE) && domainLength <= 50;
        if (this._calculateAuc) {
            this._ovoAucs = new PairwiseAUC[(domainLength * domainLength - domainLength) / 2];
            this._ovrAucs = new SimpleAUC[domainLength];
            int aucsIndex = 0;
            if (!zeroWeights) {
                for (int i2 = 0; i2 < domainLength - 1; ++i2) {
                    AUC2 tmpAucObject = ovrAucs[i2]._n > 0 ? new AUC2(ovrAucs[i2]) : new AUC2();
                    this._ovrAucs[i2] = new SimpleAUC(tmpAucObject._auc, tmpAucObject._pr_auc, tmpAucObject._p, tmpAucObject._n + tmpAucObject._p);
                    for (int j2 = i2 + 1; j2 < domainLength; ++j2) {
                        AUC2 first = ovoAucs[i2][j2]._n > 0 ? new AUC2(ovoAucs[i2][j2]) : new AUC2();
                        AUC2 second = ovoAucs[j2][i2]._n > 0 ? new AUC2(ovoAucs[j2][i2]) : new AUC2();
                        this._ovoAucs[aucsIndex++] = new PairwiseAUC(first, second, this._domain[i2], this._domain[j2]);
                    }
                }
                AUC2 tmpAucObject = ovrAucs[domainLength - 1]._n > 0 ? new AUC2(ovrAucs[domainLength - 1]) : new AUC2();
                this._ovrAucs[domainLength - 1] = new SimpleAUC(tmpAucObject._auc, tmpAucObject._pr_auc, tmpAucObject._p, tmpAucObject._n + tmpAucObject._p);
            } else {
                for (int i3 = 0; i3 < ovoAucs.length - 1; ++i3) {
                    this._ovrAucs[i3] = new SimpleAUC();
                    for (int j3 = i3 + 1; j3 < ovoAucs[0].length; ++j3) {
                        if (i3 >= j3) continue;
                        this._ovoAucs[aucsIndex++] = new PairwiseAUC(new AUC2(), new AUC2(), this._domain[i3], this._domain[j3]);
                    }
                }
                this._ovrAucs[domainLength - 1] = new SimpleAUC();
            }
            this._macroOvoAuc = this.computeOvoMacroAuc(false);
            this._weightedOvoAuc = this.computeOvoWeightedAuc(false);
            this._macroOvrAuc = this.computeOvrMacroAuc(false);
            this._weightedOvrAuc = this.computeOvrWeightedAuc(false);
            this._macroOvoAucPr = this.computeOvoMacroAuc(true);
            this._weightedOvoAucPr = this.computeOvoWeightedAuc(true);
            this._macroOvrAucPr = this.computeOvrMacroAuc(true);
            this._weightedOvrAucPr = this.computeOvrWeightedAuc(true);
        } else {
            this._macroOvoAuc = Double.NaN;
            this._weightedOvoAuc = Double.NaN;
            this._macroOvrAuc = Double.NaN;
            this._weightedOvrAuc = Double.NaN;
            this._macroOvoAucPr = Double.NaN;
            this._weightedOvoAucPr = Double.NaN;
            this._macroOvrAucPr = Double.NaN;
            this._weightedOvrAucPr = Double.NaN;
        }
    }

    public MultinomialAUC(TwoDimTable aucTable, TwoDimTable aucprTable, String[] domain, MultinomialAucType type) {
        this._default_auc_type = type;
        this._domain = domain;
        int domainLength = this._domain.length;
        boolean bl = this._calculateAuc = !this._default_auc_type.equals((Object)MultinomialAucType.AUTO) && !this._default_auc_type.equals((Object)MultinomialAucType.NONE) && domainLength <= 50;
        if (this._calculateAuc) {
            this._ovoAucs = new PairwiseAUC[(domainLength * domainLength - domainLength) / 2];
            this._ovrAucs = new SimpleAUC[domainLength];
            int aucsIndex = 0;
            for (int i2 = 0; i2 < this._ovrAucs.length; ++i2) {
                AUC2 auc = new AUC2();
                auc._auc = (Double)aucTable.get(i2, 3);
                auc._pr_auc = (Double)aucprTable.get(i2, 3);
                this._ovrAucs[i2] = new SimpleAUC(auc._auc, auc._pr_auc, 0.0, 0.0);
            }
            this._macroOvrAuc = (Double)aucTable.get(this._ovrAucs.length, 3);
            this._weightedOvrAuc = (Double)aucTable.get(this._ovrAucs.length + 1, 3);
            this._macroOvrAucPr = (Double)aucprTable.get(this._ovrAucs.length, 3);
            this._weightedOvrAucPr = (Double)aucprTable.get(this._ovrAucs.length + 1, 3);
            int lastOvoIndex = this._ovrAucs.length + this._ovoAucs.length + 2;
            for (int j2 = this._ovrAucs.length + 2; j2 < lastOvoIndex; ++j2) {
                this._ovoAucs[aucsIndex++] = new PairwiseAUC((Double)aucTable.get(j2, 3), (Double)aucprTable.get(j2, 3), (String)aucTable.get(j2, 1), (String)aucTable.get(j2, 2));
            }
            this._macroOvoAuc = (Double)aucTable.get(lastOvoIndex, 3);
            this._weightedOvoAuc = (Double)aucTable.get(lastOvoIndex + 1, 3);
            this._macroOvoAucPr = (Double)aucprTable.get(lastOvoIndex, 3);
            this._weightedOvoAucPr = (Double)aucprTable.get(lastOvoIndex, 3);
        } else {
            this._macroOvoAuc = Double.NaN;
            this._weightedOvoAuc = Double.NaN;
            this._macroOvrAuc = Double.NaN;
            this._weightedOvrAuc = Double.NaN;
            this._macroOvoAucPr = Double.NaN;
            this._weightedOvoAucPr = Double.NaN;
            this._macroOvrAucPr = Double.NaN;
            this._weightedOvrAucPr = Double.NaN;
        }
    }

    public double auc() {
        switch (this._default_auc_type) {
            case MACRO_OVR: {
                return this.getMacroOvrAuc();
            }
            case MACRO_OVO: {
                return this.getMacroOvoAuc();
            }
            case WEIGHTED_OVO: {
                return this.getWeightedOvoAuc();
            }
            case WEIGHTED_OVR: {
                return this.getWeightedOvrAuc();
            }
        }
        return Double.NaN;
    }

    public double pr_auc() {
        switch (this._default_auc_type) {
            case MACRO_OVR: {
                return this.get_macroOvrAucPr();
            }
            case MACRO_OVO: {
                return this.getMacroOvoAucPr();
            }
            case WEIGHTED_OVO: {
                return this.getWeightedOvoAucPr();
            }
        }
        return this.getWeightedOvrAucPr();
    }

    public double computeOvrMacroAuc(boolean isPr) {
        double macroAuc = 0.0;
        for (SimpleAUC ovrAuc : this._ovrAucs) {
            macroAuc += isPr ? ovrAuc.aucpr() : ovrAuc.auc();
        }
        return macroAuc / (double)this._ovrAucs.length;
    }

    public double computeOvrWeightedAuc(boolean isPr) {
        double weightedAuc = 0.0;
        double sumWeights = 0.0;
        for (SimpleAUC ovrAuc : this._ovrAucs) {
            double positives = ovrAuc.positives();
            sumWeights += positives;
            weightedAuc += isPr ? ovrAuc.aucpr() * positives : ovrAuc.auc() * positives;
        }
        return weightedAuc / sumWeights;
    }

    public double computeOvoMacroAuc(boolean isPr) {
        double macroAuc = 0.0;
        for (PairwiseAUC ovoAuc : this._ovoAucs) {
            macroAuc += isPr ? ovoAuc.getPrAuc() : ovoAuc.getAuc();
        }
        return macroAuc / (double)this._ovoAucs.length;
    }

    public double computeOvoWeightedAuc(boolean isPr) {
        double n2 = this._ovrAucs[0].ncases();
        double weightedAuc = 0.0;
        double sumWeights = 0.0;
        for (PairwiseAUC ovoAuc : this._ovoAucs) {
            double weight = ovoAuc.getSumPositives() / n2;
            weightedAuc += isPr ? ovoAuc.getPrAuc() * weight : ovoAuc.getAuc() * weight;
            sumWeights += weight;
        }
        return weightedAuc / sumWeights;
    }

    public double getMacroOvrAuc() {
        return this._macroOvrAuc;
    }

    public double getWeightedOvrAuc() {
        return this._weightedOvrAuc;
    }

    public double getMacroOvoAuc() {
        return this._macroOvoAuc;
    }

    public double getWeightedOvoAuc() {
        return this._weightedOvoAuc;
    }

    public double get_macroOvrAucPr() {
        return this._macroOvrAucPr;
    }

    public double getWeightedOvrAucPr() {
        return this._weightedOvrAucPr;
    }

    public double getMacroOvoAucPr() {
        return this._macroOvoAucPr;
    }

    public double getWeightedOvoAucPr() {
        return this._weightedOvoAucPr;
    }

    public TwoDimTable getAucTable() {
        return this.getTable(false);
    }

    public TwoDimTable getAucPrTable() {
        return this.getTable(true);
    }

    public TwoDimTable getTable(boolean isPr) {
        if (this._calculateAuc) {
            double aucValue;
            Iced auc;
            int i2;
            int i3;
            String metric = isPr ? "auc_pr" : "AUC";
            String tableHeader = "Multinomial " + metric + " values";
            int rows = this._ovrAucs.length + this._ovoAucs.length + 4;
            String[] rowHeaders = new String[rows];
            for (i3 = 0; i3 < this._ovrAucs.length; ++i3) {
                rowHeaders[i3] = this._domain[i3] + " vs Rest";
            }
            rowHeaders[this._ovrAucs.length] = "Macro OVR";
            rowHeaders[this._ovrAucs.length + 1] = "Weighted OVR";
            for (i3 = 0; i3 < this._ovoAucs.length; ++i3) {
                rowHeaders[this._ovrAucs.length + 2 + i3] = this._ovoAucs[i3].getPairwiseDomainsString();
            }
            rowHeaders[rows - 2] = "Macro OVO";
            rowHeaders[rows - 1] = "Weighted OVO";
            String[] colHeaders = new String[]{"First class domain", "Second class domain", metric};
            String[] colTypes = new String[]{"String", "String", "double"};
            String[] colFormats = new String[]{"%s", "%s", "%d"};
            String colHeaderForRowHeaders = "Type";
            TwoDimTable table = new TwoDimTable(tableHeader, null, rowHeaders, colHeaders, colTypes, colFormats, colHeaderForRowHeaders);
            double sumWeights = 0.0;
            for (i2 = 0; i2 < this._ovrAucs.length; ++i2) {
                auc = this._ovrAucs[i2];
                aucValue = isPr ? ((SimpleAUC)auc).aucpr() : ((SimpleAUC)auc).auc();
                table.set(i2, 0, this._domain[i2]);
                table.set(i2, 2, aucValue);
            }
            table.set(this._ovrAucs.length, 2, isPr ? this._macroOvrAucPr : this._macroOvrAuc);
            table.set(this._ovrAucs.length + 1, 2, isPr ? this._weightedOvrAucPr : this._weightedOvrAuc);
            sumWeights = 0.0;
            for (i2 = 0; i2 < this._ovoAucs.length; ++i2) {
                auc = this._ovoAucs[i2];
                aucValue = isPr ? ((PairwiseAUC)auc).getPrAuc() : ((PairwiseAUC)auc).getAuc();
                table.set(this._ovrAucs.length + 2 + i2, 0, ((PairwiseAUC)auc).getDomainFirst());
                table.set(this._ovrAucs.length + 2 + i2, 1, ((PairwiseAUC)auc).getDomainSecond());
                table.set(this._ovrAucs.length + 2 + i2, 2, aucValue);
            }
            table.set(rows - 2, 2, isPr ? this._macroOvoAucPr : this._macroOvoAuc);
            table.set(rows - 1, 2, isPr ? this._weightedOvoAucPr : this._weightedOvoAuc);
            return table;
        }
        return null;
    }
}

