/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.GainsLift;
import hex.Model;
import hex.ModelMetrics;
import hex.ModelMetricsBinomial;
import hex.ModelMetricsBinomialUplift;
import hex.ModelMetricsMultinomial;
import hex.ModelMetricsOrdinal;
import hex.ModelMetricsRegression;
import java.util.Arrays;
import water.H2O;
import water.Iced;
import water.exceptions.H2OIllegalArgumentException;
import water.util.ArrayUtils;
import water.util.Log;
import water.util.MathUtils;

public class ScoreKeeper
extends Iced {
    public double _mean_residual_deviance = Double.NaN;
    public double _mse = Double.NaN;
    public double _rmse = Double.NaN;
    public double _mae = Double.NaN;
    public double _rmsle = Double.NaN;
    public double _logloss = Double.NaN;
    public double _AUC = Double.NaN;
    public double _pr_auc = Double.NaN;
    public double _classError = Double.NaN;
    public double _mean_per_class_error = Double.NaN;
    public double _custom_metric = Double.NaN;
    public float[] _hitratio;
    public double _lift = Double.NaN;
    public double _r2 = Double.NaN;
    public double _anomaly_score = Double.NaN;
    public double _anomaly_score_normalized = Double.NaN;
    public double _AUUC = Double.NaN;
    public double _auuc_normalized = Double.NaN;
    public double _qini = Double.NaN;
    public int _auuc_nbins = 0;

    public ScoreKeeper() {
    }

    public ScoreKeeper(double mse) {
        this._mse = mse;
    }

    public ScoreKeeper(ModelMetrics mm4) {
        this.fillFrom(mm4);
    }

    public ScoreKeeper(Model m4) {
        if (null == m4) {
            throw new H2OIllegalArgumentException("model", "ScoreKeeper(Model model)", null);
        }
        if (null == m4._output) {
            throw new H2OIllegalArgumentException("model._output", "ScoreKeeper(Model model)", null);
        }
        if (null != ((Model.Output)m4._output)._cross_validation_metrics) {
            this.fillFrom(((Model.Output)m4._output)._cross_validation_metrics);
        } else if (null != ((Model.Output)m4._output)._validation_metrics) {
            this.fillFrom(((Model.Output)m4._output)._validation_metrics);
        } else {
            this.fillFrom(((Model.Output)m4._output)._training_metrics);
        }
    }

    public boolean isEmpty() {
        return Double.isNaN(this._mse) && Double.isNaN(this._logloss) && Double.isNaN(this._anomaly_score_normalized);
    }

    public void fillFrom(ModelMetrics m4) {
        if (m4 == null) {
            return;
        }
        this._mse = m4._MSE;
        this._rmse = m4.rmse();
        if (m4 instanceof ModelMetricsRegression) {
            this._mean_residual_deviance = ((ModelMetricsRegression)m4)._mean_residual_deviance;
            this._mae = ((ModelMetricsRegression)m4)._mean_absolute_error;
            this._rmsle = ((ModelMetricsRegression)m4)._root_mean_squared_log_error;
            this._r2 = ((ModelMetricsRegression)m4).r2();
        }
        if (m4 instanceof ModelMetricsBinomial) {
            GainsLift gl;
            this._logloss = ((ModelMetricsBinomial)m4)._logloss;
            this._r2 = ((ModelMetricsBinomial)m4).r2();
            if (((ModelMetricsBinomial)m4)._auc != null) {
                this._AUC = ((ModelMetricsBinomial)m4)._auc._auc;
                this._pr_auc = ((ModelMetricsBinomial)m4)._auc.pr_auc();
                this._classError = ((ModelMetricsBinomial)m4)._auc.defaultErr();
                this._mean_per_class_error = ((ModelMetricsBinomial)m4).mean_per_class_error();
            }
            if ((gl = ((ModelMetricsBinomial)m4)._gainsLift) != null && gl.response_rates != null && gl.response_rates.length > 0) {
                this._lift = gl.response_rates[0] / gl.avg_response_rate;
            }
        } else if (m4 instanceof ModelMetricsMultinomial) {
            this._logloss = ((ModelMetricsMultinomial)m4)._logloss;
            this._classError = ((ModelMetricsMultinomial)m4)._cm.err();
            this._mean_per_class_error = ((ModelMetricsMultinomial)m4).mean_per_class_error();
            this._hitratio = ((ModelMetricsMultinomial)m4)._hit_ratios;
            this._r2 = ((ModelMetricsMultinomial)m4).r2();
            this._AUC = ((ModelMetricsMultinomial)m4).auc();
            this._pr_auc = ((ModelMetricsMultinomial)m4).pr_auc();
        } else if (m4 instanceof ModelMetricsOrdinal) {
            this._logloss = ((ModelMetricsOrdinal)m4)._logloss;
            this._classError = ((ModelMetricsOrdinal)m4)._cm.err();
            this._mean_per_class_error = ((ModelMetricsOrdinal)m4).mean_per_class_error();
            this._hitratio = ((ModelMetricsOrdinal)m4)._hit_ratios;
            this._r2 = ((ModelMetricsOrdinal)m4).r2();
        } else if (m4 instanceof ScoreKeeperAware) {
            ((ScoreKeeperAware)((Object)m4)).fillTo(this);
        } else if (m4 instanceof ModelMetricsBinomialUplift) {
            this._AUUC = ((ModelMetricsBinomialUplift)m4).auuc();
            this._auuc_normalized = ((ModelMetricsBinomialUplift)m4).auucNormalized();
            this._qini = ((ModelMetricsBinomialUplift)m4).qini();
            this._auuc_nbins = ((ModelMetricsBinomialUplift)m4).nbins();
        }
        if (m4._custom_metric != null) {
            this._custom_metric = m4._custom_metric.value;
        }
    }

    public static int best(ScoreKeeper[] sk, int k2, IStoppingMetric criterion) {
        int idx;
        int best = sk.length - 1;
        IConvergenceStrategy cs = criterion.getConvergenceStrategy();
        if (cs != ConvergenceStrategy.LESS_IS_BETTER && cs != ConvergenceStrategy.MORE_IS_BETTER) {
            return best;
        }
        double bestVal = criterion.metricValue(sk[best]);
        for (int i2 = 1; i2 < k2 && (idx = sk.length - i2 - 1) >= 0; ++i2) {
            double val = criterion.metricValue(sk[idx]);
            if (cs == ConvergenceStrategy.LESS_IS_BETTER) {
                if (!(val < bestVal)) continue;
                best = idx;
                bestVal = val;
                continue;
            }
            if (!(val > bestVal)) continue;
            best = idx;
            bestVal = val;
        }
        return best;
    }

    public static boolean stopEarly(ScoreKeeper[] sk, int k2, ProblemType type, IStoppingMetric criterion, double rel_improvement, String what, boolean verbose) {
        if (k2 == 0) {
            return false;
        }
        int len = sk.length - 1;
        if (len < 2 * k2) {
            return false;
        }
        if (StoppingMetric.AUTO.equals(criterion)) {
            criterion = type.defaultMetric();
        }
        IConvergenceStrategy convergenceStrategy = criterion.getConvergenceStrategy();
        double[] movingAvg = new double[k2 + 1];
        double lastBeforeK = Double.MAX_VALUE;
        double minInLastK = Double.MAX_VALUE;
        double maxInLastK = -1.7976931348623157E308;
        for (int i2 = 0; i2 < movingAvg.length; ++i2) {
            movingAvg[i2] = 0.0;
            int startIdx = sk.length - 2 * k2 + i2;
            for (int j2 = 0; j2 < k2; ++j2) {
                ScoreKeeper skj = sk[startIdx + j2];
                double val = criterion.metricValue(skj);
                int n2 = i2;
                movingAvg[n2] = movingAvg[n2] + val;
            }
            int n3 = i2;
            movingAvg[n3] = movingAvg[n3] / (double)k2;
            if (Double.isNaN(movingAvg[i2])) {
                return false;
            }
            if (i2 == 0) {
                lastBeforeK = movingAvg[i2];
                continue;
            }
            minInLastK = Math.min(movingAvg[i2], minInLastK);
            maxInLastK = Math.max(movingAvg[i2], maxInLastK);
        }
        assert (lastBeforeK != Double.MAX_VALUE);
        assert (maxInLastK != -1.7976931348623157E308);
        assert (minInLastK != Double.MAX_VALUE);
        if (verbose) {
            Log.info("Windowed averages (window size " + k2 + ") of " + what + " " + (k2 + 1) + " " + criterion.toString() + " metrics: " + Arrays.toString(movingAvg));
        }
        if (criterion.isLowerBoundBy0() && lastBeforeK == 0.0) {
            Log.info("Checking convergence with " + criterion.toString() + " metric: " + lastBeforeK + " (metric converged to its lower bound).");
            return true;
        }
        double extremePoint = convergenceStrategy.extremePoint(lastBeforeK, minInLastK, maxInLastK);
        if (Math.signum(ArrayUtils.maxValue(movingAvg)) != Math.signum(ArrayUtils.minValue(movingAvg))) {
            return false;
        }
        if (Math.signum(extremePoint) != Math.signum(lastBeforeK)) {
            return false;
        }
        boolean stopEarly = convergenceStrategy.stopEarly(lastBeforeK, minInLastK, maxInLastK, rel_improvement);
        if (verbose) {
            Log.info("Checking convergence with " + criterion.toString() + " metric: " + lastBeforeK + " --> " + extremePoint + (stopEarly ? " (converged)." : " (still improving)."));
        }
        return stopEarly;
    }

    public boolean equals(Object that) {
        if (!(that instanceof ScoreKeeper)) {
            return false;
        }
        ScoreKeeper o2 = (ScoreKeeper)that;
        if (this._hitratio == null && ((ScoreKeeper)that)._hitratio != null) {
            return false;
        }
        if (this._hitratio != null && ((ScoreKeeper)that)._hitratio == null) {
            return false;
        }
        if (this._hitratio != null && ((ScoreKeeper)that)._hitratio != null) {
            if (this._hitratio.length != ((ScoreKeeper)that)._hitratio.length) {
                return false;
            }
            for (int i2 = 0; i2 < this._hitratio.length; ++i2) {
                if (MathUtils.compare(this._hitratio[i2], ((ScoreKeeper)that)._hitratio[i2], 1.0E-6, 1.0E-6)) continue;
                return false;
            }
        }
        return MathUtils.compare(this._mean_residual_deviance, o2._mean_residual_deviance, 1.0E-6, 1.0E-6) && MathUtils.compare(this._mse, o2._mse, 1.0E-6, 1.0E-6) && MathUtils.compare(this._mae, o2._mae, 1.0E-6, 1.0E-6) && MathUtils.compare(this._rmsle, o2._rmsle, 1.0E-6, 1.0E-6) && MathUtils.compare(this._logloss, o2._logloss, 1.0E-6, 1.0E-6) && MathUtils.compare(this._classError, o2._classError, 1.0E-6, 1.0E-6) && MathUtils.compare(this._mean_per_class_error, o2._mean_per_class_error, 1.0E-6, 1.0E-6) && MathUtils.compare(this._r2, o2._r2, 1.0E-6, 1.0E-6) && MathUtils.compare(this._lift, o2._lift, 1.0E-6, 1.0E-6);
    }

    public String toString() {
        return "ScoreKeeper{  _mean_residual_deviance=" + this._mean_residual_deviance + ", _rmse=" + this._rmse + ",_mae=" + this._mae + ",_rmsle=" + this._rmsle + ", _logloss=" + this._logloss + ", _AUC=" + this._AUC + ", _pr_auc=" + this._pr_auc + ", _classError=" + this._classError + ", _mean_per_class_error=" + this._mean_per_class_error + ", _hitratio=" + Arrays.toString(this._hitratio) + ", _lift=" + this._lift + ", _anomaly_score_normalized=" + this._anomaly_score_normalized + '}';
    }

    public static interface ScoreKeeperAware {
        public void fillTo(ScoreKeeper var1);
    }

    static enum ConvergenceStrategy implements IConvergenceStrategy
    {
        AUTO(0),
        MORE_IS_BETTER(1){

            @Override
            public double extremePoint(double lastBeforeK, double minInLastK, double maxInLastK) {
                return maxInLastK;
            }

            @Override
            public boolean stopEarly(double lastBeforeK, double minInLastK, double maxInLastK, double rel_improvement) {
                double ratio = maxInLastK / lastBeforeK;
                if (Double.isNaN(ratio)) {
                    return false;
                }
                return ratio <= 1.0 + rel_improvement;
            }
        }
        ,
        LESS_IS_BETTER(-1){

            @Override
            public double extremePoint(double lastBeforeK, double minInLastK, double maxInLastK) {
                return minInLastK;
            }

            @Override
            public boolean stopEarly(double lastBeforeK, double minInLastK, double maxInLastK, double rel_improvement) {
                double ratio = minInLastK / lastBeforeK;
                if (Double.isNaN(ratio)) {
                    return false;
                }
                return ratio >= 1.0 - rel_improvement;
            }
        }
        ,
        NON_DIRECTIONAL(0){

            @Override
            public double extremePoint(double lastBeforeK, double minInLastK, double maxInLastK) {
                return Math.abs(lastBeforeK - minInLastK) > Math.abs(lastBeforeK - maxInLastK) ? minInLastK : maxInLastK;
            }

            @Override
            public boolean stopEarly(double lastBeforeK, double minInLastK, double maxInLastK, double rel_change) {
                double extreme = this.extremePoint(lastBeforeK, minInLastK, maxInLastK);
                double ratio = extreme / lastBeforeK;
                if (Double.isNaN(ratio)) {
                    return false;
                }
                return ratio >= 1.0 - rel_change && ratio <= 1.0 + rel_change;
            }
        };

        final int _direction;

        private ConvergenceStrategy(int direction) {
            this._direction = direction;
        }

        @Override
        public double extremePoint(double lastBeforeK, double minInLastK, double maxInLastK) {
            throw new IllegalStateException("Should overridden in Strategy implementation");
        }

        @Override
        public boolean stopEarly(double lastBeforeK, double minInLastK, double maxInLastK, double rel_improvement) {
            throw new IllegalStateException("Should overridden in Strategy implementation");
        }
    }

    static interface IConvergenceStrategy {
        public double extremePoint(double var1, double var3, double var5);

        public boolean stopEarly(double var1, double var3, double var5, double var7);
    }

    public static enum ProblemType {
        regression(StoppingMetric.deviance),
        classification(StoppingMetric.logloss),
        anomaly_detection(StoppingMetric.anomaly_score),
        autoencoder(StoppingMetric.MSE);

        private final StoppingMetric _defaultMetric;

        private ProblemType(StoppingMetric defaultMetric) {
            this._defaultMetric = defaultMetric;
        }

        public StoppingMetric defaultMetric() {
            return this._defaultMetric;
        }

        public static ProblemType forSupervised(boolean isClassifier) {
            return isClassifier ? classification : regression;
        }
    }

    public static enum StoppingMetric implements IStoppingMetric
    {
        AUTO(ConvergenceStrategy.AUTO, false, false),
        deviance(ConvergenceStrategy.LESS_IS_BETTER, false, false),
        logloss(ConvergenceStrategy.LESS_IS_BETTER, true, true),
        MSE(ConvergenceStrategy.LESS_IS_BETTER, true, false),
        RMSE(ConvergenceStrategy.LESS_IS_BETTER, true, false),
        MAE(ConvergenceStrategy.LESS_IS_BETTER, true, false),
        RMSLE(ConvergenceStrategy.LESS_IS_BETTER, true, false),
        AUC(ConvergenceStrategy.MORE_IS_BETTER, true, true),
        AUCPR(ConvergenceStrategy.MORE_IS_BETTER, true, true),
        lift_top_group(ConvergenceStrategy.MORE_IS_BETTER, false, true),
        misclassification(ConvergenceStrategy.LESS_IS_BETTER, true, true),
        mean_per_class_error(ConvergenceStrategy.LESS_IS_BETTER, true, true),
        anomaly_score(ConvergenceStrategy.NON_DIRECTIONAL, false, false),
        custom(ConvergenceStrategy.LESS_IS_BETTER, false, false),
        custom_increasing(ConvergenceStrategy.MORE_IS_BETTER, false, false);

        private final ConvergenceStrategy _convergence;
        private final boolean _lowerBoundBy0;
        private final boolean _classificationOnly;

        private StoppingMetric(ConvergenceStrategy convergence, boolean lowerBoundBy0, boolean classificationOnly) {
            this._convergence = convergence;
            this._lowerBoundBy0 = lowerBoundBy0;
            this._classificationOnly = classificationOnly;
        }

        @Override
        public int direction() {
            return this._convergence._direction;
        }

        @Override
        public boolean isLowerBoundBy0() {
            return this._lowerBoundBy0;
        }

        public boolean isClassificationOnly() {
            return this._classificationOnly;
        }

        @Override
        public ConvergenceStrategy getConvergenceStrategy() {
            return this._convergence;
        }

        @Override
        public double metricValue(ScoreKeeper skj) {
            double val;
            switch (this) {
                case AUC: {
                    val = skj._AUC;
                    break;
                }
                case MSE: {
                    val = skj._mse;
                    break;
                }
                case RMSE: {
                    val = skj._rmse;
                    break;
                }
                case MAE: {
                    val = skj._mae;
                    break;
                }
                case RMSLE: {
                    val = skj._rmsle;
                    break;
                }
                case deviance: {
                    val = skj._mean_residual_deviance;
                    break;
                }
                case logloss: {
                    val = skj._logloss;
                    break;
                }
                case misclassification: {
                    val = skj._classError;
                    break;
                }
                case AUCPR: {
                    val = skj._pr_auc;
                    break;
                }
                case mean_per_class_error: {
                    val = skj._mean_per_class_error;
                    break;
                }
                case lift_top_group: {
                    val = skj._lift;
                    break;
                }
                case custom: 
                case custom_increasing: {
                    val = skj._custom_metric;
                    break;
                }
                case anomaly_score: {
                    val = skj._anomaly_score_normalized;
                    break;
                }
                default: {
                    throw H2O.unimpl("Undefined stopping criterion.");
                }
            }
            return val;
        }
    }

    public static interface IStoppingMetric {
        public int direction();

        public boolean isLowerBoundBy0();

        public IConvergenceStrategy getConvergenceStrategy();

        public double metricValue(ScoreKeeper var1);
    }
}

