/*
 * Decompiled with CFR 0.152.
 */
package hex;

import hex.FoldAssignment;
import hex.MappingTransformFactory;
import java.util.Arrays;
import water.fvec.TransformWrappedVec;
import water.fvec.Vec;
import water.util.ArrayUtils;

class TransformFoldAssignment
extends FoldAssignment {
    private final Vec _adaptedFold;

    TransformFoldAssignment(Vec fold, int[] usedFoldValues) {
        super(fold);
        this._adaptedFold = this.makeAdaptedFold(usedFoldValues);
    }

    @Override
    Vec getAdaptedFold() {
        return this._adaptedFold;
    }

    final Vec makeAdaptedFold(int[] usedFoldValues) {
        int[] foldValuesToFoldIndices = TransformFoldAssignment.foldValuesToFoldIndices(usedFoldValues);
        return new TransformWrappedVec(new Vec[]{this._fold}, new MappingTransformFactory(foldValuesToFoldIndices));
    }

    static int[] foldValuesToFoldIndices(int[] usedFoldValues) {
        int max = ArrayUtils.maxValue(usedFoldValues);
        int[] valueToFoldIndex = new int[max + 1];
        Arrays.fill(valueToFoldIndex, -1);
        for (int i2 = 0; i2 < usedFoldValues.length; ++i2) {
            valueToFoldIndex[usedFoldValues[i2]] = i2;
        }
        return valueToFoldIndex;
    }

    @Override
    void remove(boolean keepOriginalFold) {
        this._adaptedFold.remove();
    }
}

