/*
 * Decompiled with CFR 0.152.
 */
package hex.anovaglm;

import hex.DataInfo;
import hex.anovaglm.ANOVAGLMModel;
import hex.anovaglm.ANOVAGLMUtils;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.NewChunk;

public class GenerateTransformColumns
extends MRTask<GenerateTransformColumns> {
    public final int[] _newColNumber;
    public final boolean _imputeMissing;
    public final int[] _catNAFills;
    public final double[] _numNAFills;
    final int _numNewCols;
    final boolean _hasWeight;
    final boolean _hasOffset;
    final int _weightID;
    final int _offsetID;
    final int _responseID;
    final int _numPredIndividual;
    final int _nCats;
    final int _nNums;
    final String[][] _transformedColNames;
    final String[][] _predColsCombo;

    public GenerateTransformColumns(String[][] newColNames, ANOVAGLMModel.ANOVAGLMParameters parms, DataInfo dinfo, int numPreds, String[][] predColsCombo) {
        this._predColsCombo = predColsCombo;
        this._transformedColNames = newColNames;
        this._newColNumber = GenerateTransformColumns.countColNumber(newColNames);
        this._imputeMissing = parms.imputeMissing();
        this._catNAFills = dinfo.catNAFill();
        this._nCats = dinfo._cats;
        this._nNums = dinfo._nums;
        this._numNAFills = dinfo.numNAFill();
        this._numNewCols = this._newColNumber.length;
        this._hasWeight = parms._weights_column != null;
        this._hasOffset = parms._offset_column != null;
        this._weightID = this._hasWeight ? dinfo.weightChunkId() : -1;
        this._offsetID = this._hasOffset ? dinfo.offsetChunkId() : -1;
        this._responseID = dinfo.responseChunkId(0);
        this._numPredIndividual = numPreds;
    }

    public static int[] countColNumber(String[][] transformedColNames) {
        int[] colNumber = new int[transformedColNames.length];
        for (int colInd = 0; colInd < transformedColNames.length; ++colInd) {
            colNumber[colInd] = transformedColNames[colInd].length;
        }
        return colNumber;
    }

    @Override
    public void map(Chunk[] chk, NewChunk[] newChk) {
        int numChkRows = chk[0].len();
        double[][] changedRow = GenerateTransformColumns.allocateRow(this._newColNumber);
        double[] oneRow = new double[this._numPredIndividual];
        for (int rowInd = 0; rowInd < numChkRows; ++rowInd) {
            if (!this.readCatVal(chk, rowInd, oneRow)) continue;
            this.transformOneRow(changedRow, oneRow, this._numPredIndividual, this._newColNumber);
            int colIndex = 0;
            for (int predInd = 0; predInd < this._numNewCols; ++predInd) {
                for (int eleInd = 0; eleInd < this._newColNumber[predInd]; ++eleInd) {
                    newChk[colIndex++].addNum(changedRow[predInd][eleInd]);
                }
            }
            if (this._hasWeight) {
                newChk[colIndex++].addNum(chk[this._weightID].atd(rowInd));
            }
            if (this._hasOffset) {
                newChk[colIndex++].addNum(chk[this._offsetID].atd(rowInd));
            }
            newChk[colIndex].addNum(chk[this._responseID].atd(rowInd));
        }
    }

    public double imputeNA(int colIndex) {
        if (colIndex < this._nCats) {
            return this._catNAFills[colIndex];
        }
        return this._numNAFills[colIndex - this._nCats];
    }

    public static double[][] allocateRow(int[] newColNumber) {
        int numPreds = newColNumber.length;
        double[][] oneRow = new double[numPreds][];
        for (int index = 0; index < numPreds; ++index) {
            oneRow[index] = new double[newColNumber[index]];
        }
        return oneRow;
    }

    public void transformOneRow(double[][] newRow, double[] val, int numPreds, int[] newColNumber) {
        int colInd;
        for (colInd = 0; colInd < this._nCats; ++colInd) {
            for (int valInd = 0; valInd < newColNumber[colInd]; ++valInd) {
                newRow[colInd][valInd] = val[colInd] == (double)valInd ? 1.0 : (val[colInd] == (double)newColNumber[colInd] ? -1.0 : 0.0);
            }
        }
        for (colInd = this._nCats; colInd < this._numPredIndividual; ++colInd) {
            newRow[colInd][0] = val[colInd];
        }
        this.transformInteractingPred(newRow);
    }

    public void transformInteractingPred(double[][] newRow) {
        for (int newColInd = this._numPredIndividual; newColInd < this._numNewCols; ++newColInd) {
            String[] currPredNames = this._predColsCombo[newColInd];
            int matchPCols = ANOVAGLMUtils.findComboMatch(this._predColsCombo, newColInd);
            double[] transformedInteraction = newRow[matchPCols];
            int cols2TranformInd = GenerateTransformColumns.find(this._predColsCombo, currPredNames[0]);
            double[] currTransform = newRow[cols2TranformInd];
            int countInd = 0;
            for (int currInd = 0; currInd < currTransform.length; ++currInd) {
                for (int matchInd = 0; matchInd < transformedInteraction.length; ++matchInd) {
                    newRow[newColInd][countInd++] = currTransform[currInd] * transformedInteraction[matchInd];
                }
            }
        }
    }

    private static int find(String[][] totArray, String ele) {
        int arrLen = totArray.length;
        for (int locInd = 0; locInd < arrLen; ++locInd) {
            if (!totArray[locInd][0].equals(ele)) continue;
            return locInd;
        }
        return -1;
    }

    boolean readCatVal(Chunk[] chk, int rowInd, double[] rowData) {
        for (int index = 0; index < this._numPredIndividual; ++index) {
            rowData[index] = chk[index].atd(rowInd);
            if (!Double.isNaN(rowData[index])) continue;
            if (this._imputeMissing) {
                rowData[index] = this.imputeNA(index);
                continue;
            }
            return false;
        }
        return true;
    }
}

