/*
 * Decompiled with CFR 0.152.
 */
package hex.deeplearning;

public class MurmurHash {
    private static MurmurHash _instance = new MurmurHash();

    public static MurmurHash getInstance() {
        return _instance;
    }

    public int hash(byte[] data, int length, int seed) {
        int m4 = 1540483477;
        int r2 = 24;
        int h2 = seed ^ length;
        int len_4 = length >> 2;
        for (int i2 = 0; i2 < len_4; ++i2) {
            int i_4 = i2 << 2;
            int k2 = data[i_4 + 3];
            k2 <<= 8;
            k2 |= data[i_4 + 2] & 0xFF;
            k2 <<= 8;
            k2 |= data[i_4 + 1] & 0xFF;
            k2 <<= 8;
            k2 |= data[i_4 + 0] & 0xFF;
            k2 *= m4;
            k2 ^= k2 >>> r2;
            h2 *= m4;
            h2 ^= (k2 *= m4);
        }
        int len_m = len_4 << 2;
        int left = length - len_m;
        if (left != 0) {
            if (left >= 3) {
                h2 ^= data[length - 3] << 16;
            }
            if (left >= 2) {
                h2 ^= data[length - 2] << 8;
            }
            if (left >= 1) {
                h2 ^= data[length - 1];
            }
            h2 *= m4;
        }
        h2 ^= h2 >>> 13;
        h2 *= m4;
        h2 ^= h2 >>> 15;
        return h2;
    }
}

