/*
 * Decompiled with CFR 0.152.
 */
package hex.gam.MatrixFrameUtils;

import hex.DataInfo;
import hex.gam.GAMModel;
import hex.gam.GamSplines.CubicRegressionSplines;
import hex.genmodel.algos.gam.GamUtilsCubicRegression;
import hex.glm.GLMModel;
import hex.util.LinearAlgebraUtils;
import water.MRTask;
import water.fvec.Chunk;
import water.fvec.Frame;
import water.fvec.NewChunk;
import water.fvec.Vec;
import water.util.ArrayUtils;

public class GenCSSplineGamOneColumn
extends MRTask<GenCSSplineGamOneColumn> {
    int _splineType;
    public int _numKnots;
    public double[][] _bInvD;
    public int _initChunks;
    public double[][] _ZTransp;
    public double[][] _penaltyMat;
    public double[] _knots;
    double[] _maxAbsRowSum;
    public double _s_scale;

    public GenCSSplineGamOneColumn(int splineType, int numKnots, double[] knots, Frame gamx) {
        this._splineType = splineType;
        this._numKnots = numKnots;
        CubicRegressionSplines crSplines = new CubicRegressionSplines(numKnots, knots);
        this._bInvD = crSplines.gen_BIndvD(crSplines._hj);
        this._penaltyMat = crSplines.gen_penalty_matrix(crSplines._hj, this._bInvD);
        this._initChunks = gamx.vec(0).nChunks();
        this._knots = knots;
    }

    @Override
    public void map(Chunk[] chk, NewChunk[] newGamCols) {
        this._maxAbsRowSum = new double[this._initChunks];
        int cIndex = chk[0].cidx();
        this._maxAbsRowSum[cIndex] = Double.NEGATIVE_INFINITY;
        int chunkRows = chk[0].len();
        CubicRegressionSplines crSplines = new CubicRegressionSplines(this._numKnots, this._knots);
        double[] basisVals = new double[this._numKnots];
        for (int rowIndex = 0; rowIndex < chunkRows; ++rowIndex) {
            double gamRowSum = 0.0;
            if (chk[1].atd(rowIndex) != 0.0) {
                double xval = chk[0].atd(rowIndex);
                if (Double.isNaN(xval)) {
                    for (int colIndex = 0; colIndex < this._numKnots; ++colIndex) {
                        newGamCols[colIndex].addNum(Double.NaN);
                    }
                    continue;
                }
                int binIndex = GamUtilsCubicRegression.locateBin(xval, this._knots);
                GamUtilsCubicRegression.updateFMatrixCFunc(basisVals, xval, binIndex, this._knots, crSplines._hj, this._bInvD);
                GamUtilsCubicRegression.updateAFunc(basisVals, xval, binIndex, this._knots, crSplines._hj);
                for (int colIndex = 0; colIndex < this._numKnots; ++colIndex) {
                    newGamCols[colIndex].addNum(basisVals[colIndex]);
                    gamRowSum += Math.abs(basisVals[colIndex]);
                }
                if (!(gamRowSum > this._maxAbsRowSum[cIndex])) continue;
                this._maxAbsRowSum[cIndex] = gamRowSum;
                continue;
            }
            for (int colIndex = 0; colIndex < this._numKnots; ++colIndex) {
                newGamCols[colIndex].addNum(0.0);
            }
        }
    }

    @Override
    public void reduce(GenCSSplineGamOneColumn other) {
        ArrayUtils.add(this._maxAbsRowSum, other._maxAbsRowSum);
    }

    @Override
    public void postGlobal() {
        double tempMaxValue = ArrayUtils.maxValue(this._maxAbsRowSum);
        this._s_scale = tempMaxValue * tempMaxValue / ArrayUtils.rNorm(this._penaltyMat, 'i');
        ArrayUtils.mult(this._penaltyMat, this._s_scale);
        this._s_scale = 1.0 / this._s_scale;
    }

    public static double[][] generateZTransp(Frame gamX, int numKnots) {
        double[] u2 = new double[numKnots];
        for (int cind = 0; cind < numKnots; ++cind) {
            u2[cind] = gamX.vec(cind).mean();
        }
        double[][] ZTransp = new double[numKnots - 1][numKnots];
        double mag = ArrayUtils.innerProduct(u2, u2);
        u2[0] = u2[0] - (double)(u2[0] > 0.0 ? -1 : 1) * Math.sqrt(mag);
        double twoOmagSq = 2.0 / ArrayUtils.innerProduct(u2, u2);
        for (int rowIndex = 0; rowIndex < numKnots; ++rowIndex) {
            for (int colIndex = 0; colIndex < numKnots; ++colIndex) {
                if (colIndex <= 0) continue;
                ZTransp[colIndex - 1][rowIndex] = (double)(colIndex == rowIndex ? 1 : 0) - u2[rowIndex] * u2[colIndex] * twoOmagSq;
            }
        }
        return ZTransp;
    }

    public Frame centralizeFrame(Frame fr, String colNameStart, GAMModel.GAMParameters parms) {
        this._ZTransp = GenCSSplineGamOneColumn.generateZTransp(fr, this._numKnots);
        return GenCSSplineGamOneColumn.centralizeFrame(fr, colNameStart, parms, this._ZTransp);
    }

    public static Frame centralizeFrame(Frame fr, String colNameStart, GAMModel.GAMParameters parms, double[][] zTransp) {
        int index;
        int numCols = fr.numCols();
        int ncolExp = numCols - 1;
        DataInfo frInfo = new DataInfo(fr, null, 0, false, DataInfo.TransformType.NONE, DataInfo.TransformType.NONE, GLMModel.GLMParameters.MissingValuesHandling.Skip == parms._missing_values_handling, parms._missing_values_handling == GLMModel.GLMParameters.MissingValuesHandling.MeanImputation || parms._missing_values_handling == GLMModel.GLMParameters.MissingValuesHandling.PlugValues, parms.makeImputer(), false, false, false, false, null);
        for (index = 0; index < ncolExp; ++index) {
            fr.add(colNameStart + "_" + index, fr.anyVec().makeZero());
        }
        new LinearAlgebraUtils.BMulInPlaceTask(frInfo, zTransp, numCols, false).doAll(fr);
        for (index = 0; index < numCols; ++index) {
            Vec temp = fr.remove(0);
            temp.remove();
        }
        return fr;
    }
}

