/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.ModelCategory;
import hex.genmodel.CategoricalEncoding;
import hex.genmodel.IGenModel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Random;
import water.genmodel.IGeneratedModel;

public abstract class GenModel
implements IGenModel,
IGeneratedModel,
Serializable {
    public final String[] _names;
    public final String[][] _domains;
    public final String _responseColumn;
    public String _offsetColumn;

    public GenModel(String[] names, String[][] domains, String responseColumn) {
        this._names = names;
        this._domains = domains;
        this._responseColumn = responseColumn;
    }

    @Deprecated
    public GenModel(String[] names, String[][] domains) {
        this(names, domains, null);
    }

    public boolean requiresOffset() {
        return false;
    }

    @Override
    public boolean isSupervised() {
        return false;
    }

    @Override
    public int nfeatures() {
        return this._names.length;
    }

    public int nCatFeatures() {
        int nCat = 0;
        String[][] domainValues = this.getDomainValues();
        for (int i2 = 0; i2 < this.nfeatures(); ++i2) {
            if (domainValues[i2] == null) continue;
            ++nCat;
        }
        return nCat;
    }

    @Override
    public String[] features() {
        return Arrays.copyOf(this._names, this.nfeatures());
    }

    @Override
    public int nclasses() {
        return 0;
    }

    @Override
    public abstract ModelCategory getModelCategory();

    public String[] getOutputNames() {
        String[] outputNames;
        ModelCategory category = this.getModelCategory();
        switch (category) {
            case AutoEncoder: {
                int index;
                LinkedList<String> onames = new LinkedList<String>();
                String[] cnames = this.getNames();
                int numCats = this.nCatFeatures();
                String[][] domainValues = this.getDomainValues();
                for (index = 0; index <= numCats - 1; ++index) {
                    String[] tdomains = domainValues[index];
                    int tdomainLen = tdomains.length - 1;
                    for (int index2 = 0; index2 <= tdomainLen; ++index2) {
                        onames.add("reconstr_" + cnames[index] + "." + tdomains[index2]);
                    }
                    onames.add("reconstr_" + cnames[index] + ".missing(NA)");
                }
                for (index = numCats; index < cnames.length; ++index) {
                    onames.add("reconstr_" + cnames[index]);
                }
                outputNames = onames.toArray(new String[0]);
                break;
            }
            case Binomial: 
            case Multinomial: 
            case Ordinal: {
                String[] responseDomainValues = this.getDomainValues(this.getResponseIdx());
                outputNames = new String[1 + responseDomainValues.length];
                outputNames[0] = "predict";
                System.arraycopy(responseDomainValues, 0, outputNames, 1, outputNames.length - 1);
                for (int i2 = 1; i2 < outputNames.length; ++i2) {
                    try {
                        Integer.valueOf(outputNames[i2]);
                        outputNames[i2] = "p" + outputNames[i2];
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                break;
            }
            case Clustering: {
                outputNames = new String[]{"cluster"};
                break;
            }
            case Regression: {
                outputNames = new String[]{"predict"};
                break;
            }
            case CoxPH: {
                outputNames = new String[]{"lp"};
                break;
            }
            default: {
                throw new UnsupportedOperationException("Getting output column names for model category '" + (Object)((Object)category) + "' is not supported.");
            }
        }
        return outputNames;
    }

    public String[][] getOutputDomains() {
        ModelCategory category = this.getModelCategory();
        String[][] outputDomains = new String[this.getOutputNames().length][];
        switch (category) {
            case Binomial: 
            case Multinomial: 
            case Ordinal: {
                outputDomains[0] = this.getDomainValues(this.getResponseIdx());
                break;
            }
            case Regression: {
                outputDomains[0] = null;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Getting output domains for model category '" + (Object)((Object)category) + "' is not yet supported.");
            }
        }
        return outputDomains;
    }

    @Override
    public EnumSet<ModelCategory> getModelCategories() {
        return EnumSet.of(this.getModelCategory());
    }

    @Override
    public abstract String getUUID();

    @Override
    public int getNumCols() {
        return this.nfeatures();
    }

    @Override
    public String[] getNames() {
        return this._names;
    }

    public int getOrigNumCols() {
        String[] origNames = this.getOrigNames();
        if (origNames == null || origNames.length == 0) {
            return 0;
        }
        boolean hasResponse = false;
        if (this.isSupervised()) {
            String responseName = this.getResponseName();
            hasResponse = origNames[origNames.length - 1].equals(responseName);
        }
        return hasResponse ? origNames.length - 1 : origNames.length;
    }

    @Override
    public String[] getOrigNames() {
        return null;
    }

    @Override
    public String getResponseName() {
        int r2 = this.getResponseIdx();
        return r2 < this._names.length ? this._names[r2] : this._responseColumn;
    }

    @Override
    public int getResponseIdx() {
        if (!this.isSupervised()) {
            throw new UnsupportedOperationException("Cannot provide response index for unsupervised models.");
        }
        return this._domains.length - 1;
    }

    @Override
    public String getOffsetName() {
        return this._offsetColumn;
    }

    @Override
    public int getNumClasses(int colIdx) {
        String[] domval = this.getDomainValues(colIdx);
        return domval != null ? domval.length : -1;
    }

    @Override
    public int getNumResponseClasses() {
        if (!this.isClassifier()) {
            throw new UnsupportedOperationException("Cannot provide number of response classes for non-classifiers.");
        }
        return this.nclasses();
    }

    @Override
    public CategoricalEncoding getCategoricalEncoding() {
        return CategoricalEncoding.AUTO;
    }

    @Override
    public boolean isClassifier() {
        ModelCategory cat = this.getModelCategory();
        return cat == ModelCategory.Binomial || cat == ModelCategory.Multinomial || cat == ModelCategory.Ordinal;
    }

    @Override
    public boolean isAutoEncoder() {
        return this.getModelCategory() == ModelCategory.AutoEncoder;
    }

    @Override
    public String[] getDomainValues(String name) {
        int colIdx = this.getColIdx(name);
        return colIdx != -1 ? this.getDomainValues(colIdx) : null;
    }

    @Override
    public String[] getDomainValues(int i2) {
        return this.getDomainValues()[i2];
    }

    @Override
    public String[][] getDomainValues() {
        return this._domains;
    }

    @Override
    public String[][] getOrigDomainValues() {
        return null;
    }

    @Override
    public double[] getOrigProjectionArray() {
        return null;
    }

    @Override
    public int getColIdx(String name) {
        String[] names = this.getNames();
        for (int i2 = 0; i2 < names.length; ++i2) {
            if (!names[i2].equals(name)) continue;
            return i2;
        }
        return -1;
    }

    @Override
    public int mapEnum(int colIdx, String enumValue) {
        String[] domain = this.getDomainValues(colIdx);
        if (domain != null) {
            for (int i2 = 0; i2 < domain.length; ++i2) {
                if (!enumValue.equals(domain[i2])) continue;
                return i2;
            }
        }
        return -1;
    }

    @Override
    public int getPredsSize() {
        return this.isClassifier() ? 1 + this.getNumResponseClasses() : 2;
    }

    public int getPredsSize(ModelCategory mc) {
        return mc == ModelCategory.DimReduction ? this.nclasses() : this.getPredsSize();
    }

    public static String createAuxKey(String k2) {
        return k2 + ".aux";
    }

    public abstract double[] score0(double[] var1, double[] var2);

    public double[] score0(double[] row, double offset, double[] preds) {
        throw new UnsupportedOperationException("`offset` column is not supported");
    }

    public boolean calibrateClassProbabilities(double[] preds) {
        return false;
    }

    public static double[] correctProbabilities(double[] scored, double[] priorClassDist, double[] modelClassDist) {
        double probsum = 0.0;
        for (int c2 = 1; c2 < scored.length; ++c2) {
            double original_fraction = priorClassDist[c2 - 1];
            double oversampled_fraction = modelClassDist[c2 - 1];
            assert (!Double.isNaN(scored[c2])) : "Predicted NaN class probability";
            if (original_fraction != 0.0 && oversampled_fraction != 0.0) {
                int n2 = c2;
                scored[n2] = scored[n2] * (original_fraction / oversampled_fraction);
            }
            probsum += scored[c2];
        }
        if (probsum > 0.0) {
            int i2 = 1;
            while (i2 < scored.length) {
                int n3 = i2++;
                scored[n3] = scored[n3] / probsum;
            }
        }
        return scored;
    }

    public static int getPrediction(double[] preds, double[] priorClassDist, double[] data, double threshold) {
        if (preds.length == 3) {
            return GenModel.getPredictionBinomial(preds, threshold);
        }
        return GenModel.getPredictionMultinomial(preds, priorClassDist, data);
    }

    public static int getPredictionBinomial(double[] preds, double threshold) {
        return preds[2] >= threshold ? 1 : 0;
    }

    public static int getPredictionMultinomial(double[] preds, double[] priorClassDist, double[] data) {
        ArrayList<Integer> ties = new ArrayList<Integer>();
        ties.add(0);
        int best = 1;
        int tieCnt = 0;
        for (int c2 = 2; c2 < preds.length; ++c2) {
            if (preds[best] < preds[c2]) {
                best = c2;
                tieCnt = 0;
                continue;
            }
            if (preds[best] != preds[c2]) continue;
            ++tieCnt;
            ties.add(c2 - 1);
        }
        if (tieCnt == 0) {
            return best - 1;
        }
        long hash = 0L;
        if (data != null) {
            for (double d2 : data) {
                hash ^= Double.doubleToRawLongBits(d2) >> 6;
            }
        }
        if (priorClassDist != null) {
            assert (preds.length == priorClassDist.length + 1);
            double sum = 0.0;
            for (Integer i2 : ties) {
                sum += priorClassDist[i2];
            }
            Random rng = new Random(hash);
            double tie = rng.nextDouble();
            double partialSum = 0.0;
            for (Integer i3 : ties) {
                if (!(tie <= (partialSum += priorClassDist[i3] / sum))) continue;
                return i3;
            }
        }
        double res = preds[best];
        int idx = (int)hash % (tieCnt + 1);
        for (best = 1; best < preds.length; ++best) {
            if (res != preds[best] || --idx >= 0) continue;
            return best - 1;
        }
        throw new RuntimeException("Should Not Reach Here");
    }

    public static boolean bitSetContains(byte[] bits, int nbits, int bitoff, double dnum) {
        assert (!Double.isNaN(dnum));
        int idx = (int)dnum;
        assert ((idx -= bitoff) >= 0 && idx < nbits) : "Must have " + bitoff + " <= idx <= " + (bitoff + nbits - 1) + ": " + idx;
        return (bits[idx >> 3] & 1 << (idx & 7)) != 0;
    }

    public static boolean bitSetIsInRange(int nbits, int bitoff, double dnum) {
        assert (!Double.isNaN(dnum));
        int idx = (int)dnum;
        return (idx -= bitoff) >= 0 && idx < nbits;
    }

    public static void Kmeans_preprocessData(double[] data, double[] means, double[] mults, int[] modes) {
        for (int i2 = 0; i2 < data.length; ++i2) {
            data[i2] = GenModel.Kmeans_preprocessData(data[i2], i2, means, mults, modes);
        }
    }

    public static double Kmeans_preprocessData(double d2, int i2, double[] means, double[] mults, int[] modes) {
        if (modes[i2] == -1) {
            if (Double.isNaN(d2)) {
                d2 = means[i2];
            }
            if (mults != null) {
                d2 -= means[i2];
                d2 *= mults[i2];
            }
        } else if (Double.isNaN(d2)) {
            d2 = modes[i2];
        }
        return d2;
    }

    public static int KMeans_closest(double[][] centers, double[] point, String[][] domains) {
        int min2 = -1;
        double minSqr = Double.MAX_VALUE;
        for (int cluster = 0; cluster < centers.length; ++cluster) {
            double sqr = GenModel.KMeans_distance(centers[cluster], point, domains);
            if (!(sqr < minSqr)) continue;
            min2 = cluster;
            minSqr = sqr;
        }
        return min2;
    }

    public static int KMeans_distances(double[][] centers, double[] point, String[][] domains, double[] distances) {
        int min2 = -1;
        double minSqr = Double.MAX_VALUE;
        for (int cluster = 0; cluster < centers.length; ++cluster) {
            distances[cluster] = GenModel.KMeans_distance(centers[cluster], point, domains);
            if (!(distances[cluster] < minSqr)) continue;
            min2 = cluster;
            minSqr = distances[cluster];
        }
        return min2;
    }

    public static double[] KMeans_simplex(double[][] centers, double[] point, String[][] domains) {
        double[] dist = new double[centers.length];
        double sum = 0.0;
        double inv_sum = 0.0;
        for (int cluster = 0; cluster < centers.length; ++cluster) {
            dist[cluster] = GenModel.KMeans_distance(centers[cluster], point, domains);
            sum += dist[cluster];
            inv_sum += 1.0 / dist[cluster];
        }
        double[] ratios = new double[centers.length];
        if (sum == 0.0) {
            Random rng = new Random();
            int idx = rng.nextInt(centers.length);
            ratios[idx] = 1.0;
        } else {
            int cluster;
            int idx = -1;
            for (cluster = 0; cluster < centers.length; ++cluster) {
                if (dist[cluster] != 0.0) continue;
                idx = cluster;
                break;
            }
            if (idx == -1) {
                for (cluster = 0; cluster < centers.length; ++cluster) {
                    ratios[cluster] = 1.0 / (dist[cluster] * inv_sum);
                }
            } else {
                ratios[idx] = 1.0;
            }
        }
        return ratios;
    }

    public static double KMeans_distance(double[] center, float[] point, int[] modes, double[] colSum, double[] colSumSq) {
        double sqr = 0.0;
        int pts = point.length;
        for (int column = 0; column < center.length; ++column) {
            float d2 = point[column];
            if (Float.isNaN(d2)) {
                --pts;
                continue;
            }
            if (modes[column] != -1) {
                if ((double)d2 != center[column]) {
                    sqr += 1.0;
                }
                if (d2 == (float)modes[column]) continue;
                int n2 = column;
                colSum[n2] = colSum[n2] + 1.0;
                continue;
            }
            double delta = (double)d2 - center[column];
            sqr += delta * delta;
            int n3 = column;
            colSum[n3] = colSum[n3] + (double)d2;
            int n4 = column;
            colSumSq[n4] = colSumSq[n4] + (double)(d2 * d2);
        }
        if (0 < pts && pts < point.length) {
            double scale = (double)point.length / (double)pts;
            sqr *= scale;
        }
        return sqr;
    }

    public static double KMeans_distance(double[] center, double[] point, String[][] domains) {
        double sqr = 0.0;
        int pts = point.length;
        for (int column = 0; column < center.length; ++column) {
            double d2 = point[column];
            if (Double.isNaN(d2)) {
                --pts;
                continue;
            }
            if (domains[column] != null) {
                if (d2 == center[column]) continue;
                sqr += 1.0;
                continue;
            }
            double delta = d2 - center[column];
            sqr += delta * delta;
        }
        if (0 < pts && pts < point.length) {
            sqr *= (double)point.length / (double)pts;
        }
        return sqr;
    }

    public static double log_rescale(double[] preds) {
        double maxval = Double.NEGATIVE_INFINITY;
        for (int k2 = 1; k2 < preds.length; ++k2) {
            maxval = Math.max(maxval, preds[k2]);
        }
        assert (!Double.isInfinite(maxval)) : "Something is wrong with GBM trees since returned prediction is " + Arrays.toString(preds);
        double dsum = 0.0;
        for (int k3 = 1; k3 < preds.length; ++k3) {
            preds[k3] = Math.exp(preds[k3] - maxval);
            dsum += preds[k3];
        }
        return dsum;
    }

    public static void GBM_rescale(double[] preds) {
        double sum = GenModel.log_rescale(preds);
        int k2 = 1;
        while (k2 < preds.length) {
            int n2 = k2++;
            preds[n2] = preds[n2] / sum;
        }
    }

    public static double GLM_identityInv(double x2) {
        return x2;
    }

    public static double GLM_logitInv(double x2) {
        return 1.0 / (Math.exp(-x2) + 1.0);
    }

    public static double GLM_logInv(double x2) {
        return Math.exp(x2);
    }

    public static double GLM_inverseInv(double x2) {
        double xx = x2 < 0.0 ? Math.min(-1.0E-5, x2) : Math.max(1.0E-5, x2);
        return 1.0 / xx;
    }

    public static double GLM_ologitInv(double x2) {
        return GenModel.GLM_logitInv(x2);
    }

    public static double GLM_tweedieInv(double x2, double tweedie_link_power) {
        return tweedie_link_power == 0.0 ? Math.max(2.0E-16, Math.exp(x2)) : Math.pow(x2, 1.0 / tweedie_link_power);
    }

    public String getHeader() {
        return null;
    }

    public static void setInput(double[] from, float[] to, int _nums, int _cats, int[] _catOffsets, double[] _normMul, double[] _normSub, boolean useAllFactorLevels, boolean replaceMissingWithZero) {
        int i2;
        double[] nums = new double[_nums];
        int[] cats = new int[_cats];
        GenModel.setCats(from, nums, cats, _cats, _catOffsets, _normMul, _normSub, useAllFactorLevels);
        assert (to.length == _nums + _catOffsets[_cats]);
        Arrays.fill(to, 0.0f);
        for (i2 = 0; i2 < _cats; ++i2) {
            if (cats[i2] < 0) continue;
            to[cats[i2]] = 1.0f;
        }
        for (i2 = 0; i2 < _nums; ++i2) {
            to[_catOffsets[_cats] + i2] = Double.isNaN(nums[i2]) ? (replaceMissingWithZero ? 0.0f : Float.NaN) : (float)nums[i2];
        }
    }

    public static void setInput(double[] from, double[] to, double[] nums, int[] cats, int _nums, int _cats, int[] _catOffsets, double[] _normMul, double[] _normSub, boolean useAllFactorLevels, boolean replaceMissingWithZero) {
        int i2;
        GenModel.setCats(from, nums, cats, _cats, _catOffsets, _normMul, _normSub, useAllFactorLevels);
        assert (to.length == _nums + _catOffsets[_cats]);
        Arrays.fill(to, 0.0);
        for (i2 = 0; i2 < _cats; ++i2) {
            if (cats[i2] < 0) continue;
            to[cats[i2]] = 1.0;
        }
        for (i2 = 0; i2 < _nums; ++i2) {
            to[_catOffsets[_cats] + i2] = Double.isNaN(nums[i2]) ? (replaceMissingWithZero ? 0.0 : Double.NaN) : nums[i2];
        }
    }

    public static void setCats(double[] from, double[] nums, int[] cats, int _cats, int[] _catOffsets, double[] _normMul, double[] _normSub, boolean useAllFactorLevels) {
        GenModel.setCats(from, cats, _cats, _catOffsets, useAllFactorLevels);
        for (int i2 = _cats; i2 < from.length; ++i2) {
            double d2 = from[i2];
            if (_normMul != null && _normMul.length > 0) {
                d2 = (d2 - _normSub[i2 - _cats]) * _normMul[i2 - _cats];
            }
            nums[i2 - _cats] = d2;
        }
    }

    public static void setCats(double[] from, int[] to, int cats, int[] catOffsets, boolean useAllFactorLevels) {
        for (int i2 = 0; i2 < cats; ++i2) {
            if (Double.isNaN(from[i2])) {
                to[i2] = catOffsets[i2 + 1] - 1;
                continue;
            }
            int c2 = (int)from[i2];
            to[i2] = useAllFactorLevels ? c2 + catOffsets[i2] : (c2 != 0 ? c2 - 1 + catOffsets[i2] : -1);
            if (to[i2] < catOffsets[i2 + 1]) continue;
            to[i2] = catOffsets[i2 + 1] - 1;
        }
    }

    public static float[] convertDouble2Float(double[] input) {
        int arraySize = input.length;
        float[] output = new float[arraySize];
        for (int index = 0; index < arraySize; ++index) {
            output[index] = (float)input[index];
        }
        return output;
    }

    public static void img2pixels(BufferedImage img, int w2, int h2, int channels, float[] pixels, int start, float[] mean) throws IOException {
        BufferedImage scaledImg = new BufferedImage(w2, h2, img.getType());
        Graphics2D g2d = scaledImg.createGraphics();
        g2d.drawImage(img, 0, 0, w2, h2, null);
        g2d.dispose();
        int r_idx = start;
        int g_idx = r_idx + w2 * h2;
        int b_idx = g_idx + w2 * h2;
        for (int i2 = 0; i2 < h2; ++i2) {
            for (int j2 = 0; j2 < w2; ++j2) {
                Color mycolor = new Color(scaledImg.getRGB(j2, i2));
                int red = mycolor.getRed();
                int green = mycolor.getGreen();
                int blue = mycolor.getBlue();
                if (channels == 1) {
                    pixels[r_idx] = (red + green + blue) / 3;
                    if (mean != null) {
                        int n2 = r_idx;
                        pixels[n2] = pixels[n2] - mean[r_idx];
                    }
                } else {
                    pixels[r_idx] = red;
                    pixels[g_idx] = green;
                    pixels[b_idx] = blue;
                    if (mean != null) {
                        int n3 = r_idx;
                        pixels[n3] = pixels[n3] - mean[r_idx - start];
                        int n4 = g_idx;
                        pixels[n4] = pixels[n4] - mean[g_idx - start];
                        int n5 = b_idx;
                        pixels[n5] = pixels[n5] - mean[b_idx - start];
                    }
                }
                ++r_idx;
                ++g_idx;
                ++b_idx;
            }
        }
    }

    @Deprecated
    public GenModel internal_threadSafeInstance() {
        return this;
    }
}

