/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel;

import hex.genmodel.FolderMojoReaderBackend;
import hex.genmodel.InMemoryMojoReaderBackend;
import hex.genmodel.MojoReaderBackend;
import hex.genmodel.TmpMojoReaderBackend;
import hex.genmodel.ZipfileMojoReaderBackend;
import hex.genmodel.utils.IOUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class MojoReaderBackendFactory {
    public static MojoReaderBackend createReaderBackend(String filename) throws IOException {
        return MojoReaderBackendFactory.createReaderBackend(new File(filename));
    }

    public static MojoReaderBackend createReaderBackend(File file) throws IOException {
        if (file.isFile()) {
            return new ZipfileMojoReaderBackend(file.getPath());
        }
        if (file.isDirectory()) {
            return new FolderMojoReaderBackend(file.getPath());
        }
        throw new IOException("Invalid file specification: " + file);
    }

    public static MojoReaderBackend createReaderBackend(URL url, CachingStrategy cachingStrategy) throws IOException {
        try (InputStream is = url.openStream();){
            MojoReaderBackend mojoReaderBackend = MojoReaderBackendFactory.createReaderBackend(is, cachingStrategy);
            return mojoReaderBackend;
        }
    }

    public static MojoReaderBackend createReaderBackend(InputStream inputStream, CachingStrategy cachingStrategy) throws IOException {
        switch (cachingStrategy) {
            case MEMORY: {
                return MojoReaderBackendFactory.createInMemoryReaderBackend(inputStream);
            }
            case DISK: {
                return MojoReaderBackendFactory.createTempFileReaderBackend(inputStream);
            }
        }
        throw new IllegalStateException("Unexpected caching strategy: " + (Object)((Object)cachingStrategy));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MojoReaderBackend createInMemoryReaderBackend(InputStream inputStream) throws IOException {
        HashMap<String, byte[]> content = new HashMap<String, byte[]>();
        ZipInputStream zis = new ZipInputStream(inputStream);
        try {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.getSize() > Integer.MAX_VALUE) {
                    throw new IOException("File too large: " + entry.getName());
                }
                ByteArrayOutputStream os2 = new ByteArrayOutputStream();
                IOUtils.copyStream(zis, os2);
                content.put(entry.getName(), os2.toByteArray());
            }
            zis.close();
        }
        finally {
            MojoReaderBackendFactory.closeQuietly(zis);
        }
        return new InMemoryMojoReaderBackend(content);
    }

    private static MojoReaderBackend createTempFileReaderBackend(InputStream inputStream) throws IOException {
        File tmpFile = File.createTempFile("h2o-mojo", ".zip");
        tmpFile.deleteOnExit();
        FileOutputStream fos = new FileOutputStream(tmpFile);
        try {
            IOUtils.copyStream(inputStream, fos);
            fos.close();
        }
        catch (IOException e2) {
            MojoReaderBackendFactory.closeQuietly(fos);
            if (!tmpFile.delete()) {
                e2 = new IOException(e2.getMessage() + " [Note: temp file " + tmpFile + " not deleted]", e2);
            }
            throw e2;
        }
        finally {
            MojoReaderBackendFactory.closeQuietly(fos);
        }
        return new TmpMojoReaderBackend(tmpFile);
    }

    private static void closeQuietly(Closeable c2) {
        if (c2 != null) {
            try {
                c2.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static enum CachingStrategy {
        MEMORY,
        DISK;

    }
}

